/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.input;

import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.input.KeyAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.input.KeyHelperAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import org.jetbrains.annotations.Nullable;

public class KeyHelper {
    public static int applyModifier(int keyCode, KeyAPI.Modifier modifier) {
        KeyHelperAPI api = KeyHelper.getAPI();
        return Objects.nonNull(api) ? api.applyModifier(keyCode, modifier) : -1;
    }

    public static KeyAPI<?> create(String id, String category, KeyAPI.Action action) {
        KeyHelperAPI api = KeyHelper.getAPI();
        return Objects.nonNull(api) ? api.create(id, category, action) : null;
    }

    public static KeyAPI<?> create(String id, String category, KeyAPI.AlphaNum actionKey) {
        KeyHelperAPI api = KeyHelper.getAPI();
        return Objects.nonNull(api) ? api.create(id, category, actionKey) : null;
    }

    public static KeyAPI<?> create(String id, String category, KeyAPI.FNKeys fnKey) {
        KeyHelperAPI api = KeyHelper.getAPI();
        return Objects.nonNull(api) ? api.create(id, category, fnKey) : null;
    }

    public static KeyAPI<?> create(String id, String category, KeyAPI.NumberPad numPadKey) {
        KeyHelperAPI api = KeyHelper.getAPI();
        return Objects.nonNull(api) ? api.create(id, category, numPadKey) : null;
    }

    public static KeyAPI<?> create(String id, String category, KeyAPI.Symbol symbolKey) {
        KeyHelperAPI api = KeyHelper.getAPI();
        return Objects.nonNull(api) ? api.create(id, category, symbolKey) : null;
    }

    public static KeyAPI<?> create(String id, String category, int keyCode) {
        KeyHelperAPI api = KeyHelper.getAPI();
        return Objects.nonNull(api) ? api.create(id, category, keyCode) : null;
    }

    @Nullable
    public static KeyHelperAPI getAPI() {
        return TILRef.getClientSubAPI(ClientAPI::getKeyHelper);
    }

    public static int getKeyCode(KeyAPI.Action actionKey) {
        KeyHelperAPI api = KeyHelper.getAPI();
        return Objects.nonNull(api) ? api.getKeyCode(actionKey) : -1;
    }

    public static int getKeyCode(KeyAPI.AlphaNum alphaNumKey) {
        KeyHelperAPI api = KeyHelper.getAPI();
        return Objects.nonNull(api) ? api.getKeyCode(alphaNumKey) : -1;
    }

    public static int getKeyCode(KeyAPI.FNKeys fnKey) {
        KeyHelperAPI api = KeyHelper.getAPI();
        return Objects.nonNull(api) ? api.getKeyCode(fnKey) : -1;
    }

    public static int getKeyCode(KeyAPI.Modifier modKey) {
        KeyHelperAPI api = KeyHelper.getAPI();
        return Objects.nonNull(api) ? api.getKeyCode(modKey) : -1;
    }

    public static int getKeyCode(KeyAPI.NumberPad numPadKey) {
        KeyHelperAPI api = KeyHelper.getAPI();
        return Objects.nonNull(api) ? api.getKeyCode(numPadKey) : -1;
    }

    public static int getKeyCode(KeyAPI.Symbol symbolKey) {
        KeyHelperAPI api = KeyHelper.getAPI();
        return Objects.nonNull(api) ? api.getKeyCode(symbolKey) : -1;
    }

    public static boolean isArrow(int keyCode) {
        return Misc.equalsAny(keyCode, KeyHelper.getKeyCode(KeyAPI.Action.DOWN), KeyHelper.getKeyCode(KeyAPI.Action.LEFT), KeyHelper.getKeyCode(KeyAPI.Action.RIGHT), KeyHelper.getKeyCode(KeyAPI.Action.UP));
    }

    public static boolean isArrowOrWASD(int keyCode) {
        return Misc.equalsAny(keyCode, KeyHelper.getKeyCode(KeyAPI.Action.DOWN), KeyHelper.getKeyCode(KeyAPI.Action.LEFT), KeyHelper.getKeyCode(KeyAPI.Action.RIGHT), KeyHelper.getKeyCode(KeyAPI.Action.UP), KeyHelper.getKeyCode(KeyAPI.AlphaNum.W), KeyHelper.getKeyCode(KeyAPI.AlphaNum.A), KeyHelper.getKeyCode(KeyAPI.AlphaNum.S), KeyHelper.getKeyCode(KeyAPI.AlphaNum.D));
    }

    public static boolean isWASD(int keyCode) {
        return Misc.equalsAny(keyCode, KeyHelper.getKeyCode(KeyAPI.AlphaNum.W), KeyHelper.getKeyCode(KeyAPI.AlphaNum.A), KeyHelper.getKeyCode(KeyAPI.AlphaNum.S), KeyHelper.getKeyCode(KeyAPI.AlphaNum.D));
    }

    public static KeyAPI<?> register(String id, String category, int keyCode) {
        KeyHelperAPI api = KeyHelper.getAPI();
        if (Objects.isNull(api)) {
            return null;
        }
        return api.register(id, category, keyCode);
    }

    public static void register(KeyAPI<?> key) {
        KeyHelperAPI api = KeyHelper.getAPI();
        if (Objects.nonNull(api)) {
            api.register(key);
        }
    }
}

