/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.render;

import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector4;

public class ColorHelper {
    public static final ColorCache AQUA = ColorCache.of(85, 255, 255);
    public static final ColorCache BLACK = ColorCache.grayscale(0);
    public static final ColorCache BLUE = ColorCache.of(85, 85, 255);
    public static final ColorCache DARK_AQUA = ColorCache.of(0, 170, 170);
    public static final ColorCache DARK_BLUE = ColorCache.of(0, 0, 170);
    public static final ColorCache DARK_GRAY = ColorCache.grayscale(85);
    public static final ColorCache DARK_GREEN = ColorCache.of(0, 170, 0);
    public static final ColorCache DARK_PURPLE = ColorCache.of(170, 0, 170);
    public static final ColorCache DARK_RED = ColorCache.of(170, 0, 0);
    public static final ColorCache GOLD = ColorCache.of(255, 170, 0);
    public static final ColorCache GRAY = ColorCache.grayscale(170);
    public static final ColorCache GREEN = ColorCache.of(85, 255, 85);
    public static final ColorCache LIGHT_PURPLE = ColorCache.of(255, 85, 255);
    public static final ColorCache RED = ColorCache.of(255, 85, 85);
    public static final ColorCache WHITE = ColorCache.grayscale(255);
    public static final ColorCache YELLOW = ColorCache.of(255, 255, 85);

    public static Vector4 convertI(Vector4 color) {
        return new Vector4(Float.valueOf(color.fX() / 255.0f), Float.valueOf(color.fY() / 255.0f), Float.valueOf(color.fZ() / 255.0f), Float.valueOf(color.fW() / 255.0f));
    }

    public static Vector4 convertF(Vector4 color) {
        return new Vector4((int)(color.fX() * 255.0f), (int)(color.fY() * 255.0f), (int)(color.fZ() * 255.0f), (int)(color.fW() * 255.0f));
    }

    public static ColorCache decode(int encoded) {
        return ColorCache.of(encoded >> 16 & 0xFF, encoded >> 8 & 0xFF, encoded & 0xFF, encoded >> 24 & 0xFF);
    }

    public static ColorCache decode(int encoded, float alphaOverride) {
        return ColorCache.of(encoded >> 16 & 0xFF, encoded >> 8 & 0xFF, encoded & 0xFF, alphaOverride);
    }

    public static ColorCache decode(int encoded, int alphaOverride) {
        return ColorCache.of(encoded >> 16 & 0xFF, encoded >> 8 & 0xFF, encoded & 0xFF, alphaOverride);
    }

    public static ColorCache getColor(String color) {
        switch (color.toLowerCase()) {
            case "aqua": {
                return AQUA;
            }
            case "black": {
                return BLACK;
            }
            case "blue": {
                return BLUE;
            }
            case "dark_aqua": {
                return DARK_AQUA;
            }
            case "dark_blue": {
                return DARK_BLUE;
            }
            case "dark_gray": {
                return DARK_GRAY;
            }
            case "dark_green": {
                return DARK_GREEN;
            }
            case "dark_purple": {
                return DARK_PURPLE;
            }
            case "dark_red": {
                return DARK_RED;
            }
            case "gold": {
                return GOLD;
            }
            case "gray": {
                return GRAY;
            }
            case "green": {
                return GREEN;
            }
            case "light_purple": {
                return LIGHT_PURPLE;
            }
            case "red": {
                return RED;
            }
            case "yellow": {
                return YELLOW;
            }
        }
        return WHITE;
    }

    public static int getColorI(String color) {
        return ColorHelper.getColor(color).getColorI();
    }

    public static int getColorI(String color, float alpha) {
        return ColorHelper.getColor(color).getIntWithAlpha(alpha);
    }

    public static int getColorI(String color, int alpha) {
        return ColorHelper.getColor(color).getIntWithAlpha(alpha);
    }

    public static Vector4 getColorVF(String color) {
        return ColorHelper.getColor(color).getColorVF();
    }

    public static Vector4 getColorVF(String color, float alpha) {
        return ColorHelper.getColor(color).getVFWithAlpha(alpha);
    }

    public static Vector4 getColorVF(String color, int alpha) {
        return ColorHelper.getColor(color).getVFWithAlpha(alpha);
    }

    public static Vector4 getColorVI(String color) {
        return ColorHelper.getColor(color).getColorVI();
    }

    public static Vector4 getColorVI(String color, float alpha) {
        return ColorHelper.getColor(color).getVIWithAlpha(alpha);
    }

    public static Vector4 getColorVI(String color, int alpha) {
        return ColorHelper.getColor(color).getVIWithAlpha(alpha);
    }

    public static int makeARGBIntF(Vector4 colors) {
        return ColorHelper.makeARGBInt(colors.fX(), colors.fY(), colors.fZ(), colors.fW());
    }

    public static int makeARGBIntI(Vector4 colors) {
        return ColorHelper.makeARGBInt(colors.iX(), colors.iY(), colors.iZ(), colors.iW());
    }

    public static int makeARGBInt(float r, float g, float b, float a) {
        return ColorHelper.makeARGBInt((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    public static int makeARGBInt(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static ColorCache reverse(ColorCache color) {
        return new ColorCache(ColorHelper.reverseF(color.getColorVF()));
    }

    public static ColorCache reverse(ColorCache color, float alpha) {
        return ColorHelper.reverse(color).withAlpha(alpha);
    }

    public static ColorCache reverse(ColorCache color, int alpha) {
        return ColorHelper.reverse(color).withAlpha(alpha);
    }

    public static Vector4 reverseF(Vector4 colors) {
        return new Vector4(Float.valueOf(Math.abs(colors.fX() - 1.0f)), Float.valueOf(Math.abs(colors.fY() - 1.0f)), Float.valueOf(Math.abs(colors.fZ() - 1.0f)), Float.valueOf(colors.fW()));
    }

    public static Vector4 reverseI(Vector4 colors) {
        return new Vector4(Math.abs(colors.iX() - 255), Math.abs(colors.iY() - 255), Math.abs(colors.iZ() - 255), colors.iW());
    }

    public static void setStateColorF(RenderAPI renderer, Vector4 color) {
        ColorHelper.setStateColor(renderer, color.fX(), color.fY(), color.fZ(), color.fW());
    }

    public static void setStateColorI(RenderAPI renderer, Vector4 color) {
        ColorHelper.setStateColor(renderer, color.iX(), color.iY(), color.iZ(), color.iW());
    }

    public static void setStateColor(RenderAPI renderer, int r, int g, int b, int a) {
        ColorHelper.setStateColor(renderer, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public static void setStateColor(RenderAPI renderer, float r, float g, float b, float a) {
        renderer.setColor(r, g, b, a);
    }
}

