/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.render;

import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.FuzzBall;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderShape;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Shape;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;

public class RenderFuzz
extends RenderShape {
    protected FuzzBall fuzz;

    public static RenderFuzz from(Shape shape) {
        return RenderFuzz.from(shape, 2, 10, 1.0f, 1.0f, null);
    }

    public static RenderFuzz from(Shape shape, int max) {
        return RenderFuzz.from(shape, 2, max, 1.0f, 1.0f, null);
    }

    public static RenderFuzz from(Shape shape, Vector2 counts) {
        return RenderFuzz.from(shape, counts.iX(), counts.iY(), 1.0f, 1.0f, null);
    }

    public static RenderFuzz from(Shape shape, int minCount, int maxCount) {
        return RenderFuzz.from(shape, minCount, maxCount, 1.0f, 1.0f, null);
    }

    public static RenderFuzz from(Shape shape, Vector2 counts, Vector2 widths) {
        return RenderFuzz.from(shape, counts.iX(), counts.iY(), widths.fX(), widths.fY(), null);
    }

    public static RenderFuzz from(Shape shape, int minCount, int maxCount, float minWidth, float maxWidth) {
        return RenderFuzz.from(shape, minCount, maxCount, minWidth, maxWidth, null);
    }

    public static RenderFuzz from(Shape shape, Vector2 counts, Vector2 widths, Supplier<ColorCache> color) {
        return RenderFuzz.from(shape, counts.iX(), counts.iY(), widths.fX(), widths.fY(), color);
    }

    public static RenderFuzz from(Shape shape, int minCount, int maxCount, float minWidth, float maxWidth, Supplier<ColorCache> color) {
        maxCount = Math.max(3, maxCount);
        if ((minCount = Math.max(2, minCount)) > maxCount) {
            minCount = maxCount;
        }
        if ((minWidth = Math.max(0.1f, minWidth)) > (maxWidth = Math.min(10.0f, maxWidth))) {
            minWidth = maxWidth;
        }
        return new RenderFuzz(shape, minCount, maxCount, minWidth, maxWidth, color);
    }

    public RenderFuzz(Shape shape, int minCount, int maxCount, float minWidth, float maxWidth, Supplier<ColorCache> color) {
        super(shape, ColorHelper.WHITE);
        this.fuzz = shape.makeFuzzBall(minCount, maxCount, minWidth, maxWidth, color);
    }

    @Override
    public RenderFuzz copy() {
        RenderFuzz fuzz = (RenderFuzz)super.copy();
        fuzz.fuzz = Objects.nonNull(this.fuzz) ? this.fuzz.copy() : null;
        return fuzz;
    }

    @Override
    public void draw(RenderContext ctx, Vector3 center) {
        if (Objects.nonNull(this.fuzz)) {
            RenderAPI renderer = ctx.getRenderer();
            renderer.translate(0.0, 0.0, -10.0);
            this.fuzz.draw(ctx, center);
            renderer.translate(0.0, 0.0, 10.0);
        }
    }

    @Generated
    public FuzzBall getFuzz() {
        return this.fuzz;
    }

    @Generated
    public void setFuzz(FuzzBall fuzz) {
        this.fuzz = fuzz;
    }
}

