/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.test;

import java.io.InputStream;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.input.KeyAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.input.KeyHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderablePNG;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderableText;
import mods.thecomputerizer.theimpossiblelibrary.api.client.test.TestScreen;
import mods.thecomputerizer.theimpossiblelibrary.api.common.test.TestsAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;

public class ClientTests
extends TestsAPI {
    public static final KeyAPI<?> TEST_KEY = KeyHelper.create("key.test", "key.categories.theimpossiblelibrary", KeyAPI.AlphaNum.L);
    private static final boolean GUI = true;
    private static final boolean RENDERABLE = false;
    private static final boolean TOML = false;

    public static void runTests(Object ... args) {
        TILRef.logInfo("Initializing client tests", new Object[0]);
        new ClientTests().runAndLog(args);
    }

    private ClientTests() {
        super("Client");
    }

    private boolean guiTest() {
        this.logDebug("Running GUI test", new Object[0]);
        ScreenHelper.open(TestScreen::new);
        return true;
    }

    private boolean renderableTest() {
        try {
            this.logDebug("Running Renderable tests", new Object[0]);
            ResourceLocationAPI<?> testLocation = TILRef.res("test/transitions.toml");
            InputStream stream = ResourceHelper.getResourceStream(testLocation);
            Toml transitions = Toml.readStream(stream);
            if (!this.renderableTitleTest(transitions) || !this.renderableImageTest(transitions)) {
                return false;
            }
        }
        catch (Exception ex) {
            this.logError("Renderable test failed!", ex);
            return false;
        }
        return true;
    }

    private boolean renderableTitleTest(Toml transitions) {
        this.logDebug("Running Renderable title test", new Object[0]);
        RenderableText title = new RenderableText(transitions.getTable("title").parameterizeEntries());
        RenderHelper.addRenderable(title);
        return true;
    }

    private boolean renderableImageTest(Toml transitions) {
        this.logDebug("Running Renderable image test", new Object[0]);
        Toml image = transitions.getTable("image");
        ResourceLocationAPI<?> location = TILRef.res(image.getValueString("name"));
        RenderablePNG png = RenderHelper.initPNG(location, image.parameterizeEntries());
        RenderHelper.addRenderable(png);
        return true;
    }

    @Override
    protected boolean run(Object ... args) {
        this.logDebug("Running tests", new Object[0]);
        return this.guiTest();
    }

    private boolean tomlTest() {
        return true;
    }
}

