/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.test;

import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.BasicTypeableWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.BasicWidgetGroup;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Button;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.ShapeWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.TextWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.WidgetGroup;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.WidgetList;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderShape;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.Facing;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Circle;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Plane;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Shape;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.ShapeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.RandomHelper;

public class TestScreen
extends ScreenAPI {
    private final TextWidget clicked;
    private Shape testShape;
    private ColorCache testShapeColor;
    private boolean coloredFuzz;

    public TestScreen(int guiScale) {
        super(TextHelper.getLiteral("test"), ClientHelper.getWindow(), guiScale);
        this.addFuzz(5, 100, 6.0f, 10.0f);
        this.clicked = TextWidget.literal("0", -0.75, 0.75).setColor(ColorHelper.BLUE);
        this.addScrollableMenu(100, 1.8, 1.8);
        this.addWidget(this.clicked);
        this.addWidget(BasicTypeableWidget.literal("Text Box!", ColorHelper.RED, 0.0, 0.95));
    }

    private void addBox(double scale, ColorCache color) {
        this.testShape = ShapeHelper.plane(Facing.Axis.Y, scale);
        this.testShapeColor = color;
    }

    private void addFuzz(int minCount, int maxCount, float minWidth, float maxWidth) {
        this.addWidget(ShapeWidget.fuzz((Shape)ShapeHelper.square(Facing.Axis.Y, 2.0, 1.0), minCount, maxCount, minWidth, maxWidth, () -> ColorCache.of(this.coloredFuzz ? RandomHelper.randomFloat(0.6f, 1.0f) : 0.0f, this.coloredFuzz ? 0.5f : 0.0f, this.coloredFuzz ? 0.5f : 0.0f, this.coloredFuzz ? 1.0f : RandomHelper.randomFloat(0.75f, 1.0f))));
    }

    private void addRadialMenu(double heightRatio, int slices) {
        Circle circle = ShapeHelper.circle(Facing.Axis.Y, 0.65, 0.35, heightRatio);
        WidgetGroup radialMenu = Button.radialGroup(circle, 0.0, 0.0, slices, 0.0, (i, button) -> {
            button.getShape().setColor(ColorHelper.BLACK);
            ShapeWidget texture = ShapeWidget.from((Shape)ShapeHelper.square(Facing.Axis.Y, 0.25, heightRatio), TILRef.res("test/logo.png"));
            Vector3 pos = button.getShape().getCenterForGroup(VectorHelper.zero3D());
            texture.setX(pos.dX());
            texture.setY(pos.dY());
            button.addWidget(texture);
            button.addHoverLine(TextHelper.getLiteral("test hover " + i));
            button.setClickFunc(b -> {
                this.coloredFuzz = !this.coloredFuzz;
            });
            button.setHover(BasicWidgetGroup.from(ShapeWidget.of(RenderShape.from((Shape)button.getShape().getWrapped().getWrapped()), 0.0, 0.0), texture));
        });
        this.addWidget(radialMenu);
        this.addWidget(ShapeWidget.outlineFrom((Shape)circle.getScaled(0.46153846153846156), 10.0f));
        this.addWidget(ShapeWidget.outlineFrom((Shape)circle.getScaled(1.1), 10.0f));
    }

    private void addScrollableMenu(int size, double width, double height) {
        WidgetList list = WidgetList.from(Button.colored(ColorHelper.BLACK, TextHelper.getLiteral("template"), new TextAPI[0]), 0.0, 0.0, width, height, 0.05);
        Plane shape = (Plane)((Button)list.getElementTemplate()).getShape().getWrapped().getWrapped();
        double scaleRatio = ((double)this.guiScale + 1.0) / 2.0;
        shape.setScales(scaleRatio, scaleRatio);
        for (int i = 0; i < size; ++i) {
            list.addWidgetFromTemplate((template, index) -> {
                Button button = (Button)template;
                String indexStr = index == 3 ? "33333333333333333333333333333333333333" : String.valueOf(index);
                String literally = "element " + indexStr;
                button.setText(literally);
                button.setHoverText(text -> text.setText(literally));
                button.addHoverLine(TextHelper.getLiteral("hover " + indexStr));
                button.setClickFunc(b -> this.clicked.setText(indexStr));
            });
        }
        this.addWidget(ShapeWidget.from((Shape)ShapeHelper.square(Facing.Axis.Y, 1.8, 1.0), ColorHelper.LIGHT_PURPLE.withAlpha(0.5f)));
        this.addWidget(list);
        this.addWidget(ShapeWidget.outlineFrom((Shape)ShapeHelper.square(Facing.Axis.Y, 1.8, 1.0), ColorHelper.WHITE, 4.0f));
    }

    @Override
    public void draw(RenderContext ctx, Vector3 center, double mouseX, double mouseY) {
        if (Objects.nonNull(this.testShape)) {
            ColorCache color;
            ColorCache colorCache = color = Objects.nonNull(this.testShapeColor) ? this.testShapeColor : ColorHelper.WHITE;
            if (this.testShape instanceof Plane) {
                ctx.drawColoredPlaneTest(center, (Plane)this.testShape, color);
            }
        }
        super.draw(ctx, center, mouseX, mouseY);
    }
}

