/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.common.event;

import java.util.Objects;
import java.util.function.Consumer;
import mods.thecomputerizer.theimpossiblelibrary.api.client.event.ClientEventHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.event.ClientEventsAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.event.types.ClientOverlayEventType;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.common.CommonAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.Facing;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.CommonEventsAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.EventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ActionResult;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.Hand;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.server.event.ServerEventHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import org.jetbrains.annotations.Nullable;

public class EventHelper {
    public static <E extends EventWrapper<?>> void addListener(EventWrapper.EventType<E> type, Consumer<E> invoker) {
        CommonEventsAPI api = EventHelper.getEventsAPI(type.isClient(), type.isServer());
        if (!api.isDefined()) {
            api.defineEvents();
        }
        type.addInvoker(invoker);
    }

    public static <A> Box getAABB(A aabb) {
        return EventHelper.getAABB(false, false, aabb);
    }

    public static <A> Box getAABB(EventWrapper.EventType<?> type, A aabb) {
        return EventHelper.getAABB(type.isClient(), type.isServer(), aabb);
    }

    public static <A> Box getAABB(boolean client, A aabb) {
        return EventHelper.getAABB(client, false, aabb);
    }

    public static <A> Box getAABB(boolean client, boolean server, A aabb) {
        return EventHelper.getEventsAPI(client, server).getAABB(aabb);
    }

    public static <A> ActionResult getActionResult(A result) {
        return EventHelper.getActionResult(false, false, result);
    }

    public static <A> ActionResult getActionResult(EventWrapper.EventType<?> type, A result) {
        return EventHelper.getActionResult(type.isClient(), type.isServer(), result);
    }

    public static <A> ActionResult getActionResult(boolean client, A result) {
        return EventHelper.getActionResult(client, false, result);
    }

    public static <A> ActionResult getActionResult(boolean client, boolean server, A result) {
        return EventHelper.getEventsAPI(client, server).getActionResult(result);
    }

    public static CommonEventsAPI getCommonEventsAPI() {
        return TILRef.getCommonSubAPI(CommonAPI::getCommonEvents);
    }

    public static <E> EventWrapper.Result getEventResult(E result) {
        return EventHelper.getEventResult(false, false, result);
    }

    public static <E> EventWrapper.Result getEventResult(EventWrapper.EventType<?> type, E result) {
        return EventHelper.getEventResult(type.isClient(), type.isServer(), result);
    }

    public static <E> EventWrapper.Result getEventResult(boolean client, E result) {
        return EventHelper.getEventsAPI(client, false).getEventResult(result);
    }

    public static <E> EventWrapper.Result getEventResult(boolean client, boolean server, E result) {
        return EventHelper.getEventsAPI(client, server).getEventResult(result);
    }

    public static CommonEventsAPI getEventsAPI(boolean client, boolean server) {
        return client ? ClientEventHelper.getEventsAPI() : (server ? ServerEventHelper.getEventsAPI() : EventHelper.getCommonEventsAPI());
    }

    @Nullable
    public static <D> Facing getFacing(@Nullable D direction) {
        return EventHelper.getFacing(false, false, direction);
    }

    @Nullable
    public static <D> Facing getFacing(EventWrapper.EventType<?> type, @Nullable D direction) {
        return EventHelper.getFacing(type.isClient(), type.isServer(), direction);
    }

    @Nullable
    public static <D> Facing getFacing(boolean client, @Nullable D direction) {
        return EventHelper.getFacing(client, false, direction);
    }

    @Nullable
    public static <D> Facing getFacing(boolean client, boolean server, @Nullable D direction) {
        return EventHelper.getEventsAPI(client, server).getFacing(direction);
    }

    public static <H> Hand getHand(H hand) {
        return EventHelper.getHand(false, false, hand);
    }

    public static <H> Hand getHand(EventWrapper.EventType<?> type, H hand) {
        return EventHelper.getHand(type.isClient(), type.isServer(), hand);
    }

    public static <H> Hand getHand(boolean client, H hand) {
        return EventHelper.getHand(client, false, hand);
    }

    public static <H> Hand getHand(boolean client, boolean server, H hand) {
        return EventHelper.getEventsAPI(client, server).getHand(hand);
    }

    public static <B> ClientOverlayEventType.OverlayType getOverlayBlockType(B blockType) {
        return ((ClientEventsAPI)EventHelper.getEventsAPI(true, false)).getOverlayBlockType(blockType);
    }

    public static <E> ClientOverlayEventType.OverlayType getOverlayElementType(E elementType) {
        return ((ClientEventsAPI)EventHelper.getEventsAPI(true, false)).getOverlayElementType(elementType);
    }

    public static CommonEventsAPI getServerEventsAPI() {
        return TILRef.getCommonSubAPI(CommonAPI::getCommonEvents);
    }

    public static <V> Vector3 getVec3d(V vector) {
        return EventHelper.getVec3d(false, false, vector);
    }

    public static <V> Vector3 getVec3d(EventWrapper.EventType<?> type, V vector) {
        return EventHelper.getVec3d(type.isClient(), type.isServer(), vector);
    }

    public static <V> Vector3 getVec3d(boolean client, V vector) {
        return EventHelper.getVec3d(client, false, vector);
    }

    public static <V> Vector3 getVec3d(boolean client, boolean server, V vector) {
        return EventHelper.getEventsAPI(client, server).getVec3d(vector);
    }

    public static RenderContext initRenderer(Consumer<RenderContext> setters) {
        return ((ClientEventsAPI)EventHelper.getEventsAPI(true, false)).initRenderer(setters);
    }

    private static void initTILCommonListeners(boolean test) {
    }

    public static void initTILListeners(boolean client, boolean common, boolean server, boolean test) {
        if (client) {
            ClientEventHelper.initTILClientListeners(test);
        }
        if (common) {
            EventHelper.initTILCommonListeners(test);
        }
        if (server) {
            ServerEventHelper.initTILServerListeners(test);
        }
    }

    public static <E extends EventWrapper<?>> void registerWrapperImpl(E wrapper) {
        CommonEventsAPI api = EventHelper.getEventsAPI(wrapper.isClient(), wrapper.isServer());
        if (Objects.nonNull(api)) {
            api.register(wrapper);
        }
    }

    public static <A> A setAABB(Box box) {
        return EventHelper.setAABB(false, false, box);
    }

    public static <A> A setAABB(EventWrapper.EventType<?> type, Box box) {
        return EventHelper.setAABB(type.isClient(), type.isServer(), box);
    }

    public static <A> A setAABB(boolean client, Box box) {
        return EventHelper.setAABB(client, false, box);
    }

    public static <A> A setAABB(boolean client, boolean server, Box box) {
        return EventHelper.getEventsAPI(client, server).setAABB(box);
    }

    public static <A> A setActionResult(Object result) {
        return EventHelper.setActionResult(false, false, result);
    }

    public static <A> A setActionResult(EventWrapper.EventType<?> type, Object result) {
        return EventHelper.setActionResult(type.isClient(), type.isServer(), result);
    }

    public static <A> A setActionResult(boolean client, Object result) {
        return EventHelper.setActionResult(client, false, result);
    }

    public static <A> A setActionResult(boolean client, boolean server, Object result) {
        return EventHelper.getEventsAPI(client, server).setActionResult((ActionResult)((Object)result));
    }

    public static <E> E setEventResult(Object result) {
        return EventHelper.setEventResult(false, false, result);
    }

    public static <E> E setEventResult(EventWrapper.EventType<?> type, Object result) {
        return EventHelper.setEventResult(type.isClient(), type.isServer(), result);
    }

    public static <E> E setEventResult(boolean client, Object result) {
        return EventHelper.setEventResult(client, false, result);
    }

    public static <E> E setEventResult(boolean client, boolean server, Object result) {
        return EventHelper.getEventsAPI(client, server).setEventResult((EventWrapper.Result)((Object)result));
    }

    @Nullable
    public static <D> D setFacing(@Nullable Facing facing) {
        return EventHelper.setFacing(false, false, facing);
    }

    @Nullable
    public static <D> D setFacing(EventWrapper.EventType<?> type, @Nullable Facing facing) {
        return EventHelper.setFacing(type.isClient(), type.isServer(), facing);
    }

    @Nullable
    public static <D> D setFacing(boolean client, @Nullable Facing facing) {
        return EventHelper.setFacing(client, false, facing);
    }

    @Nullable
    public static <D> D setFacing(boolean client, boolean server, @Nullable Facing facing) {
        return EventHelper.getEventsAPI(client, server).setFacing(facing);
    }

    public static <H> H setHand(Hand hand) {
        return EventHelper.setHand(false, false, hand);
    }

    public static <H> H setHand(EventWrapper.EventType<?> type, Hand hand) {
        return EventHelper.setHand(type.isClient(), type.isServer(), hand);
    }

    public static <H> H setHand(boolean client, Hand hand) {
        return EventHelper.setHand(client, false, hand);
    }

    public static <H> H setHand(boolean client, boolean server, Hand hand) {
        return EventHelper.getEventsAPI(client, server).setHand(hand);
    }

    public static <V> V setVec3d(Vector3 vector) {
        return EventHelper.setVec3d(false, false, vector);
    }

    public static <V> V setVec3d(EventWrapper.EventType<?> type, Vector3 vector) {
        return EventHelper.setVec3d(type.isClient(), type.isServer(), vector);
    }

    public static <V> V setVec3d(boolean client, Vector3 vector) {
        return EventHelper.setVec3d(client, false, vector);
    }

    public static <V> V setVec3d(boolean client, boolean server, Vector3 vector) {
        return EventHelper.getEventsAPI(client, server).setVec3d(vector);
    }
}

