/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.common.event.types;

import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.DamageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.EventFieldWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import org.jetbrains.annotations.Nullable;

public interface CommonDamageEventType<E> {
    public E getSource();

    default public float getDamageAmount() {
        DamageAPI<?> api = this.getDamageAPI();
        return Objects.nonNull(api) ? api.getAmount() : 0.0f;
    }

    @Nullable
    default public DamageAPI<?> getDamageAPI() {
        E source = this.getSource();
        if (Objects.isNull(source)) {
            return null;
        }
        EventFieldWrapper<E, DamageAPI<?>> damageField = this.getDamageField();
        return Objects.nonNull(damageField) ? damageField.get(this.getSource()) : null;
    }

    @Nullable
    public EventFieldWrapper<E, DamageAPI<?>> getDamageField();

    default public void setDamageAmount(float amount) {
        EventFieldWrapper<E, DamageAPI<?>> damageField = this.getDamageField();
        if (Objects.isNull(damageField)) {
            return;
        }
        E source = this.getSource();
        if (Objects.isNull(source)) {
            return;
        }
        DamageAPI<?> api = damageField.get(source);
        if (Objects.nonNull(api)) {
            damageField.set(source, WrapperHelper.wrapDamage(api.getWrapped(), amount));
        }
    }
}

