/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.JVMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import org.apache.logging.log4j.Logger;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.jetbrains.annotations.Nullable;

public class Hacks {
    static final String SELF_NAME = "mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks";
    static final Logger LOGGER = TILRef.createLogger("TIL Hacks (BurningWave)");
    static boolean burningWaveInit;
    static boolean initializedEnvironment;
    static boolean namedEnv;
    static boolean srgEnv;

    @IndirectCallers
    public static <V> boolean addToCollectionField(String field, V value, Function<String, Collection<V>> collectionGetter) {
        return Hacks.addToCollectionField(field, value, collectionGetter, null);
    }

    public static <V> boolean addToCollectionField(String field, V value, Function<String, Collection<V>> collectionGetter, @Nullable BiConsumer<String, Collection<V>> afterAdd) {
        Collection<V> collection = collectionGetter.apply(field);
        boolean added = collection.add(value);
        if (Objects.nonNull(afterAdd)) {
            afterAdd.accept(field, collection);
        }
        return added;
    }

    @IndirectCallers
    public static <V> boolean addToCollectionField(String field, Collection<V> values, Function<String, Collection<V>> collectionGetter) {
        return Hacks.addToCollectionField(field, values, collectionGetter, null);
    }

    public static <V> boolean addToCollectionField(String field, Collection<V> values, Function<String, Collection<V>> collectionGetter, @Nullable BiConsumer<String, Collection<V>> afterAdd) {
        Collection<V> collection = collectionGetter.apply(field);
        boolean added = collection.addAll(values);
        if (Objects.nonNull(afterAdd)) {
            afterAdd.accept(field, collection);
        }
        return added;
    }

    @IndirectCallers
    public static <K, V> V addToMapField(String field, K key, V value, Function<String, Map<K, V>> mapGetter) {
        return Hacks.addToMapField(field, key, value, mapGetter, null);
    }

    public static <K, V> V addToMapField(String field, K key, V value, Function<String, Map<K, V>> mapGetter, @Nullable BiConsumer<String, Map<K, V>> afterAdd) {
        Map<K, V> map = mapGetter.apply(field);
        V replacedValue = map.put(key, value);
        if (Objects.nonNull(afterAdd)) {
            afterAdd.accept(field, map);
        }
        return replacedValue;
    }

    static Map<?, ?> burningWaveProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("banner.hide", "true");
        String driverName = JVMHelper.hasNativeAccess() ? "Native" : "Hybrid";
        properties.put("jvm.driver.type", "org.burningwave.jvm." + driverName + "Driver");
        properties.put("managed-logger.repository.enabled", "false");
        properties.put("priority-of-this-configuration", "1000");
        properties.put("resource-releaser.enabled", "false");
        return properties;
    }

    public static <T> T callOnOtherClassLoader(ClassLoader loader, String method, Object ... args) {
        boolean staticCall = method.contains("static") || method.contains("Static");
        Class[] argClasses = new Class[]{staticCall ? Class.class : Object.class, String.class, Object[].class};
        if (method.contains("field") || method.contains("Field")) {
            argClasses[2] = Object.class;
        }
        return Hacks.callOnOtherClassLoader(loader, method, argClasses, args);
    }

    public static <T> T callOnOtherClassLoader(ClassLoader loader, String method, Class<?>[] argClasses, Object ... args) {
        try {
            Class<?> c = Class.forName(SELF_NAME, false, loader);
            return (T)c.getDeclaredMethod(method, argClasses).invoke(null, args);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to call {}#{} on ClassLoader {} with args {}", (Object)SELF_NAME, (Object)method, (Object)loader, (Object)args);
            t.printStackTrace(System.err);
            return null;
        }
    }

    public static void checkBurningWaveInit() {
        Hacks.checkBurningWaveInit(false);
    }

    public static void checkBurningWaveInit(boolean disableWarning) {
        if (!burningWaveInit) {
            try {
                StaticComponentContainer.Configuration.Default.add(Hacks.burningWaveProperties());
            }
            catch (Throwable t) {
                if (disableWarning) {
                    LOGGER.debug("Tried to set default BurningWave properties twice");
                }
                LOGGER.warn("Tried to set default BurningWave properties twice");
            }
            burningWaveInit = true;
        }
    }

    public static <T> T checkBurningWaveInitAndCall(String method, Object ... args) {
        return Hacks.checkBurningWaveInitAndCall(false, method, args);
    }

    public static <T> T checkBurningWaveInitAndCall(boolean disableWarning, String method, Object ... args) {
        Hacks.checkBurningWaveInit(disableWarning);
        return Hacks.invokeStatic(Hacks.class, method, args);
    }

    private static void checkEnvironmentInit() {
        if (!initializedEnvironment) {
            try {
                namedEnv = CoreAPI.isNamedEnv();
                srgEnv = CoreAPI.isSrgEnv();
                initializedEnvironment = true;
            }
            catch (Throwable t) {
                LOGGER.fatal("Failed to initialize environment-dependent checks!", t);
            }
        }
    }

    public static <T> T construct(String targetClass, Object ... args) {
        return Hacks.construct(Hacks.findClass(targetClass), args);
    }

    public static <T> T construct(Class<T> target, Object ... args) {
        if (Objects.isNull(target)) {
            LOGGER.error("Tried to call construct on null target class! (args = {})", args);
            return null;
        }
        try {
            return StaticComponentContainer.Constructors.newInstanceOf(target, args);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to contruct {} with args {}", target, (Object)args);
            throw t;
        }
    }

    public static <T> T constructAndCast(Class<?> target, Object ... args) {
        return GenericUtils.cast(Hacks.construct(target, args));
    }

    @IndirectCallers
    public static <T> T constructDirect(String targetClass, Object ... args) {
        return Hacks.constructDirect(Hacks.findClass(targetClass), args);
    }

    @IndirectCallers
    public static <T> T constructDirect(Class<?> reference, String targetClass, Object ... args) {
        return Hacks.constructDirect(Hacks.findClass(reference, targetClass), args);
    }

    public static <T> T constructDirect(Class<?> target, Object ... args) {
        if (Objects.isNull(target)) {
            LOGGER.error("Tried to call constructDirect on null target class! (args = {})", args);
            return null;
        }
        return StaticComponentContainer.Constructors.newInstanceOf(target, args);
    }

    @IndirectCallers
    public static <T> T constructFromReference(Class<?> reference, String targetClass, Object ... args) {
        return Hacks.construct(Hacks.findClass(reference, targetClass), args);
    }

    @IndirectCallers
    public static <T> T constructWithLoader(String target, ClassLoader loader, Object ... args) {
        return Hacks.construct(Hacks.findClass(target, loader), args);
    }

    public static ClassLoader contextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class<?> defaultCaller() {
        return StaticComponentContainer.Classes.getClass();
    }

    public static <T> Class<T> defineClass(ClassLoader loader, String name, @Nullable ByteBuffer buffer) {
        if (Objects.isNull(buffer)) {
            throw new NullPointerException("Tried to define class with null ByteBuffer: " + name);
        }
        try {
            Hacks.checkBurningWaveInit();
            return (Class)GenericUtils.cast(StaticComponentContainer.ClassLoaders.loadOrDefineByByteCode(buffer, loader));
        }
        catch (Throwable t) {
            TILRef.logError("Failed to define class {} on {}", name, loader, t);
            return null;
        }
    }

    @Nullable
    public static <T> Class<T> findClass(String target, ClassLoader loader, Class<?> caller, boolean initialize) {
        if (Misc.anyNull(target, loader, caller)) {
            LOGGER.error("Cannot find target class {} on {} with caller {}!", (Object)target, (Object)loader, caller);
            return null;
        }
        try {
            return (Class)GenericUtils.cast(StaticComponentContainer.Driver.getClassByName(target, initialize, loader, caller));
        }
        catch (Throwable t) {
            LOGGER.error("Failed to find class {} on loader {} with caller {}! (initialize={})", (Object)target, (Object)loader, caller, (Object)initialize, (Object)t);
            return null;
        }
    }

    @Nullable
    public static <T> Class<T> findClass(String target, Class<?> caller, boolean initialize) {
        return Objects.nonNull(caller) ? Hacks.findClass(target, Hacks.contextClassLoader(), caller, initialize) : Hacks.findClass(target, initialize);
    }

    @Nullable
    public static <T> Class<T> findClass(String target, Class<?> caller) {
        return Hacks.findClass(target, caller, false);
    }

    @Nullable
    public static <T> Class<T> findClass(String target, ClassLoader loader, Class<?> caller) {
        return Hacks.findClass(target, loader, caller, false);
    }

    @Nullable
    public static <T> Class<T> findClass(String target, ClassLoader loader, boolean initialize) {
        return Objects.nonNull(loader) ? Hacks.findClass(target, loader, Hacks.defaultCaller(), initialize) : Hacks.findClass(target, initialize);
    }

    @Nullable
    public static <T> Class<T> findClass(String target, ClassLoader loader) {
        return Hacks.findClass(target, loader, false);
    }

    @Nullable
    public static <T> Class<T> findClass(String target, boolean initialize) {
        return Hacks.findClass(target, Hacks.contextClassLoader(), Hacks.defaultCaller(), initialize);
    }

    @Nullable
    public static <T> Class<T> findClass(String target) {
        return Hacks.findClass(target, false);
    }

    @Nullable
    public static <T> Class<T> findClass(@Nullable Class<?> reference, String target) {
        if (Objects.isNull(reference)) {
            return Hacks.findClass(target);
        }
        return Hacks.findClass(reference.getPackage().getName() + "." + target, reference.getClassLoader());
    }

    @Nullable
    public static <T> Class<T> findClass(@Nullable Package pkg, String target) {
        return Objects.nonNull(pkg) ? Hacks.findClass(pkg.getName(), target) : Hacks.findClass(target);
    }

    @Nullable
    public static <T> Class<T> findClass(@Nullable String pkg, String target) {
        return Objects.nonNull(pkg) ? Hacks.findClass(pkg + "." + target) : Hacks.findClass(target);
    }

    public static Class<?> findClassInHeirarchy(String name, ClassLoader loader) {
        return Hacks.findClassInHeirarchy(name, loader, false);
    }

    public static Class<?> findClassInHeirarchy(String name, ClassLoader loader, boolean initialize) {
        Class<?> foundClass = null;
        ClassLoader searchIn = loader;
        while (Objects.nonNull(searchIn)) {
            try {
                foundClass = StaticComponentContainer.Driver.getClassByName(name, initialize, loader, StaticComponentContainer.Classes.getClass());
            }
            catch (Throwable t) {
                LOGGER.debug("Class not found in ClassLoader {} (name = {})", (Object)searchIn, (Object)name);
            }
            if (Objects.nonNull(foundClass)) break;
            searchIn = StaticComponentContainer.ClassLoaders.getParent(searchIn);
        }
        if (Objects.isNull(foundClass)) {
            LOGGER.error("Class {} not found in ClassLoader heirarchy for {}", (Object)name, (Object)loader);
            return null;
        }
        return foundClass;
    }

    @Nullable
    public static Method findMethodObj(Class<?> c, String methodName, Class<?> ... argTypes) {
        if (Objects.isNull(argTypes)) {
            argTypes = new Class[]{};
        }
        if (Objects.isNull(c) || Objects.isNull(methodName) || methodName.isEmpty()) {
            LOGGER.error("Cannot find method with null class or method name {}#{}({})", c, (Object)methodName, argTypes);
            return null;
        }
        Method m = null;
        try {
            m = c.getMethod(methodName, argTypes);
        }
        catch (Throwable t) {
            try {
                m = c.getDeclaredMethod(methodName, argTypes);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        LOGGER.error("Failed to find method {}#{}({})", (Object)c.getName(), (Object)methodName, argTypes);
        return m;
    }

    @Nullable
    public static ByteBuffer getByteCode(Class<?> clazz) {
        return StaticComponentContainer.Classes.getByteCode(clazz);
    }

    @IndirectCallers
    public static <T> T getField(Object target, String named, String intermediary) {
        return Hacks.getField(target, Hacks.isNamedEnv() ? named : intermediary);
    }

    public static <T> T getField(Object target, String field) {
        if (Objects.isNull(target)) {
            LOGGER.error("Tried to call getField on null target object! (field = {})", (Object)field);
            return null;
        }
        if (Objects.isNull(field)) {
            LOGGER.error("Tried to call getField with null field name! (target = {})", target);
            return null;
        }
        return StaticComponentContainer.Fields.get(target, field);
    }

    @IndirectCallers
    public static <E> Collection<E> getFieldCollection(Object instance, String getter, String field) {
        List collection = (List)Hacks.invokeStatic(Hacks.class, getter, instance, field);
        return Objects.nonNull(collection) ? collection : Collections.emptyList();
    }

    @IndirectCallers
    public static <E> Collection<E> getFieldCollectionWrapped(Object instance, String getter, String field) {
        return Hacks.getFieldCollectionWrapped(instance, getter, field, null);
    }

    public static <E> Collection<E> getFieldCollectionWrapped(Object instance, String getter, String field, Function<Collection<E>, Collection<E>> wrapper) {
        Collection collection = (Collection)Hacks.invokeStatic(Hacks.class, getter, instance, field);
        if (Objects.isNull(collection)) {
            return Collections.emptyList();
        }
        return Objects.nonNull(wrapper) ? wrapper.apply(collection) : new ArrayList(collection);
    }

    @IndirectCallers
    public static <T> T getFieldDirect(Object target, String named, String intermediary) {
        return Hacks.getFieldDirect(target, Hacks.isNamedEnv() ? named : intermediary);
    }

    @IndirectCallers
    public static <T> T getFieldDirect(Object target, String field) {
        if (Objects.isNull(target)) {
            LOGGER.error("Tried to call getFieldDirect on null target object! (field = {})", (Object)field);
            return null;
        }
        if (Objects.isNull(field)) {
            LOGGER.error("Tried to call getFieldDirect with null field name! (target = {})", target);
            return null;
        }
        return StaticComponentContainer.Fields.getDirect(target, field);
    }

    @IndirectCallers
    public static <E> List<E> getFieldList(Object instance, String getter, String field) {
        List list = (List)Hacks.invokeStatic(Hacks.class, getter, instance, field);
        return Objects.nonNull(list) ? list : Collections.emptyList();
    }

    public static <E> List<E> getFieldListWrapped(Object instance, String getter, String field) {
        Collection collection = (Collection)Hacks.invokeStatic(Hacks.class, getter, instance, field);
        return Objects.nonNull(collection) ? new ArrayList(collection) : Collections.emptyList();
    }

    @IndirectCallers
    public static <K, V> Map<K, V> getFieldMap(Object target, String getter, String field) {
        Map map = (Map)Hacks.invokeStatic(Hacks.class, getter, target, field);
        return Objects.nonNull(map) ? map : Collections.emptyMap();
    }

    @IndirectCallers
    public static <K, V> Map<K, V> getFieldMapWrapped(Object target, String getter, String field) {
        Map map = (Map)Hacks.invokeStatic(Hacks.class, getter, target, field);
        return Objects.nonNull(map) ? new HashMap(map) : Collections.emptyMap();
    }

    @IndirectCallers
    public static <E> Set<E> getFieldSet(Object instance, String getter, String field) {
        Set set = (Set)Hacks.invokeStatic(Hacks.class, getter, instance, field);
        return Objects.nonNull(set) ? set : Collections.emptySet();
    }

    @IndirectCallers
    public static <E> Set<E> getFieldSetWrapped(Object instance, String getter, String field) {
        Collection collection = (Collection)Hacks.invokeStatic(Hacks.class, getter, instance, field);
        return Objects.nonNull(collection) ? new HashSet(collection) : Collections.emptySet();
    }

    @IndirectCallers
    public static <T> T getFieldStatic(String targetClass, String field) {
        return Hacks.getFieldStatic(Hacks.findClass(targetClass), field);
    }

    public static <T> T getFieldStatic(Class<?> target, String field) {
        if (Objects.isNull(target)) {
            LOGGER.error("Tried to call getFieldStatic on null target class! (field = {})", (Object)field);
            return null;
        }
        if (Objects.isNull(field)) {
            LOGGER.error("Tried to call getFieldStatic with null field name! (target = {})", target);
            return null;
        }
        return StaticComponentContainer.Fields.getStatic(target, field);
    }

    @IndirectCallers
    public static <T> T getFieldStaticDirect(String targetClass, String field) {
        return Hacks.getFieldStaticDirect(Hacks.findClass(targetClass), field);
    }

    public static <T> T getFieldStaticDirect(Class<?> target, String field) {
        if (Objects.isNull(target)) {
            LOGGER.error("Tried to call getFieldStaticDirect on null target class! (field = {})", (Object)field);
            return null;
        }
        if (Objects.isNull(field)) {
            LOGGER.error("Tried to call getFieldStaticDirect with null field name! (target = {})", target);
            return null;
        }
        return StaticComponentContainer.Fields.getStaticDirect(target, field);
    }

    @IndirectCallers
    public static <T> T getFieldStaticDirectNamed(String targetClass, String named, String intermediary) {
        return Hacks.getFieldStaticDirectNamed(Hacks.findClass(targetClass), named, intermediary);
    }

    public static <T> T getFieldStaticDirectNamed(Class<?> target, String named, String intermediary) {
        return Hacks.getFieldStaticDirect(target, Hacks.isNamedEnv() ? named : intermediary);
    }

    @IndirectCallers
    public static <T> T getFieldStaticNamed(String targetClass, String named, String intermediary) {
        return Hacks.getFieldStaticNamed(Hacks.findClass(targetClass), named, intermediary);
    }

    public static <T> T getFieldStaticNamed(Class<?> target, String named, String intermediary) {
        return Hacks.getFieldStatic(target, Hacks.isNamedEnv() ? named : intermediary);
    }

    private static Object getRecordComponent(Class<?> target, String field) {
        if (Objects.isNull(target)) {
            LOGGER.error("Tried to get record component of null class target! (field = {})", (Object)field);
            return null;
        }
        if (Objects.isNull(field)) {
            LOGGER.error("Tried to get record component for null field name! (target = {})", target);
            return null;
        }
        if (JVMHelper.isJava8()) {
            LOGGER.error("Cannot get record component in Java 8 environment! Records were introduced in Java 14! ({}.{})", (Object)target.getName(), (Object)field);
            return null;
        }
        Object[] components = (Object[])Hacks.invoke(target, "getRecordComponents", new Object[0]);
        if (Objects.isNull(components)) {
            LOGGER.error("No record components found in target {}!", target);
            return null;
        }
        for (Object component : components) {
            if (!field.equals(Hacks.invoke(component, "getName", new Object[0]))) continue;
            return component;
        }
        LOGGER.error("No record components matching '{}' found in target {}!", (Object)field, target);
        return null;
    }

    public static <T> T getRecordField(Object target, String field) {
        if (Objects.isNull(target)) {
            LOGGER.error("Cannot get record field {} from null object target!", (Object)field);
            return null;
        }
        Class<?> targetClass = target.getClass();
        return Hacks.getRecordFieldInstance(Hacks.getRecordComponent(targetClass, field), target, field);
    }

    private static <T> T getRecordFieldInstance(@Nullable Object component, @Nullable Object target, String name) {
        if (Objects.isNull(component)) {
            LOGGER.error("Failed to get record field instance! (field = {})", (Object)name);
            return null;
        }
        return Hacks.invokeMethodObj(target, (Method)Hacks.invoke(component, "getAccessor", new Object[0]), new Object[0]);
    }

    @IndirectCallers
    public static <T> T getRecordFieldStatic(Class<?> target, String field) {
        return Hacks.getRecordFieldInstance(Hacks.getRecordComponent(target, field), null, field);
    }

    @Nullable
    private static Object getStaticComponentByName(String component) {
        switch (component) {
            case "classloader": 
            case "classloaders": 
            case "Classloader": 
            case "Classloaders": 
            case "ClassLoader": 
            case "ClassLoaders": {
                return StaticComponentContainer.ClassLoaders;
            }
            case "class": 
            case "classes": 
            case "Class": 
            case "Classes": {
                return StaticComponentContainer.Classes;
            }
            case "contructor": 
            case "constructors": 
            case "Contructor": 
            case "Constructors": {
                return StaticComponentContainer.Constructors;
            }
            case "driver": 
            case "Driver": {
                return StaticComponentContainer.Driver;
            }
            case "field": 
            case "fields": 
            case "Field": 
            case "Fields": {
                return StaticComponentContainer.Fields;
            }
            case "method": 
            case "methods": 
            case "Method": 
            case "Methods": {
                return StaticComponentContainer.Methods;
            }
        }
        LOGGER.error("Static component type not found {}", (Object)component);
        return null;
    }

    public static <T> T invoke(Object target, String method, Object ... args) {
        if (Objects.isNull(target)) {
            LOGGER.error("Tried to call invoke on null target object! (method = {} | args = {})", (Object)method, (Object)args);
            return null;
        }
        if (Objects.isNull(method)) {
            LOGGER.error("Tried to call invoke with null method name! (target = {} | args = {})", target, (Object)args);
            return null;
        }
        return StaticComponentContainer.Methods.invoke(target, method, args);
    }

    public static <T> T invokeDefault(T defVal, Object target, String method, Object ... args) {
        String hacksMethod = "invoke";
        if (target instanceof String || target instanceof Class) {
            hacksMethod = hacksMethod + "Static";
        }
        return Hacks.invokeDefault(hacksMethod, defVal, target, method, args);
    }

    public static <T> T invokeDefault(String hacksMethod, T defVal, Object target, String method, Object ... args) {
        try {
            T ret = Hacks.invokeStatic(Hacks.class, hacksMethod, target, method, args);
            if (Objects.isNull(ret)) {
                return defVal;
            }
            while (ret instanceof Optional) {
                ret = ((Optional)ret).orElse(GenericUtils.cast(defVal));
            }
            return GenericUtils.cast(ret);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to invoke {} using Hacks#{}! Returning default value {}", (Object)method, (Object)hacksMethod, defVal, (Object)t);
            return defVal;
        }
    }

    public static <T> T invokeDirect(Object target, String method, Object ... args) {
        if (Objects.isNull(target)) {
            LOGGER.error("Tried to call invokeDirect on null target object! (method = {} | args = {})", (Object)method, (Object)args);
            return null;
        }
        if (Objects.isNull(method)) {
            LOGGER.error("Tried to call invokeDirect with null method name! (target = {} | args = {})", target, (Object)args);
            return null;
        }
        return StaticComponentContainer.Methods.invoke(target, method, args);
    }

    @IndirectCallers
    public static <T> T invokeDirectNamed(Object target, String named, String intermediary, Object ... args) {
        return Hacks.invokeDirect(target, Hacks.isNamedEnv() ? named : intermediary, args);
    }

    public static <T> T invokeMethodObj(Object target, String methodName, Object ... args) {
        if (Objects.isNull(target)) {
            return null;
        }
        if (target instanceof Class) {
            return Hacks.invokeMethodObj((Class)target, methodName, args);
        }
        return Hacks.invokeMethodObj(target.getClass(), target, methodName, args);
    }

    public static <T> T invokeMethodObj(Class<?> target, String methodName, Object ... args) {
        return Hacks.invokeMethodObj(target, null, methodName, args);
    }

    public static <T> T invokeMethodObj(Class<?> targetClass, @Nullable Object target, String methodName, Object ... args) {
        return Hacks.invokeMethodObj(targetClass, target, methodName, new Class[0], args);
    }

    @IndirectCallers
    public static <T> T invokeMethodObj(Class<?> target, String methodName, Class<?>[] argTypes, Object ... args) {
        return Hacks.invokeMethodObj(target, (Class<?> c) -> Hacks.findMethodObj(c, methodName, argTypes), args);
    }

    public static <T> T invokeMethodObj(Class<?> targetClass, @Nullable Object target, String methodName, Class<?>[] argTypes, Object ... args) {
        return Hacks.invokeMethodObj(targetClass, target, (Class<?> c) -> Hacks.findMethodObj(c, methodName, argTypes), args);
    }

    public static <T> T invokeMethodObj(Class<?> target, Function<Class<?>, Method> methodFinder, Object ... args) {
        return Hacks.invokeMethodObj(target, null, methodFinder, args);
    }

    public static <T> T invokeMethodObj(Class<?> targetClass, @Nullable Object target, Function<Class<?>, Method> methodFinder, Object ... args) {
        return Hacks.invokeMethodObj(target, methodFinder.apply(targetClass), args);
    }

    public static <T> T invokeMethodObj(@Nullable Object target, Method method, Object ... args) {
        if (Objects.isNull(method)) {
            LOGGER.error("Cannot invoke null method object! (args={})", (Object)args);
        }
        return StaticComponentContainer.Methods.invoke(target, method, args);
    }

    @IndirectCallers
    public static <T> T invokeNamed(Object target, String named, String intermediary, Object ... args) {
        return Hacks.invoke(target, Hacks.isNamedEnv() ? named : intermediary, args);
    }

    @IndirectCallers
    public static <T> T invokeOnComponent(String componentName, String method, Object ... args) {
        Object component = Hacks.getStaticComponentByName(componentName);
        if (Objects.isNull(component)) {
            LOGGER.error("Cannot invoke {} on null component! (args = {})", (Object)method, (Object)args);
            return null;
        }
        return Hacks.invoke(component, method, args);
    }

    @IndirectCallers
    public static <T> T invokeStatic(String targetClass, String method, Object ... args) {
        return Hacks.invokeStatic(Hacks.findClass(targetClass), method, args);
    }

    public static <T> T invokeStatic(Class<?> target, String method, Object ... args) {
        if (Objects.isNull(target)) {
            LOGGER.error("Tried to call invokeStatic on null target class! (method = {} | args = {})", (Object)method, (Object)args);
            return null;
        }
        if (Objects.isNull(method)) {
            LOGGER.error("Tried to call invokeStatic with null method name! (target = {} | args = {})", target, (Object)args);
            return null;
        }
        return StaticComponentContainer.Methods.invokeStatic(target, method, args);
    }

    @IndirectCallers
    public static <T> T invokeStaticDirect(String targetClass, String method, Object ... args) {
        return Hacks.invokeStaticDirect(Hacks.findClass(targetClass), method, args);
    }

    public static <T> T invokeStaticDirect(Class<?> target, String method, Object ... args) {
        if (Objects.isNull(target)) {
            LOGGER.error("Tried to call invokeStaticDirect on null target class! (method = {} | args = {})", (Object)method, (Object)args);
            return null;
        }
        if (Objects.isNull(method)) {
            LOGGER.error("Tried to call invokeStaticDirect with null method name! (target = {} | args = {})", target, (Object)args);
            return null;
        }
        return StaticComponentContainer.Methods.invokeStaticDirect(target, method, args);
    }

    @IndirectCallers
    public static <T> T invokeStaticDirectNamed(String targetClass, String named, String intermediary, Object ... args) {
        return Hacks.invokeStaticDirect(Hacks.findClass(targetClass), named, intermediary, args);
    }

    public static <T> T invokeStaticDirectNamed(Class<?> target, String named, String intermediary, Object ... args) {
        return Hacks.invokeStaticDirect(target, Hacks.isNamedEnv() ? named : intermediary, args);
    }

    @IndirectCallers
    public static <T> T invokeStaticMethodObj(Method method, Object ... args) {
        return Hacks.invokeMethodObj(null, method, args);
    }

    @IndirectCallers
    public static <T> T invokeStaticNamed(String targetClass, String named, String intermediary, Object ... args) {
        return Hacks.invokeStatic(Hacks.findClass(targetClass), named, intermediary, args);
    }

    public static <T> T invokeStaticNamed(Class<?> target, String named, String intermediary, Object ... args) {
        return Hacks.invokeStatic(target, Hacks.isNamedEnv() ? named : intermediary, args);
    }

    public static boolean isNamedEnv() {
        Hacks.checkEnvironmentInit();
        return namedEnv;
    }

    @IndirectCallers
    public static boolean isSrgEnv() {
        Hacks.checkEnvironmentInit();
        return srgEnv;
    }

    public static <T> Class<T> loadOrDefineClass(Class<T> c, ClassLoader loader) {
        try {
            return StaticComponentContainer.ClassLoaders.loadOrDefine(c, loader);
        }
        catch (Exception ex) {
            LOGGER.fatal("Failed to load or define {} on loader {}", c, (Object)loader, (Object)ex);
            return c;
        }
    }

    @IndirectCallers
    public static <V> boolean removeCollectionFieldValue(String field, V value, Function<String, Collection<V>> collectionGetter) {
        return Hacks.removeCollectionFieldValue(field, value, collectionGetter, null);
    }

    public static <V> boolean removeCollectionFieldValue(String field, V value, Function<String, Collection<V>> collectionGetter, @Nullable BiConsumer<String, Collection<V>> afterRemove) {
        Collection<V> collection = collectionGetter.apply(field);
        boolean removed = collection.remove(value);
        if (Objects.nonNull(afterRemove)) {
            afterRemove.accept(field, collection);
        }
        return removed;
    }

    public static void removeEnvironmentProperty(String property) {
        Hacks.removeEnvironmentProperty(property, true);
    }

    public static void removeEnvironmentProperty(String property, boolean removeFromAll) {
        LOGGER.debug("Attempting to remove {} property", (Object)property);
        String all = removeFromAll ? "all environment property maps" : "the default environment property map";
        String cName = "java.lang.ProcessEnvironment";
        Class c = Hacks.findClass("java.lang.ProcessEnvironment");
        if (Objects.isNull(c)) {
            LOGGER.error("Failed to find class {}! Cannot remove environment property {}", (Object)"java.lang.ProcessEnvironment", (Object)property);
            return;
        }
        Hacks.removeMapFieldKey("theEnvironment", property, s -> (Map)Hacks.getFieldStaticDirect(c, s));
        if (removeFromAll) {
            Hacks.removeMapFieldKey("theCaseInsensitiveEnvironment", property, s -> (Map)Hacks.getFieldStaticDirect(c, s));
            Hacks.removeMapFieldKey("theUnmodifiableEnvironment", property, s -> {
                Map map = (Map)Hacks.getFieldStaticDirect(c, s);
                return new HashMap(Objects.nonNull(map) ? map : Collections.emptyMap());
            }, (s, map) -> Hacks.setFieldStaticDirect(c, s, Collections.unmodifiableMap(map)));
        }
        LOGGER.info("Removed property {} from {}", (Object)property, (Object)all);
    }

    public static <K, V> V removeMapFieldKey(String field, K key, Function<String, Map<K, V>> mapGetter) {
        return Hacks.removeMapFieldKey(field, key, mapGetter, null);
    }

    public static <K, V> V removeMapFieldKey(String field, K key, Function<String, Map<K, V>> mapGetter, @Nullable BiConsumer<String, Map<K, V>> afterRemove) {
        Map<K, V> map = mapGetter.apply(field);
        V removedValue = map.remove(key);
        if (Objects.nonNull(afterRemove)) {
            afterRemove.accept(field, map);
        }
        return removedValue;
    }

    @IndirectCallers
    public static void setField(Object target, String field, Object value) {
        if (Objects.isNull(target)) {
            LOGGER.error("Tried to call setField on null target object! (field = {})", (Object)field);
            return;
        }
        if (Objects.isNull(field)) {
            LOGGER.error("Tried to call setField with null field name! (target = {})", target);
            return;
        }
        StaticComponentContainer.Fields.set(target, field, value);
    }

    @IndirectCallers
    public static void setFieldDirect(Object target, String field, Object value) {
        if (Objects.isNull(target)) {
            LOGGER.error("Tried to call setFieldDirect on null target object! (field = {})", (Object)field);
            return;
        }
        if (Objects.isNull(field)) {
            LOGGER.error("Tried to call setFieldDirect with null field name! (target = {})", target);
            return;
        }
        StaticComponentContainer.Fields.setDirect(target, field, value);
    }

    @IndirectCallers
    public static void setFieldStatic(String targetName, String field, Object value) {
        Hacks.setFieldStatic(Hacks.findClass(targetName), field, value);
    }

    public static void setFieldStatic(Class<?> target, String field, Object value) {
        if (Objects.isNull(target)) {
            LOGGER.error("Tried to call setFieldStatic on null target class! (field = {})", (Object)field);
            return;
        }
        if (Objects.isNull(field)) {
            LOGGER.error("Tried to call setFieldStatic with null field name! (target = {})", target);
            return;
        }
        StaticComponentContainer.Fields.setStatic(target, field, value);
    }

    @IndirectCallers
    public static void setFieldStaticDirect(String targetName, String field, Object value) {
        Hacks.setFieldStaticDirect(Hacks.findClass(targetName), field, value);
    }

    public static void setFieldStaticDirect(Class<?> target, String field, Object value) {
        if (Objects.isNull(target)) {
            LOGGER.error("Tried to call setFieldStaticDirect on null target class! (field = {})", (Object)field);
            return;
        }
        if (Objects.isNull(field)) {
            LOGGER.error("Tried to call setFieldStaticDirect with null field name! (target = {})", target);
            return;
        }
        StaticComponentContainer.Fields.setStaticDirect(target, field, value);
    }

    public static ByteBuffer toByteBuffer(InputStream stream) {
        return StaticComponentContainer.Streams.toByteBuffer(stream);
    }

    public static enum CallStrategy {
        DEFAULT("", Object.class),
        DIRECT("Direct", Object.class),
        STATIC("Static", Class.class),
        STATIC_DIRECT("StaticDirect", Class.class);

        private static final Map<String, CallStrategy> ALIAS_CACHE;
        final String ext;
        final Class<?> targetType;

        public static CallStrategy byName(String strategy) {
            if (Objects.isNull(strategy)) {
                return DEFAULT;
            }
            if (ALIAS_CACHE.containsKey(strategy)) {
                return ALIAS_CACHE.get(strategy);
            }
            switch (strategy) {
                case "direct": 
                case "Direct": 
                case "DIRECT": {
                    ALIAS_CACHE.put(strategy, DIRECT);
                    return DIRECT;
                }
                case "static": 
                case "Static": 
                case "STATIC": {
                    ALIAS_CACHE.put(strategy, STATIC);
                    return STATIC;
                }
            }
            if ("both".equalsIgnoreCase(strategy) || Misc.equalsAnyIgnoreCase(strategy, Misc.wordCombinations("direct", "static", "", " ", "_", "-"))) {
                ALIAS_CACHE.put(strategy, STATIC_DIRECT);
                return STATIC_DIRECT;
            }
            ALIAS_CACHE.put(strategy, DEFAULT);
            return DEFAULT;
        }

        @IndirectCallers
        public static <T> T callWith(String strategy, String s, Object ... args) {
            return CallStrategy.byName(strategy).call(s, args);
        }

        private CallStrategy(String ext, Class<?> targetType) {
            this.ext = ext;
            this.targetType = targetType;
        }

        public <T> T call(String s, Object ... args) {
            return Hacks.invokeStatic(Hacks.class, s + this.ext, args);
        }

        public <T> T get(Object ... args) {
            return this.call("getField", args);
        }

        public <T> T invoke(Object ... args) {
            return this.call("invoke", args);
        }

        public void set(Object ... args) {
            this.call("setField", args);
        }

        static {
            ALIAS_CACHE = new HashMap<String, CallStrategy>();
        }
    }
}

