/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDevCoreDependent;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class TILDev {
    public static final boolean DEBUG_NETWORK = TILDev.getBooleanProperty("debug.network");
    public static final boolean DEV = TILDev.getBooleanProperty("dev");
    public static final Set<String> CLASSPATH_COREMODS = TILDev.parseClasspathMods(true);
    public static final Set<String> CLASSPATH_MODS = TILDev.parseClasspathMods(false);
    static final String JAR_NAME = "theimpossiblelibrary-0.4.7.jar";
    private static final Logger LOGGER = DEV ? LogManager.getLogger((String)"TIL DEV") : null;
    private static Path devClasses;
    private static Path devResources;

    private static boolean getBooleanProperty(String propertyName) {
        return Boolean.parseBoolean(TILDev.getProperty(propertyName));
    }

    public static void checkDevPath(Path path) {
        if (DEV && Objects.isNull(devClasses) && TILDev.isLoaderPath(path)) {
            TILDev.setDevPaths(path);
        }
    }

    @IndirectCallers
    public static <I> void devConsume(I input, Consumer<I> consumer) {
        if (DEV) {
            consumer.accept(input);
        }
    }

    @IndirectCallers
    @Nullable
    public static <I, R> R devFunc(I input, Function<I, R> function) {
        return DEV ? (R)function.apply(input) : null;
    }

    @IndirectCallers
    @Nullable
    public static <R> R devSupply(Supplier<R> supplier) {
        return DEV ? (R)supplier.get() : null;
    }

    public static Path getLoaderResourcePath(String ... paths) {
        if (Objects.isNull(devResources) || !devResources.toFile().exists()) {
            TILRef.logError("Cannot get path from null or nonexistant dev resources path! ({})", devResources);
            return null;
        }
        boolean classes = paths[paths.length - 1].endsWith(".class");
        Path result = classes ? devClasses : devResources;
        for (String path : paths) {
            result = result.resolve(path);
        }
        return result;
    }

    private static String getProperty(String propertyName) {
        return System.getProperty("til." + propertyName);
    }

    static String getProperty(String propertyName, String defaultValue) {
        return System.getProperty("til." + propertyName, defaultValue);
    }

    @IndirectCallers
    public static boolean isLoaderFile(File file) {
        return TILDev.isLoaderName(file.getName());
    }

    public static boolean isLoaderName(String fileName) {
        return JAR_NAME.equals(fileName);
    }

    public static boolean isLoaderPath(Path path) {
        return TILDevCoreDependent.isLoaderPath(path);
    }

    public static void log(Level level, String msg, Object ... args) {
        if (DEV) {
            LOGGER.log(level, msg, args);
        }
    }

    public static void logDebug(String msg, Object ... args) {
        TILDev.log(Level.DEBUG, msg, args);
    }

    public static void logError(String msg, Object ... args) {
        TILDev.log(Level.ERROR, msg, args);
    }

    public static void logFatal(String msg, Object ... args) {
        TILDev.log(Level.FATAL, msg, args);
    }

    @IndirectCallers
    public static void logFromASM(String msg, Object arg) {
        TILDev.logError(msg, arg);
    }

    public static void logInfo(String msg, Object ... args) {
        TILDev.log(Level.INFO, msg, args);
    }

    public static void logTrace(String msg, Object ... args) {
        TILDev.log(Level.TRACE, msg, args);
    }

    public static void logWarn(String msg, Object ... args) {
        TILDev.log(Level.WARN, msg, args);
    }

    private static Set<String> parseClasspathMods(boolean coremods) {
        String mods = TILDev.getProperty("classpath." + (coremods ? "coremods" : "mods"));
        if (Objects.isNull(mods)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(mods.split(";"))));
    }

    public static void setDevPaths(Path classes) {
        devClasses = classes;
        TILRef.logInfo("Set devClasses to {}", devClasses);
        File file = classes.toFile();
        if (file.isDirectory()) {
            Path build = classes.getParent().getParent().getParent();
            devResources = Paths.get(build.toAbsolutePath().toString(), "resources", TILDev.sourceName());
        } else {
            devResources = classes;
        }
        TILRef.logInfo("Set devResources to {}", devResources);
    }

    static String sourceName() {
        String loader = CoreAPI.getModLoaderName();
        return "legacy".equals(loader) ? "main" : "til" + loader;
    }
}

