/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;

public class TILDevCoreDependent {
    private static final Set<String> LOADER_PATHS = TILDevCoreDependent.parseLoaderPaths();

    static boolean isLoaderPath(Path path) {
        return LOADER_PATHS.contains(path.toAbsolutePath().toString());
    }

    static Set<String> parseLoaderPaths() {
        String[] paths = TILDev.getProperty("classpath.file", "theimpossiblelibrary-0.4.7.jar").split(";");
        if (paths.length == 0) {
            return Collections.singleton("theimpossiblelibrary-0.4.7.jar");
        }
        HashSet<String> pathSet = new HashSet<String>();
        String loaderSource = TILDev.sourceName();
        boolean isMain = "main".equals(loaderSource);
        for (String path : paths) {
            pathSet.add(path);
            if (path.endsWith("main")) {
                if (isMain) continue;
                pathSet.add(path.substring(0, path.length() - 4) + loaderSource);
                continue;
            }
            if (!path.endsWith(loaderSource)) continue;
            pathSet.add(path.substring(0, path.length() - loaderSource.length()) + "main");
        }
        return Collections.unmodifiableSet(pathSet);
    }
}

