/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.asm;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ArrayHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.AnnotationPrinter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.BytecodePrinter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.FieldPrinter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.MethodPrinter;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassPrinter
extends ClassVisitor
implements BytecodePrinter {
    protected final ClassPrinter parent;
    protected String pkgName;
    protected String[] imports;
    protected String access;
    protected String name;
    protected String superName;
    protected String[] interfaces;
    protected AnnotationPrinter[] annotations;
    protected FieldPrinter[] fields;
    protected MethodPrinter[] methods;
    protected ClassPrinter[] innerClasses;

    public static String getClassPath(String name) {
        while (name.startsWith("[")) {
            name = name.substring(1);
        }
        if (name.startsWith("L") && name.endsWith(";")) {
            name = name.substring(1, name.length() - 1);
        }
        return name.replace('/', '.');
    }

    public static String parseClassAccess(int access) {
        switch (access) {
            case 1538: {
                return "private interface";
            }
            case 1540: {
                return "protected interface";
            }
            case 1537: {
                return "public interface";
            }
        }
        return ClassPrinter.parseAccess(access) + " class";
    }

    public static String parseAccess(int access) {
        int bit;
        StringJoiner joiner = new StringJoiner(" ").setEmptyValue("(package-private)");
        block14: for (int remaining = access; remaining != 0; remaining -= bit) {
            bit = Integer.lowestOneBit(remaining);
            switch (bit) {
                case 1: {
                    joiner.add("public");
                    continue block14;
                }
                case 2: {
                    joiner.add("private");
                    continue block14;
                }
                case 4: {
                    joiner.add("protected");
                    continue block14;
                }
                case 8: {
                    joiner.add("static");
                    continue block14;
                }
                case 16: {
                    joiner.add("final");
                    continue block14;
                }
                case 32: {
                    joiner.add("synchronzied");
                    continue block14;
                }
                case 64: {
                    joiner.add("(bridge)");
                    continue block14;
                }
                case 128: {
                    joiner.add("(varargs)");
                    continue block14;
                }
                case 256: {
                    joiner.add("native");
                    continue block14;
                }
                case 1024: {
                    joiner.add("abstract");
                    continue block14;
                }
                case 2048: {
                    joiner.add("strictfp");
                    continue block14;
                }
                case 4096: {
                    joiner.add("synthetic");
                }
            }
        }
        return joiner.toString();
    }

    public static Map.Entry<String, String> splitPackage(String classpath) {
        int index = classpath.lastIndexOf(46);
        String pkgName = index == -1 ? "" : classpath.substring(0, index);
        String clsName = classpath.substring(index + 1);
        return new AbstractMap.SimpleImmutableEntry<String, String>(pkgName, TextHelper.isNotBlank(clsName) ? clsName : "?");
    }

    @IndirectCallers
    public ClassPrinter(int api) {
        this(api, null);
    }

    public ClassPrinter(int api, ClassPrinter parent) {
        super(api);
        this.parent = parent;
    }

    public void addImport(String pkg) {
        if (TextHelper.isBlank(pkg) || pkg.equals(this.pkgName) || pkg.equals("java.lang")) {
            return;
        }
        if (Objects.nonNull(this.parent)) {
            this.parent.addImport(pkg);
        } else {
            this.imports = ArrayHelper.append(this.imports, pkg, false);
        }
    }

    protected void getAnnotationLines(Collection<String> lines, int tabs) {
        if (ArrayHelper.isNotEmpty(this.annotations)) {
            for (AnnotationPrinter annotation : this.annotations) {
                annotation.toLines(lines, tabs);
            }
        }
    }

    protected void getFieldLines(Collection<String> lines, int tabs) {
        if (ArrayHelper.isNotEmpty(this.fields)) {
            for (FieldPrinter field : this.fields) {
                field.toLines(lines, tabs + 1);
            }
        }
        lines.add("");
    }

    protected void getHeaderLines(Collection<String> lines, int tabs) {
        StringJoiner headerJoiner = new StringJoiner(" ");
        headerJoiner.add(this.access).add(this.name);
        if (Objects.nonNull(this.superName)) {
            headerJoiner.add("extends").add(this.superName);
        }
        if (Objects.nonNull(this.interfaces) && this.interfaces.length > 0) {
            StringJoiner interfaceJoiner = new StringJoiner(", ");
            for (String itf : this.interfaces) {
                interfaceJoiner.add(itf);
            }
            headerJoiner.add(interfaceJoiner.toString());
        }
        lines.add(TextHelper.withTabs(headerJoiner.add("{").toString(), tabs));
        lines.add("");
    }

    protected void getImportLines(Collection<String> lines) {
        if (Objects.nonNull(this.imports) && this.imports.length > 0) {
            ArrayList<String> orderedImports = new ArrayList<String>(Arrays.asList(this.imports));
            Collections.sort(orderedImports);
            for (String ordered : orderedImports) {
                lines.add("import " + ordered + ";");
            }
            lines.add("");
        }
    }

    protected void getInnerClassLines(Collection<String> lines, int tabs) {
        if (ArrayHelper.isNotEmpty(this.innerClasses)) {
            for (ClassPrinter clazz : this.innerClasses) {
                clazz.toLines(lines, tabs + 1);
            }
        }
    }

    protected void getMethodLines(Collection<String> lines, int tabs) {
        if (ArrayHelper.isNotEmpty(this.methods)) {
            for (MethodPrinter method : this.methods) {
                method.toLines(lines, tabs + 1);
            }
        }
    }

    protected void getPackageLines(Collection<String> lines) {
        if (TextHelper.isNotBlank(this.pkgName)) {
            lines.add("package " + this.pkgName + ";");
            lines.add("");
        }
    }

    protected AnnotationPrinter parseAnnotation(String desc) {
        Map.Entry<String, String> pkgPair = ClassPrinter.splitPackage(ClassPrinter.getClassPath(desc));
        this.addImport(pkgPair.getKey());
        AnnotationPrinter printer = new AnnotationPrinter(this.api, this, pkgPair.getValue());
        this.annotations = ArrayHelper.append(this.annotations, printer, false);
        return printer;
    }

    protected FieldPrinter parseField(int access, String name, String typeName, Object value) {
        Map.Entry<String, String> pkgPair = ClassPrinter.splitPackage(ClassPrinter.getClassPath(typeName));
        this.addImport(pkgPair.getKey());
        FieldPrinter printer = new FieldPrinter(this.api, this, access, name, pkgPair.getValue(), value);
        this.fields = ArrayHelper.append(this.fields, printer, false);
        return printer;
    }

    protected void parseInnerClass(int access, String name, String desc) {
        ClassPrinter printer = new ClassPrinter(this.api, this);
        printer.access = ClassPrinter.parseClassAccess(access);
        printer.name = Objects.nonNull(name) ? name : ClassPrinter.splitPackage(ClassPrinter.getClassPath(desc)).getValue();
        this.innerClasses = ArrayHelper.append(this.innerClasses, printer, false);
    }

    protected void parseInterfaces(String[] interfaces) {
        if (Objects.isNull(interfaces) || interfaces.length == 0) {
            this.interfaces = new String[0];
            return;
        }
        ArrayHelper.deduplicate(interfaces, new String[0]);
        String[] classpaths = ArrayHelper.forEach(interfaces, (itf, i) -> {
            interfaces[i.intValue()] = ClassPrinter.getClassPath(itf);
        });
        this.interfaces = new String[classpaths.length];
        for (int i2 = 0; i2 < classpaths.length; ++i2) {
            Map.Entry<String, String> pkgPair = ClassPrinter.splitPackage(classpaths[i2]);
            this.addImport(pkgPair.getKey());
            String name = pkgPair.getValue();
            this.interfaces[i2] = name.equals("?") ? null : name;
        }
        this.interfaces = ArrayHelper.removeAllOccurrencesOf(this.interfaces, "?");
    }

    protected MethodPrinter parseMethod(int access, String name, String desc, String[] exceptions) {
        MethodPrinter printer = new MethodPrinter(this.api, this, access, name, desc, exceptions);
        this.methods = ArrayHelper.append(this.methods, printer, false);
        return printer;
    }

    protected void parseName(String classpath) {
        Map.Entry<String, String> pkgPair = ClassPrinter.splitPackage(classpath);
        this.pkgName = pkgPair.getKey();
        this.name = pkgPair.getValue();
    }

    protected void parseSuper(String classpath) {
        Map.Entry<String, String> pkgPair = ClassPrinter.splitPackage(classpath);
        this.addImport(pkgPair.getKey());
        String name = pkgPair.getValue();
        this.superName = name.equals("?") || pkgPair.getKey().equals("java.lang") && name.equals("Object") ? null : name;
    }

    public List<String> toLines() {
        ArrayList<String> lines = new ArrayList<String>();
        this.toLines(lines, 0);
        return lines;
    }

    @Override
    public void toLines(Collection<String> lines, int tabs) {
        if (Objects.isNull(this.parent)) {
            this.getPackageLines(lines);
        }
        if (Objects.isNull(this.parent)) {
            this.getImportLines(lines);
        }
        this.getAnnotationLines(lines, tabs);
        this.getHeaderLines(lines, tabs);
        this.getFieldLines(lines, tabs);
        this.getMethodLines(lines, tabs);
        this.getInnerClassLines(lines, tabs);
        lines.add("}");
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.access = ClassPrinter.parseClassAccess(access);
        this.parseName(ClassPrinter.getClassPath(name));
        this.parseSuper(ClassPrinter.getClassPath(superName));
        this.parseInterfaces(interfaces);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        return this.parseAnnotation(descriptor);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        return this.parseField(access, name, descriptor, value);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        return this.parseMethod(access, name, descriptor, exceptions);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.parseInnerClass(access, innerName, name);
    }

    public void visitEnd() {
        TILRef.logWarn("Printing written class with name `{}`", this.name);
        TILRef.logWarn("----------------------------------------------------------------------------------------------------", new Object[0]);
        int lineNum = 1;
        for (String line : this.toLines()) {
            TILRef.logWarn("{}" + (lineNum > 9 ? (lineNum > 99 ? " " : "  ") : "   ") + "{}", lineNum, line);
            ++lineNum;
        }
        TILRef.logWarn("----------------------------------------------------------------------------------------------------", new Object[0]);
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

