/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.asm;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreStateAccessor;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ClassPrinter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.TypeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.util.MathHelper;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class ModWriter
implements CoreStateAccessor {
    protected final CoreAPI core;
    protected final Map<String, Type> entryPointMethodTypes;
    protected final Map<String, String[]> entryPointMethods;
    protected final MultiVersionModInfo info;
    protected final String entryPointDesc;
    protected final String entryPointInternal;
    protected final String modTypeDesc;
    protected final String modTypeInternal;
    protected final Type entryPoint;
    protected final Type modType;

    protected ModWriter(CoreAPI core, MultiVersionModInfo info) {
        this.core = core;
        Map.Entry<Map<String, String[]>, Map<String, Type>> maps = this.mappedEntryPointMethods();
        this.entryPointMethods = maps.getKey();
        this.entryPointMethodTypes = maps.getValue();
        this.info = info;
        this.entryPoint = Type.getType(info.getEntryClass());
        this.modType = this.generatedModType(info);
        this.entryPointDesc = this.entryPoint.getDescriptor();
        this.entryPointInternal = this.entryPoint.getInternalName();
        this.modTypeDesc = this.modType.getDescriptor();
        this.modTypeInternal = this.modType.getInternalName();
    }

    protected void addClassAnnotations(ClassVisitor visitor) {
    }

    protected void addEntryHooks(MethodVisitor method, boolean isStatic, String methodName, boolean codeVisited) {
        if (!codeVisited) {
            method.visitCode();
        }
        for (String entryMethod : this.entryPointMethods.get(methodName)) {
            this.entryPointGetter(method, isStatic);
            method.visitMethodInsn(182, this.entryPointInternal, entryMethod, ASMRef.EMPTY_METHOD_DESC, false);
        }
    }

    protected void addFields(ClassVisitor visitor) {
        ASMHelper.addField(visitor, 9, "INSTANCE", this.modType, null, null);
        ASMHelper.addField(visitor, 17, "entryPoint", this.entryPoint, null, null);
    }

    protected Map.Entry<ClassWriter, Type> addInnerClass(ClassVisitor outerClass, String innerName, Consumer<ClassVisitor> innerWriter) {
        return this.addInnerClass(outerClass, innerName, innerWriter, true, true);
    }

    protected Map.Entry<ClassWriter, Type> addInnerClass(ClassVisitor outerClass, String innerName, Consumer<ClassVisitor> innerWriter, boolean client, boolean server) {
        Type innerType = TypeHelper.inner(this.modType, innerName);
        ClassWriter writer = ASMHelper.getWriter(JAVA_VERSION_ASM, 25, innerType, this.modInterfaces(client, server));
        writer.visitOuterClass(this.modTypeInternal, null, null);
        outerClass.visitInnerClass(innerType.getInternalName(), this.modTypeInternal, innerName, 25);
        innerWriter.accept((ClassVisitor)writer);
        return new AbstractMap.SimpleImmutableEntry<ClassWriter, Type>(writer, innerType);
    }

    public void basicContructorHandle(MethodVisitor constructor) {
        ASMHelper.addSuperConstructor(constructor, ASMRef.OBJECT_TYPE_NAME, ASMRef.EMPTY_METHOD_DESC, false);
    }

    public final List<Map.Entry<String, byte[]>> buildModClass() {
        ArrayList<Map.Entry<String, byte[]>> classBytes = new ArrayList<Map.Entry<String, byte[]>>();
        ClassWriter writer = ASMHelper.getWriter(JAVA_VERSION_ASM, 1, this.modType, this.modInterfaces(true, true));
        this.writeMod(writer, classBytes);
        this.finishWritingClass(writer, this.modType, (classpath, bytes) -> {
            TILRef.logDebug("Wrote bytecode for `{}` entrypoint to `{}`", this.info.getModID(), classpath);
            classBytes.add(new AbstractMap.SimpleImmutableEntry<String, byte[]>((String)classpath, (byte[])bytes));
        });
        return classBytes;
    }

    protected void classInit(MethodVisitor clinit) {
    }

    protected void constructor(MethodVisitor constructor) {
        this.addEntryHooks(constructor, false, "<init>", true);
    }

    protected void entryPointGetter(MethodVisitor visitor) {
        this.entryPointGetter(visitor, false);
    }

    protected void entryPointGetter(MethodVisitor method, boolean isStatic) {
        if (isStatic) {
            method.visitFieldInsn(178, this.modTypeInternal, "INSTANCE", this.modTypeDesc);
        } else {
            method.visitVarInsn(25, 0);
        }
        method.visitFieldInsn(180, this.modTypeInternal, "entryPoint", this.entryPointDesc);
    }

    protected abstract List<String[]> entryPointMappings();

    protected void finishWritingClass(ClassWriter writer, Type type, BiConsumer<String, byte[]> byteCodeAcceptor) {
        String classpath = ClassPrinter.getClassPath(type.getInternalName());
        try {
            byte[] bytes = ASMHelper.finishWriting(writer, type, TILDev.DEV);
            byteCodeAcceptor.accept(classpath, bytes);
        }
        catch (Throwable ex) {
            TILRef.logFatal("Failed to write bytecode for classpath {}", classpath, ex);
        }
    }

    protected MethodVisitor getConstructor(ClassVisitor visitor) {
        return ASMHelper.getConstructor(visitor, 1, new Type[0]);
    }

    private Type generatedModType(MultiVersionModInfo info) {
        String pkgName = info.getEntryClass().getPackage().getName();
        String modName = info.getName().replace(" ", "");
        return this.generatedModType(pkgName, modName, info.isClient(), info.isServer());
    }

    protected Type generatedModType(String pkgName, String modName, boolean client, boolean server) {
        String extension = "Generated" + (client ? (server ? "Common" : "Client") : (server ? "Server" : "")) + "Mod";
        return TypeHelper.fromBinary(pkgName + "." + modName + extension);
    }

    protected abstract Type getEventMethod(String var1);

    protected final InnerClassDataBuilder innerClassDataBuilder(ClassVisitor outer, String name, BiConsumer<InnerClassData, ClassVisitor> classInitHandle, String ... entryPoints) {
        return new InnerClassDataBuilder(outer, name, classInitHandle, entryPoints);
    }

    protected InnerClassData[] innerClasses(ClassVisitor outerClass) {
        return new InnerClassData[0];
    }

    protected boolean isClient() {
        return this.core.getSide().isClient() && this.info.isClient();
    }

    protected boolean isServer() {
        return this.core.getSide().isServer() && this.info.isServer();
    }

    protected Map.Entry<Map<String, String[]>, Map<String, Type>> mappedEntryPointMethods() {
        HashMap<String, String[]> redirects = new HashMap<String, String[]>();
        HashMap<String, Type> types = new HashMap<String, Type>();
        for (String[] mappings : this.entryPointMappings()) {
            String name = mappings[0];
            redirects.put(name, Arrays.copyOfRange(mappings, 2, mappings.length));
            types.put(name, this.getEventMethod(mappings[1]));
        }
        return new AbstractMap.SimpleImmutableEntry<Map<String, String[]>, Map<String, Type>>(Collections.unmodifiableMap(redirects), Collections.unmodifiableMap(types));
    }

    protected String[] modInterfaces(boolean client, boolean server) {
        return new String[0];
    }

    protected final void writeAnnotationArray(AnnotationVisitor annotation, String name, Consumer<AnnotationVisitor> arrayWriter) {
        AnnotationVisitor array = annotation.visitArray(name);
        arrayWriter.accept(array);
        array.visitEnd();
    }

    protected final void writeClassAnnotation(ClassVisitor visitor, Type type, Consumer<AnnotationVisitor> annotationWriter) {
        AnnotationVisitor annotation = ASMHelper.getAnnotation(visitor, type);
        annotationWriter.accept(annotation);
        annotation.visitEnd();
    }

    protected final void writeClassInit(ClassVisitor visitor) {
        this.addClassAnnotations(visitor);
        this.addFields(visitor);
        this.writeMethod(visitor, ASMHelper::getClassInit, this::classInit);
    }

    protected void writeConstructor(ClassVisitor visitor) {
        this.writeConstructor(visitor, constructor -> {});
    }

    protected final void writeConstructor(ClassVisitor visitor, Consumer<MethodVisitor> extraDataHandler) {
        this.writeMethod(visitor, this::getConstructor, constructor -> {
            ASMHelper.addSuperConstructor(constructor, ASMRef.OBJECT_TYPE_NAME, ASMRef.EMPTY_METHOD_DESC, false);
            constructor.visitVarInsn(25, 0);
            constructor.visitFieldInsn(179, this.modTypeInternal, "INSTANCE", this.modTypeDesc);
            constructor.visitVarInsn(25, 0);
            ASMHelper.addNewInstance(constructor, this.entryPointInternal, ASMRef.EMPTY_METHOD_DESC, false);
            constructor.visitFieldInsn(181, this.modTypeInternal, "entryPoint", this.entryPointDesc);
            extraDataHandler.accept((MethodVisitor)constructor);
            this.constructor((MethodVisitor)constructor);
        });
    }

    protected void writeInnerClass(Map.Entry<ClassWriter, Type> writerPair, List<Map.Entry<String, byte[]>> classBytes) {
        if (Objects.nonNull(writerPair)) {
            this.writeInnerClass(writerPair, (String classpath, byte[] bytes) -> {
                TILRef.logDebug("Finished writing inner class {}", classpath);
                classBytes.add(new AbstractMap.SimpleImmutableEntry<String, byte[]>((String)classpath, (byte[])bytes));
            });
        } else {
            TILRef.logDebug("Not writing inner class for null writerPair", new Object[0]);
        }
    }

    protected void writeInnerClass(Map.Entry<ClassWriter, Type> writerPair, BiConsumer<String, byte[]> byteCodeAcceptor) {
        this.finishWritingClass(writerPair.getKey(), writerPair.getValue(), byteCodeAcceptor);
    }

    protected void writeInnerConstructor(ClassVisitor visitor) {
        this.writeMethod(visitor, this::getConstructor, constructor -> {
            ASMHelper.addSuperConstructor(constructor, ASMRef.OBJECT_TYPE_NAME, ASMRef.EMPTY_METHOD_DESC, false);
            constructor.visitVarInsn(25, 0);
            constructor.visitFieldInsn(179, this.modTypeInternal, "INSTANCE", this.modTypeDesc);
        });
    }

    protected final void writeMethod(ClassVisitor visitor, Function<ClassVisitor, MethodVisitor> methodGetter, Consumer<MethodVisitor> methodWriter) {
        MethodVisitor method = methodGetter.apply(visitor);
        methodWriter.accept(method);
        method.visitInsn(177);
        ASMHelper.finishMethod(method);
    }

    protected final void writeMethodAnnotation(MethodVisitor method, Type type, Consumer<AnnotationVisitor> annotationWriter) {
        AnnotationVisitor annotation = ASMHelper.getAnnotation(method, type);
        annotationWriter.accept(annotation);
        annotation.visitEnd();
    }

    protected void writeMod(ClassWriter writer, List<Map.Entry<String, byte[]>> classBytes) {
        this.writeClassInit((ClassVisitor)writer);
        this.writeConstructor((ClassVisitor)writer);
        for (InnerClassData data : this.innerClasses((ClassVisitor)writer)) {
            this.writeInnerClass(data.write(this), classBytes);
        }
    }

    @Generated
    public MultiVersionModInfo getInfo() {
        return this.info;
    }

    protected static final class InnerClassDataBuilder {
        final ClassVisitor outerClass;
        final String className;
        final BiConsumer<InnerClassData, ClassVisitor> classInitHandle;
        final String[] entryMethods;
        boolean client;
        boolean modBus;
        boolean server;
        BiConsumer<ModWriter, MethodVisitor> constructorHandle;
        BiFunction<ModWriter, ClassVisitor, MethodVisitor> constructorInit;
        BiConsumer<ClassVisitor, String> entryPointHandle;

        protected InnerClassDataBuilder(ClassVisitor outerClass, String className, BiConsumer<InnerClassData, ClassVisitor> classInitHandle, String ... entryMethods) {
            this.outerClass = outerClass;
            this.className = className;
            this.classInitHandle = classInitHandle;
            this.entryMethods = entryMethods;
        }

        @IndirectCallers
        public InnerClassDataBuilder allFlags() {
            return this.bothSides().modBus();
        }

        public InnerClassDataBuilder bothSides() {
            return this.client().server();
        }

        public InnerClassData build() {
            if (Objects.isNull(this.constructorInit)) {
                this.constructorInit = ModWriter::getConstructor;
            }
            if (Objects.isNull(this.constructorHandle)) {
                this.constructorHandle = ModWriter::basicContructorHandle;
            }
            return new InnerClassData(this.outerClass, this.className, this.modBus, this.client, this.server, this.entryMethods, this.classInitHandle, this.constructorInit, this.constructorHandle, this.entryPointHandle);
        }

        public InnerClassDataBuilder client() {
            this.client = true;
            return this;
        }

        public InnerClassDataBuilder constructorHandle(BiConsumer<ModWriter, MethodVisitor> handle) {
            this.constructorHandle = handle;
            return this;
        }

        public InnerClassDataBuilder constructorInit(BiFunction<ModWriter, ClassVisitor, MethodVisitor> init) {
            this.constructorInit = init;
            return this;
        }

        public InnerClassDataBuilder entryPointHandle(BiConsumer<ClassVisitor, String> handle) {
            this.entryPointHandle = handle;
            return this;
        }

        public InnerClassDataBuilder modBus() {
            this.modBus = true;
            return this;
        }

        @IndirectCallers
        public InnerClassDataBuilder modBusClient() {
            return this.modBus().client();
        }

        @IndirectCallers
        public InnerClassDataBuilder modBusServer() {
            return this.modBus().server();
        }

        public InnerClassDataBuilder server() {
            this.server = true;
            return this;
        }

        public InnerClassDataBuilder setFlags(int flags) {
            this.modBus = (flags = MathHelper.clamp(flags, 0, 7)) >> 2 == 1;
            this.client = (flags >> 1 & 0xFFFFFFFD) == 1;
            this.server = (flags & 0xFFFFFFF9) == 1;
            return this;
        }
    }

    public static final class InnerClassData {
        final ClassVisitor outerClass;
        final boolean client;
        final boolean modBus;
        final boolean server;
        final String className;
        final String[] entryMethods;
        final BiConsumer<InnerClassData, ClassVisitor> classInitHandle;
        final BiConsumer<ModWriter, MethodVisitor> constructorHandle;
        final BiFunction<ModWriter, ClassVisitor, MethodVisitor> constructorInit;
        final BiConsumer<ClassVisitor, String> entryPointHandle;

        InnerClassData(ClassVisitor outerClass, String className, boolean modBus, boolean client, boolean server, String[] entryMethods, BiConsumer<InnerClassData, ClassVisitor> classInitHandle, BiFunction<ModWriter, ClassVisitor, MethodVisitor> constructorInit, BiConsumer<ModWriter, MethodVisitor> constructorHandle, BiConsumer<ClassVisitor, String> entryPointHandle) {
            this.outerClass = outerClass;
            this.className = className;
            this.client = client;
            this.modBus = modBus;
            this.server = server;
            this.entryMethods = entryMethods;
            this.classInitHandle = classInitHandle;
            this.constructorInit = constructorInit;
            this.constructorHandle = constructorHandle;
            this.entryPointHandle = entryPointHandle;
        }

        void addConstructor(ModWriter writer, ClassVisitor visitor) {
            this.constructorHandle.accept(writer, this.constructorInit.apply(writer, visitor));
        }

        void init(ModWriter writer, ClassVisitor innerVisitor) {
            this.classInitHandle.accept(this, innerVisitor);
            this.addConstructor(writer, innerVisitor);
        }

        public Map.Entry<ClassWriter, Type> write(ModWriter writer) {
            return writer.addInnerClass(this.outerClass, this.className, innerVisitor -> this.write(writer, (ClassVisitor)innerVisitor), this.client, this.server);
        }

        void write(ModWriter writer, ClassVisitor innerVisitor) {
            this.init(writer, innerVisitor);
            for (String entryPoint : this.entryMethods) {
                this.entryPointHandle.accept(innerVisitor, entryPoint);
            }
        }

        @Generated
        public boolean isClient() {
            return this.client;
        }

        @Generated
        public boolean isModBus() {
            return this.modBus;
        }

        @Generated
        public boolean isServer() {
            return this.server;
        }
    }
}

