/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.loader;

import java.io.File;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.Attributes;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionLoaderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModCandidate;
import org.jetbrains.annotations.Nullable;

public class MultiVersionModFinder {
    public static final Attributes.Name MULTIVERSION_COREMODS = new Attributes.Name("TILMultiversionCoreMods");
    public static final Attributes.Name MULTIVERSION_MODS = new Attributes.Name("TILMultiversionMods");

    public static Set<MultiVersionModCandidate> discover(MultiVersionLoaderAPI loader, File root, boolean isCore) {
        TILRef.logDebug("Attempting to find multiversion {} candidates from root `{}`", isCore ? "coremod" : "mod", root);
        HashSet<MultiVersionModCandidate> candidates = new HashSet<MultiVersionModCandidate>();
        HashSet<String> foundCoreMods = new HashSet<String>();
        HashSet<String> foundMods = new HashSet<String>();
        MultiVersionModFinder.addClasspathMods(loader, candidates, isCore, foundCoreMods, foundMods);
        for (File file : loader.gatherCandidateModFiles(root)) {
            MultiVersionModCandidate candidate = MultiVersionModFinder.getCandidate(loader, file, isCore, foundCoreMods, foundMods);
            if (!Objects.nonNull(candidate) || (isCore || !candidate.hasMods()) && (!isCore || !candidate.hasCoreMods())) continue;
            candidates.add(candidate);
        }
        return candidates;
    }

    @Nullable
    public static MultiVersionModCandidate discoverCoreCandidate(MultiVersionLoaderAPI loader, File file, Function<File, Attributes> attributesGetter) {
        return MultiVersionModFinder.getCandidate(loader, file, attributesGetter, true, new HashSet<String>(), new HashSet<String>());
    }

    @Nullable
    public static MultiVersionModCandidate discoverModCandidate(MultiVersionLoaderAPI loader, File file, Function<File, Attributes> attributesGetter) {
        return MultiVersionModFinder.getCandidate(loader, file, attributesGetter, false, new HashSet<String>(), new HashSet<String>());
    }

    @Nullable
    private static MultiVersionModCandidate getCandidate(MultiVersionLoaderAPI loader, File file, boolean isCore, Set<String> foundCoreMods, Set<String> foundMods) {
        return MultiVersionModFinder.getCandidate(loader, file, loader::getFileAttributes, isCore, foundCoreMods, foundMods);
    }

    @Nullable
    private static MultiVersionModCandidate getCandidate(MultiVersionLoaderAPI loader, File file, Function<File, Attributes> attributesGetter, boolean isCore, Set<String> foundCoreMods, Set<String> foundMods) {
        TILRef.logDebug("Examining candidate file`{}` for {}mods", file, isCore ? "core" : "");
        Attributes attributes = attributesGetter.apply(file);
        if (Objects.nonNull(attributes)) {
            MultiVersionModCandidate candidate = new MultiVersionModCandidate(loader.parent, file);
            if (isCore) {
                candidate.addCoreClasses(foundCoreMods, MultiVersionModFinder.parseClasses(attributes, MULTIVERSION_COREMODS));
            } else {
                candidate.addModClasses(foundMods, MultiVersionModFinder.parseClasses(attributes, MULTIVERSION_MODS));
            }
            return candidate;
        }
        TILRef.logDebug("File did not contain any attributes to check", new Object[0]);
        return null;
    }

    public static boolean hasMods(Attributes attributes) {
        return attributes.containsKey(MULTIVERSION_MODS) || attributes.containsKey(MULTIVERSION_COREMODS);
    }

    private static void addClasspathMods(MultiVersionLoaderAPI loader, Set<MultiVersionModCandidate> candidates, boolean isCore, Set<String> foundCoreMods, Set<String> foundMods) {
        if (isCore) {
            TILRef.logDebug("Adding {} classpath coremods", TILDev.CLASSPATH_COREMODS.size());
            for (String core : TILDev.CLASSPATH_COREMODS) {
                MultiVersionModCandidate candidate = new MultiVersionModCandidate(loader.parent, core);
                TILRef.logDebug("Adding classpath coremod `{}`", core);
                candidate.addCoreClasses(foundCoreMods, core);
                candidates.add(candidate);
            }
        } else {
            TILRef.logDebug("Adding {} classpath mods", TILDev.CLASSPATH_MODS.size());
            for (String mod : TILDev.CLASSPATH_MODS) {
                MultiVersionModCandidate candidate = new MultiVersionModCandidate(loader.parent, mod);
                TILRef.logDebug("Adding classpath mod `{}`", mod);
                candidate.addModClasses(foundMods, mod);
                candidates.add(candidate);
            }
        }
    }

    private static String[] parseClasses(Attributes attributes, Attributes.Name name) {
        TILRef.logDebug("Found attribute `{}`", name);
        String unparsed = attributes.getValue(name);
        String[] split = Objects.nonNull(unparsed) ? unparsed.split(";") : null;
        return Objects.nonNull(split) ? split : new String[]{};
    }
}

