/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.modules;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.AbstractModuleSystemAccessor;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ClassAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleSystemAccessor;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.jetbrains.annotations.Nullable;

public class ClassLoaderAccess
extends AbstractModuleSystemAccessor {
    protected ClassLoaderAccess(ClassLoader loader, Object accessorOrLogger) {
        super(loader, accessorOrLogger);
    }

    public ClassAccess accessClass(Class<?> c) {
        return this.getClassAccess(c);
    }

    @IndirectCallers
    public void addClassAccesses(Collection<ClassAccess> addThese) {
        Collection<Class<?>> classes = this.classes(false);
        for (ClassAccess c : addThese) {
            classes.add(c.unwrap());
        }
    }

    public void addClasses(Collection<Class<?>> addThese) {
        Collection<Class<?>> classes = this.classes(false);
        classes.addAll(addThese);
    }

    public void addPackages(Map<String, Object> pkgMap, @Nullable ModuleAccess module) {
        Map<String, Object> packages = this.packages();
        for (Map.Entry<String, Object> entry : pkgMap.entrySet()) {
            Object pkg = entry.getValue();
            if (!Objects.nonNull(pkg)) continue;
            if (Objects.nonNull(module)) {
                Hacks.setFieldDirect(pkg, "module", module.access);
            }
            packages.put(entry.getKey(), pkg);
        }
    }

    public Collection<Class<?>> classes() {
        return this.classes(true);
    }

    public Collection<Class<?>> classes(boolean copy) {
        Collection classes = (Collection)this.getDirect("classes");
        if (Objects.isNull(classes)) {
            return Collections.emptySet();
        }
        return copy ? new HashSet(classes) : classes;
    }

    public Collection<ClassAccess> classesAccess() {
        return this.classes().stream().map(this::accessClass).collect(Collectors.toSet());
    }

    @IndirectCallers
    public String getModuleNameForClass(Class<?> c) {
        return this.accessClass(c).getModuleName();
    }

    public Object getPackage(String pkgName) {
        return this.packages().get(pkgName);
    }

    @IndirectCallers
    public void inheritClasses(ModuleAccess module, String moduleName, ClassLoaderAccess ... loaders) {
        this.inheritClasses(module, new String[]{moduleName}, loaders);
    }

    public void inheritClasses(ModuleAccess module, String[] moduleNames, ClassLoaderAccess ... loaders) {
        String moduleName = module.getName();
        for (ClassAccess c : this.classesAccess()) {
            c.setModuleIfIn(module, moduleName);
        }
        for (ClassLoaderAccess loader : loaders) {
            Set<Class<?>> classes = loader.moveModuleClasses(module, moduleNames);
            this.addClasses(classes);
            loader.removeClasses(classes);
        }
    }

    public Set<Class<?>> moveModuleClasses(ModuleAccess module, String ... moduleNames) {
        HashSet movedClasses = new HashSet();
        for (ClassAccess c : this.classesAccess()) {
            if (!c.inModule(moduleNames)) continue;
            movedClasses.add(c.unwrap());
        }
        if (!movedClasses.isEmpty()) {
            ClassLoader loader = this.unwrap();
            Object moduleObj = module.access();
            for (Class clazz : movedClasses) {
                StaticComponentContainer.Fields.setDirect((Object)clazz, "classLoader", (Object)loader);
                StaticComponentContainer.Fields.setDirect((Object)clazz, "module", moduleObj);
            }
        }
        return movedClasses;
    }

    public void moveModuleClassesTo(ModuleAccess module, ClassLoaderAccess target) {
        this.moveModuleClassesTo(module, target.unwrap(), target);
    }

    @IndirectCallers
    public void moveModuleClassesTo(ModuleAccess module, ClassLoader target) {
        ClassLoaderAccess targetAccess = ModuleSystemAccessor.getClassLoader(target, this);
        this.moveModuleClassesTo(module, target, targetAccess);
    }

    public void moveModuleClassesTo(ModuleAccess module, ClassLoader target, ClassLoaderAccess targetAccess) {
        HashSet movedClasses = new HashSet();
        HashMap<String, Object> movedPackages = new HashMap<String, Object>();
        for (ClassAccess c : this.classesAccess()) {
            if (!c.inModule((Object)module.getName())) continue;
            c.setClassLoader(target);
            movedClasses.add(c.unwrap());
            String pkgName = c.pkgName();
            Object pkg = this.getPackage(pkgName);
            if (!Objects.nonNull(pkg)) continue;
            movedPackages.put(pkgName, pkg);
        }
        targetAccess.addClasses(movedClasses);
        targetAccess.addPackages(movedPackages, module);
        this.removeClasses(movedClasses);
        Map<String, Object> packages = this.packages();
        for (String pkgName : movedPackages.keySet()) {
            packages.remove(pkgName);
        }
    }

    public Map<String, Object> packages() {
        Map<String, Object> pkgMap = (Map<String, Object>)this.getDirect("packages");
        return Objects.nonNull(pkgMap) ? pkgMap : Collections.emptyMap();
    }

    @IndirectCallers
    public void removeClasses(Collection<Class<?>> classes) {
        this.classes(false).removeAll(classes);
    }

    @IndirectCallers
    public void removeWrappedClasses(Collection<ClassAccess> removeThese) {
        Collection<Class<?>> classes = this.classes(false);
        for (ClassAccess c : removeThese) {
            classes.remove(c.unwrap());
        }
    }

    @IndirectCallers
    public void setClassModules(ModuleAccess module, String moduleName) {
        for (ClassAccess c : this.classesAccess()) {
            c.setModuleIfIn(module, moduleName);
        }
    }

    public ClassLoader unwrap() {
        return (ClassLoader)this.access;
    }
}

