/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.AbstractModuleSystemAccessor;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleHolder;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleReferenceAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ResolvedModuleAccess;
import org.apache.logging.log4j.Logger;

public class ConfigurationAccess
extends AbstractModuleSystemAccessor
implements ModuleHolder {
    final Collection<ModuleHolder> referents = Collections.singleton(this);

    ConfigurationAccess(Object configuration, Object accessorOrLogger) {
        super(configuration, accessorOrLogger);
    }

    public void addModule(ResolvedModuleAccess resolvedModule) {
        this.addModule(resolvedModule.access);
    }

    private void addModule(Object resolvedModule) {
        Set<Object> modules = this.modules();
        modules.add(resolvedModule);
        this.setModules(modules);
    }

    public void addModuleForced(ResolvedModuleAccess resolvedModule) {
        Object moduleAccess = resolvedModule.access;
        this.addModule(moduleAccess);
        Map<String, Object> nameToModule = this.nameToModule();
        nameToModule.put(resolvedModule.name(), moduleAccess);
        this.setNameToModule(nameToModule);
        resolvedModule.setConfiguration(this);
    }

    @IndirectCallers
    public void addModuleIfAbsent(ResolvedModuleAccess resolvedModule) {
        this.addModuleIfAbsent(resolvedModule.name(), resolvedModule);
    }

    public void addModuleIfAbsent(String name, ResolvedModuleAccess resolvedModule) {
        this.addModuleIfAbsent(name, resolvedModule.access);
        resolvedModule.setConfiguration(this);
    }

    private void addModuleIfAbsent(String name, Object resolvedModule) {
        Map<String, Object> nameToModule = this.nameToModule();
        if (!nameToModule.containsKey(name)) {
            nameToModule.put(name, resolvedModule);
            this.setNameToModule(nameToModule);
        }
    }

    public ResolvedModuleAccess asResolvedModule(Object resolvedModule) {
        return resolvedModule instanceof ResolvedModuleAccess ? (ResolvedModuleAccess)resolvedModule : this.getResolvedModule(resolvedModule);
    }

    void cloneGraphModules(String moduleName, String newModuleName) {
        HashMap<Object, Set<Object>> modifiedGraph = new HashMap<Object, Set<Object>>();
        HashSet<String> accountedNames = new HashSet<String>();
        boolean modified = false;
        for (Map.Entry<Object, Set<Object>> graphEntry : this.graph(false).entrySet()) {
            ResolvedModuleAccess key = this.getResolvedModule(graphEntry.getKey());
            String keyName = key.name();
            if (accountedNames.contains(keyName)) continue;
            accountedNames.add(keyName);
            if (moduleName.equals(keyName)) {
                key.setName(newModuleName);
                modified = true;
            }
            Set<Object> values = graphEntry.getValue();
            modified = modified || this.mergeMatchingNamesTo(values, moduleName, newModuleName);
            modifiedGraph.put(key.access, values);
        }
        if (modified) {
            this.setGraph(modifiedGraph);
        }
    }

    @Override
    public void cloneModule(String moduleName, String newModuleName) {
        Map<String, Object> nameToModule = this.nameToModule();
        Set<Object> modules = this.modules(true);
        ResolvedModuleAccess module = null;
        if (nameToModule.containsKey(moduleName)) {
            Object existing = nameToModule.get(newModuleName);
            module = this.getModule(moduleName);
            if (Objects.nonNull(existing)) {
                this.getResolvedModule(existing).inheritFrom(module);
            } else {
                module.setName(newModuleName);
                nameToModule.put(newModuleName, nameToModule.get(moduleName));
            }
            this.setNameToModule(nameToModule);
        }
        if (Objects.nonNull(module)) {
            modules.removeIf(m -> {
                String name = this.getResolvedModuleName(m);
                return name.equals(moduleName) || name.equals(newModuleName);
            });
            modules.add(module.access);
        } else {
            module = this.getModuleFromSet(newModuleName);
            HashSet<Object> removals = new HashSet<Object>();
            boolean existed = Objects.nonNull(module);
            boolean changed = false;
            for (Object m2 : modules) {
                ResolvedModuleAccess mAccess = this.getResolvedModule(m2);
                if (!mAccess.name().equals(moduleName)) continue;
                changed = true;
                if (Objects.nonNull(module)) {
                    module.inheritFrom(mAccess);
                    removals.add(mAccess.access);
                    continue;
                }
                module = mAccess;
                module.setName(newModuleName);
            }
            if (changed) {
                modules.removeAll(removals);
                if (!existed) {
                    modules.add(module.access);
                }
                this.setModules(modules);
            }
        }
        this.cloneGraphModules(moduleName, newModuleName);
    }

    @Override
    public Collection<ModuleHolder> getAllReferents() {
        return this.referents;
    }

    @Override
    public Collection<ModuleHolder> getLayeredReferents() {
        return this.referents;
    }

    public ResolvedModuleAccess getModule(String moduleName) {
        return this.getResolvedModule(this.getModuleDirect(moduleName));
    }

    public <T> T getModuleDirect(String moduleName) {
        return (T)this.nameToModule(false).get(moduleName);
    }

    private ResolvedModuleAccess getModuleFromSet(String name) {
        for (Object module : this.modules()) {
            ResolvedModuleAccess mAccess = this.getResolvedModule(module);
            if (!name.equals(mAccess.name())) continue;
            return mAccess;
        }
        return null;
    }

    public String getResolvedModuleName(Object resolvedModule) {
        return this.getResolvedModule(resolvedModule).name();
    }

    @IndirectCallers
    public Map<Object, Set<Object>> graph() {
        return this.graph(true);
    }

    public Map<Object, Set<Object>> graph(boolean modifiable) {
        Map graph = (Map)this.getDirect("graph");
        return modifiable ? new HashMap(graph) : graph;
    }

    boolean mergeMatchingNamesTo(Collection<Object> resolvedModules, String name, String newName) {
        Object firstMatch = null;
        HashSet<Object> otherMatches = new HashSet<Object>();
        for (Object resolvedModule : resolvedModules) {
            if (!name.equals(this.getResolvedModuleName(resolvedModule))) continue;
            if (Objects.isNull(firstMatch)) {
                firstMatch = resolvedModule;
                continue;
            }
            otherMatches.add(resolvedModule);
        }
        if (Objects.nonNull(firstMatch)) {
            this.getResolvedModule(firstMatch).setName(newName);
            resolvedModules.removeAll(otherMatches);
            return true;
        }
        return false;
    }

    @IndirectCallers
    public Set<Object> modules() {
        return this.modules(true);
    }

    public Set<Object> modules(boolean modifiable) {
        Set parents = (Set)this.invoke("modules", new Object[0]);
        return modifiable ? new HashSet(parents) : parents;
    }

    public void moveModuleTo(ConfigurationAccess targetConfiguration, ResolvedModuleAccess resolvedModule) {
        this.removeModuleFully(resolvedModule);
        targetConfiguration.addModuleForced(resolvedModule);
    }

    @IndirectCallers
    public Map<String, Object> nameToModule() {
        return this.nameToModule(true);
    }

    public Map<String, Object> nameToModule(boolean modifiable) {
        Map nameToModule = (Map)this.getDirect("nameToModule");
        return modifiable ? new HashMap(nameToModule) : nameToModule;
    }

    public ResolvedModuleAccess newResolvedModule(ModuleReferenceAccess moduleReference) {
        return this.newResolvedModule(this, moduleReference);
    }

    @IndirectCallers
    public List<Object> parents() {
        return this.parents(true);
    }

    public List<Object> parents(boolean modifiable) {
        List parents = (List)this.invoke("parents", new Object[0]);
        return modifiable ? new ArrayList(parents) : parents;
    }

    public void printGraph(String layerName) {
        this.logOrPrint("Printing module resolution graph for configuration in " + layerName, Logger::debug);
        for (Map.Entry<Object, Set<Object>> graphEntry : this.graph(false).entrySet()) {
            this.logOrPrint("\tMODULE " + this.getResolvedModuleName(graphEntry.getKey()), Logger::debug);
            for (Object value : graphEntry.getValue()) {
                this.logOrPrint("\t\tREADS " + this.getResolvedModuleName(value), Logger::debug);
            }
        }
        this.logOrPrint("Finished printing module resolution graph for " + layerName, Logger::debug);
    }

    @IndirectCallers
    public void removeFromGraph(ResolvedModuleAccess resolvedModule) {
        this.removeFromGraph(resolvedModule.name());
    }

    public void removeFromGraph(String moduleName) {
        Map<Object, Set<Object>> graph = this.graph();
        HashMap<Object, Set<Object>> graphWithRemovals = new HashMap<Object, Set<Object>>();
        for (Map.Entry<Object, Set<Object>> entry : graph.entrySet()) {
            Object key = entry.getKey();
            ResolvedModuleAccess keyAccess = this.asResolvedModule(key);
            if (moduleName.equals(keyAccess.name())) continue;
            HashSet<Object> values = new HashSet<Object>((Collection)entry.getValue());
            values.removeIf(value -> moduleName.equals(this.asResolvedModule(value).name()));
            if (values.isEmpty()) continue;
            graphWithRemovals.put(key, Collections.unmodifiableSet(values));
        }
        graph.clear();
        this.setGraph(graphWithRemovals);
    }

    public Object removeFromModuleMap(String moduleName) {
        Map<String, Object> nameToModule = this.nameToModule();
        Object resolvedModule = nameToModule.remove(moduleName);
        this.setNameToModule(nameToModule);
        return resolvedModule;
    }

    public void removeFromModules(Object module) {
        Set<Object> modules = this.modules();
        modules.remove(module);
        this.setModules(modules);
    }

    public void removeModule(ResolvedModuleAccess resolvedModule) {
        this.removeModule(resolvedModule.name());
    }

    @Override
    public void removeModule(String moduleName) {
        this.removeFromModules(this.removeFromModuleMap(moduleName));
        this.removeFromGraph(moduleName);
    }

    public void removeModules(String ... moduleNames) {
        for (String moduleName : moduleNames) {
            this.removeModule(moduleName);
        }
    }

    public void removeModuleFully(ResolvedModuleAccess resolvedModule) {
        this.removeFromModules(resolvedModule.access);
        String name = resolvedModule.name();
        this.removeFromModuleMap(name);
        this.removeFromGraph(name);
    }

    public void renameModule(String name, String newName) {
        Object module = this.removeFromModuleMap(name);
        if (Objects.nonNull(module)) {
            this.addModuleIfAbsent(newName, module);
        }
    }

    public void setGraph(Map<Object, Set<Object>> graph) {
        this.setDirect("graph", Collections.unmodifiableMap(graph));
    }

    public void setModules(Set<Object> modules) {
        this.setDirect("modules", Collections.unmodifiableSet(modules));
    }

    public void setNameToModule(Map<String, Object> nameToModule) {
        this.setDirect("nameToModule", Collections.unmodifiableMap(nameToModule));
    }

    @IndirectCallers
    public void setParents(List<Object> parents) {
        this.setDirect("parents", Collections.unmodifiableList(parents));
    }
}

