/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.modules;

import java.util.Collection;
import java.util.Set;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.AbstractModuleSystemAccessor;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ClassAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ClassLoaderAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleDescriptorAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleLayerAccess;
import org.apache.logging.log4j.Logger;

public class ModuleAccess
extends AbstractModuleSystemAccessor {
    ModuleAccess(Object module, Object accessorOrLogger) {
        super(module, accessorOrLogger);
    }

    public void addClassIfMissing(String className, ModuleLayerAccess moduleLayer) {
        String moduleName = this.getName();
        ClassAccess classAccess = this.getClassAccess(className, false, moduleLayer.findLoader(moduleName));
        if (!classAccess.inModule(this)) {
            this.logOrPrint("Adding class " + className + " to module " + moduleName, Logger::debug);
            classAccess.setModule(this);
        }
    }

    public void addPackages(Collection<String> packages) {
        this.getDescriptor().addPackages(packages);
    }

    public void exportPackagesToAll() {
        for (String pkg : this.getPackages()) {
            this.exportPackageToAll(pkg);
        }
    }

    private void exportPackageToAll(String pkg) {
        this.invokeStaticDirect("java.lang.Module", "addExportsToAll0", this.access, pkg);
        this.invokeStaticDirect("java.lang.Module", "addExportsToAllUnnamed0", this.access, pkg);
    }

    @IndirectCallers
    public ClassLoader getClassLoader() {
        return (ClassLoader)this.invoke("getClassLoader", new Object[0]);
    }

    public ModuleDescriptorAccess getDescriptor() {
        return this.getModuleDescriptor(this.invoke("getDescriptor", new Object[0]));
    }

    public ModuleLayerAccess getLayer() {
        Object layer = this.invoke("getLayer", new Object[0]);
        return this.getModuleLayer(layer);
    }

    public String getName() {
        return (String)this.invoke("getName", new Object[0]);
    }

    public Set<String> getPackages() {
        return this.getDescriptor().packages();
    }

    public void inheritFrom(ModuleAccess module) {
        this.getDescriptor().inheritFrom(module.getDescriptor());
    }

    public void setLayer(ModuleLayerAccess layer) {
        this.setLayer(layer.access);
    }

    public void setLayer(Object layer) {
        this.setDirect("layer", layer);
    }

    public void setLoader(ClassLoaderAccess loader) {
        this.setLoader(loader.unwrap());
    }

    public void setLoader(ClassLoader loader) {
        this.setDirect("loader", loader);
    }

    public void setName(String name) {
        this.setDirect("name", name);
        this.getDescriptor().setName(name);
    }
}

