/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.modules;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;

public interface ModuleHolder {
    public void cloneModule(String var1, String var2);

    @IndirectCallers
    default public void cloneModuleFully(String moduleName, String newModuleName) {
        this.cloneModuleFully(moduleName, newModuleName, true);
    }

    default public void cloneModuleFully(String moduleName, String newModuleName, boolean includeThis) {
        for (ModuleHolder holder : this.getAllReferents()) {
            if (this == holder && !includeThis) continue;
            holder.cloneModule(moduleName, newModuleName);
        }
    }

    default public void collectLayeredReferents(Collection<ModuleHolder> referents, ModuleHolder referent) {
        for (ModuleHolder childReferent : referent.getAllReferents()) {
            if (referent == childReferent) continue;
            if (!referents.contains(childReferent)) {
                referents.add(childReferent);
            }
            this.collectLayeredReferents(referents, childReferent);
        }
    }

    public Collection<ModuleHolder> getAllReferents();

    default public Collection<ModuleHolder> getAllReferents(boolean layered) {
        if (!layered) {
            return this.getAllReferents();
        }
        HashSet<ModuleHolder> referents = new HashSet<ModuleHolder>(this.getAllReferents());
        for (ModuleHolder referent : referents) {
            this.collectLayeredReferents(referents, referent);
        }
        return Collections.unmodifiableSet(referents);
    }

    @IndirectCallers
    default public Collection<ModuleHolder> getLayeredReferents() {
        return this.getAllReferents(true);
    }

    public void removeModule(String var1);

    default public void removeModuleFully(String moduleName) {
        this.removeModuleFully(moduleName, true);
    }

    default public void removeModuleFully(String moduleName, boolean includeThis) {
        for (ModuleHolder holder : this.getAllReferents()) {
            if (this == holder && !includeThis) continue;
            holder.removeModule(moduleName);
        }
    }
}

