/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.modules;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.AbstractModuleSystemAccessor;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ClassAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ClassLoaderAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ConfigurationAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleDescriptorAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleHolder;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ServicesCatalogAccess;
import org.apache.logging.log4j.Logger;

public class ModuleLayerAccess
extends AbstractModuleSystemAccessor
implements ModuleHolder {
    final Collection<ModuleHolder> referents = Collections.singleton(this);
    String layerName;

    ModuleLayerAccess(Object moduleLayer, Object accessorOrLogger) {
        super(moduleLayer, accessorOrLogger);
    }

    public void addModule(ModuleAccess module) {
        this.addModule(module.getName(), module);
    }

    public void addModule(String name, ModuleAccess module) {
        this.addModule(name, module.access);
    }

    public void addModule(String name, Object module) {
        Map<String, Object> nameToModule = this.nameToModule();
        nameToModule.put(name, module);
        this.setNameToModule(nameToModule);
        Set<Object> modules = this.modules(true);
        modules.add(module);
        this.setModules(modules);
    }

    @Override
    public void cloneModule(String moduleName, String newModuleName) {
        this.cloneModule(null, moduleName, newModuleName);
    }

    public void cloneModule(ClassLoaderAccess loader, String moduleName, String newModuleName) {
        Map<String, Object> nameToModule = this.nameToModule();
        Set<Object> modules = this.modules(true);
        ModuleAccess module = null;
        if (nameToModule.containsKey(moduleName)) {
            Object existing = nameToModule.get(newModuleName);
            module = this.getModule(moduleName);
            if (Objects.nonNull(existing)) {
                this.getModule(existing).inheritFrom(module);
            } else {
                module.setName(newModuleName);
                nameToModule.put(newModuleName, nameToModule.get(moduleName));
            }
            this.setNameToModule(nameToModule);
        }
        if (Objects.nonNull(module)) {
            modules.removeIf(m -> {
                String name = this.getModuleName(m);
                return name.equals(moduleName) || name.equals(newModuleName);
            });
            modules.add(module.access);
            if (Objects.nonNull(loader)) {
                loader.moveModuleClasses(module, moduleName, newModuleName);
            }
        } else {
            module = this.getModuleFromSet(newModuleName);
            HashSet<Object> removals = new HashSet<Object>();
            boolean existed = Objects.nonNull(module);
            boolean changed = false;
            for (Object m2 : modules) {
                ModuleAccess mAccess = this.getModule(m2);
                if (!mAccess.getName().equals(moduleName)) continue;
                changed = true;
                if (Objects.nonNull(module)) {
                    module.inheritFrom(mAccess);
                    removals.add(mAccess.access);
                    continue;
                }
                module = mAccess;
                module.setName(newModuleName);
            }
            if (Objects.nonNull(module) && Objects.nonNull(loader)) {
                loader.moveModuleClasses(module, moduleName, newModuleName);
            }
            if (changed) {
                modules.removeAll(removals);
                if (!existed) {
                    modules.add(module.access);
                }
                this.setModules(modules);
            }
        }
    }

    public void combineModules(String combinedName, String ... others) {
        ModuleAccess combinedModule = this.getModule(combinedName);
        if (Objects.isNull(combinedModule)) {
            return;
        }
        for (String other : others) {
            ModuleAccess otherModule = this.getModule(other);
            if (!Objects.nonNull(otherModule)) continue;
            combinedModule.inheritFrom(otherModule);
            this.removeModule(other);
        }
    }

    @IndirectCallers
    public ConfigurationAccess configuration() {
        return (ConfigurationAccess)this.getDirect("cf");
    }

    public void exportPackagesToAll() {
        Set<Object> modules = this.modules(true);
        modules.addAll(this.nameToModule(false).values());
        for (Object module : modules) {
            this.getModule(module).exportPackagesToAll();
        }
    }

    public void findAndAddModule(Object otherLayer, String moduleName, String ... otherValidNames) {
        for (ModuleAccess module : this.moduleAccessors()) {
            if (module.getLayer().findAndAddModule(module, otherLayer, moduleName, otherValidNames)) break;
        }
    }

    boolean findAndAddModule(ModuleAccess module, Object otherLayer, String moduleName, String ... otherValidNames) {
        String name = module.getName();
        if (Objects.isNull(name)) {
            return false;
        }
        boolean equivalentName = name.equals(moduleName);
        if (!equivalentName) {
            for (String validName : otherValidNames) {
                if (!validName.equals(moduleName)) continue;
                equivalentName = true;
                break;
            }
        }
        if (equivalentName) {
            ModuleLayerAccess layer = module.getLayer();
            String same = layer.access() == otherLayer ? "the same" : "a different";
            this.logOrPrint("Found module " + moduleName + " in " + same + " layer that wasn't present in the nameToModule map", Logger::info);
            layer.addModule(moduleName, module);
            return true;
        }
        return false;
    }

    @IndirectCallers
    public ClassAccess findClassForModule(String moduleName, String className, boolean initialize) {
        return this.getClassAccess(className, initialize, this.findLoader(moduleName));
    }

    @IndirectCallers
    public ClassLoader findLoader(ModuleAccess module) {
        return this.findLoader(module.getName());
    }

    public ClassLoader findLoader(String name) {
        return (ClassLoader)this.invoke("findLoader", name);
    }

    public Optional<Object> findModule(String name) {
        return (Optional)this.invoke("findModule", name);
    }

    @IndirectCallers
    public Map<ModuleAccess, Collection<String>> getAllModulePackages() {
        Set<Object> modules = this.modules(true);
        modules.addAll(this.nameToModule(false).values());
        return modules.stream().map(this::getModule).collect(Collectors.toMap(Function.identity(), this::getModulePackages));
    }

    @Override
    public Collection<ModuleHolder> getAllReferents() {
        return this.referents;
    }

    public ModuleAccess getAnyModule(String ... names) {
        for (String name : names) {
            ModuleAccess module = this.getModule(name, false);
            if (!Objects.nonNull(module)) continue;
            return module;
        }
        this.logOrPrintError("No modules matching any of " + Arrays.toString(names) + " found in layer " + this.layerName);
        return null;
    }

    @Override
    public Collection<ModuleHolder> getLayeredReferents() {
        return this.referents;
    }

    public ModuleAccess getModule(String name) {
        return this.getModule(name, true);
    }

    public ModuleAccess getModule(String name, boolean logError) {
        Map<String, Object> nameToModule = this.nameToModule(false);
        Object module = nameToModule.get(name);
        if (Objects.nonNull(module)) {
            return this.getModule(module);
        }
        String msg = "Module " + name + " not found in layer " + this.layerName;
        if (logError) {
            this.logOrPrintError(msg);
        } else {
            this.logOrPrint(msg, Logger::debug);
        }
        return null;
    }

    private ModuleAccess getModuleFromSet(String name) {
        for (Object module : this.modules()) {
            ModuleAccess mAccess = this.getModule(module);
            if (!name.equals(mAccess.getName())) continue;
            return mAccess;
        }
        return null;
    }

    String getModuleName(Object module) {
        return this.getModule(module).getName();
    }

    @IndirectCallers
    Collection<String> getModulePackages(Object module) {
        return this.getModulePackages(this.getModule(module));
    }

    Collection<String> getModulePackages(ModuleAccess module) {
        return module.getPackages();
    }

    public ServicesCatalogAccess getServicesCatalog() {
        return this.getJavaLangAccess().getServicesCatalog(this);
    }

    public boolean hasMatchingModuleInSet(String name) {
        for (ModuleAccess module : this.moduleAccessors()) {
            if (!name.equals(module.getName())) continue;
            return true;
        }
        return false;
    }

    public Set<String> moduleNames() {
        return this.modules().stream().map(this::getModuleName).collect(Collectors.toSet());
    }

    public Set<Object> modules() {
        return this.modules(false);
    }

    public Set<Object> modules(boolean modifiable) {
        Set modules = (Set)this.invoke("modules", new Object[0]);
        return modifiable ? new HashSet(modules) : modules;
    }

    public Set<ModuleAccess> moduleAccessors() {
        return this.modules().stream().map(this::getModule).collect(Collectors.toSet());
    }

    public void moveServicesTo(ModuleLayerAccess target, ModuleAccess module, String ... serviceMovementBlacklist) {
        this.logOrPrint("Moving services from " + this.layerName + " to " + target.layerName, Logger::debug);
        this.moveServicesTo(target.getServicesCatalog(), module, serviceMovementBlacklist);
    }

    public void moveServicesTo(ServicesCatalogAccess target, ModuleAccess module, String ... serviceMovementBlacklist) {
        target.inheritProviders(this.getServicesCatalog(), module.access, module.getName(), Arrays.asList(serviceMovementBlacklist));
    }

    @IndirectCallers
    public Map<String, Object> nameToModule() {
        return this.nameToModule(true);
    }

    public Map<String, Object> nameToModule(boolean modifiable) {
        Map nameToModule = (Map)this.getDirect("nameToModule");
        return modifiable ? new HashMap(nameToModule) : nameToModule;
    }

    public ModuleAccess newModule(ClassLoaderAccess loader, ModuleDescriptorAccess moduleDescriptor, URI uri) {
        return this.newModule(this.access, loader.unwrap(), moduleDescriptor.access, uri);
    }

    @IndirectCallers
    public ModuleAccess newModule(ClassLoader loader, Object moduleDescriptor, URI uri) {
        return this.newModule(this.access, loader, moduleDescriptor, uri);
    }

    @IndirectCallers
    public List<Object> parents() {
        return this.parents(false);
    }

    public List<Object> parents(boolean modifiable) {
        List parents = (List)this.getDirect("parents");
        return modifiable ? new ArrayList(parents) : parents;
    }

    @Override
    public void removeModule(String moduleName) {
        this.removeModuleAndReturn(moduleName);
    }

    public ModuleAccess removeModuleAndReturn(String moduleName) {
        Map<String, Object> nameToModule = this.nameToModule();
        if (!nameToModule.containsKey(moduleName)) {
            return null;
        }
        Object module = nameToModule.get(moduleName);
        nameToModule.remove(moduleName);
        this.setNameToModule(nameToModule);
        Set<Object> modules = this.modules(true);
        modules.remove(module);
        this.setModules(modules);
        return this.getModule(module);
    }

    @IndirectCallers
    void removeModuleFromSet(String moduleName) {
        Set<Object> modules = this.modules(true);
        modules.removeIf(module -> this.getModuleName(module).equals(moduleName));
        this.setModules(modules);
    }

    @IndirectCallers
    public void removeServiceImplementations(String serviceName, String impl) {
        this.getServicesCatalog().removeImplementations(serviceName, impl);
    }

    public void renameModule(String name, String newName) {
        ModuleAccess module = this.removeModuleAndReturn(name);
        if (Objects.nonNull(module)) {
            module.setName(newName);
            this.addModule(newName, module);
        }
    }

    public void setModules(Set<Object> modules) {
        this.setDirect("modules", Collections.unmodifiableSet(modules));
    }

    public void setNameToModule(Map<String, Object> nameToModule) {
        this.setDirect("nameToModule", nameToModule.isEmpty() ? Collections.emptyMap() : nameToModule);
    }

    @Generated
    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    @Generated
    public String getLayerName() {
        return this.layerName;
    }
}

