/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.modules;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiConsumer;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ClassAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ClassLoaderAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ConfigurationAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.JavaLangAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleDescriptorAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleDescriptorBuilderAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleLayerAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleReferenceAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ResolvedModuleAccess;
import org.apache.logging.log4j.Logger;

public interface ModuleSystemAccessor {
    public static final String MODULE_CLASS = "java.lang.Module";
    public static final String MODULE_DESCRIPTOR_CLASS = "java.lang.module.ModuleDescriptor";
    public static final String RESOLVED_MODULE_CLASS = "java.lang.module.ResolvedModule";

    public static <T> T construct(Object accessorOrLogger, String targetName, Object ... args) {
        return ModuleSystemAccessor.construct(accessorOrLogger, ModuleSystemAccessor.getClassForName(targetName, accessorOrLogger), args);
    }

    public static <T> T construct(Object accessorOrLogger, Class<?> target, Object ... args) {
        return ModuleSystemAccessor.construct(accessorOrLogger, target, false, args);
    }

    public static <T> T construct(Object accessorOrLogger, Class<?> target, boolean direct, Object ... args) {
        if (Objects.nonNull(target)) {
            return direct ? Hacks.constructDirect(target, args) : Hacks.constructAndCast(target, args);
        }
        String msg = "Cannot contruct null class! args = " + Arrays.toString(args);
        Logger logger = ModuleSystemAccessor.getAsLogger(accessorOrLogger);
        if (Objects.nonNull(logger)) {
            logger.error(msg);
        } else {
            System.err.println(msg);
        }
        return null;
    }

    public static <T> T constructDirect(Object accessorOrLogger, Class<?> target, Object ... args) {
        return ModuleSystemAccessor.construct(accessorOrLogger, target, true, args);
    }

    @IndirectCallers
    public static <T> T constructDirect(Object accessorOrLogger, String targetName, Object ... args) {
        return ModuleSystemAccessor.constructDirect(accessorOrLogger, ModuleSystemAccessor.getClassForName(targetName, accessorOrLogger), args);
    }

    public static Logger getAsLogger(Object accessorOrLogger) {
        if (accessorOrLogger instanceof ModuleSystemAccessor) {
            return ((ModuleSystemAccessor)accessorOrLogger).logger();
        }
        if (accessorOrLogger instanceof Logger) {
            return (Logger)accessorOrLogger;
        }
        return null;
    }

    public static ClassAccess getClassAccess(String className, boolean intialize, ClassLoader loader, Object accessorOrLogger) {
        return ModuleSystemAccessor.getClassAccess(ModuleSystemAccessor.getClassForName(className, intialize, loader, accessorOrLogger), accessorOrLogger);
    }

    public static ClassAccess getClassAccess(Class<?> clazz, Object accessorOrLogger) {
        return Objects.nonNull(clazz) ? new ClassAccess(clazz, accessorOrLogger) : null;
    }

    public static Class<?> getClassForName(String className, Object accessorOrLogger) {
        try {
            return Class.forName(className);
        }
        catch (Throwable t) {
            String msg = "Failed to get class for " + className;
            Logger logger = ModuleSystemAccessor.getAsLogger(accessorOrLogger);
            if (Objects.nonNull(logger)) {
                logger.error(msg, t);
            } else {
                System.err.println(msg);
                t.printStackTrace(System.err);
            }
            return null;
        }
    }

    public static Class<?> getClassForName(String className, boolean initialize, ClassLoader loader, Object accessorOrLogger) {
        try {
            return Class.forName(className, initialize, loader);
        }
        catch (Throwable t) {
            String msg = "Failed to get class for " + className;
            Logger logger = ModuleSystemAccessor.getAsLogger(accessorOrLogger);
            if (Objects.nonNull(logger)) {
                logger.error(msg, t);
            } else {
                System.err.println(msg);
                t.printStackTrace(System.err);
            }
            return null;
        }
    }

    public static ClassLoaderAccess getClassLoader(ClassLoader loader, Object accessorOrLogger) {
        return new ClassLoaderAccess(loader, accessorOrLogger);
    }

    public static ConfigurationAccess getConfiguration(Object configuration, Object accessorOrLogger) {
        return new ConfigurationAccess(configuration, accessorOrLogger);
    }

    public static JavaLangAccess getJavaLangAccess(Object accessorOrLogger) {
        Object access = ModuleSystemAccessor.getStaticDirect(ServiceLoader.class, "LANG_ACCESS", accessorOrLogger);
        return ModuleSystemAccessor.getJavaLangAccess(access, accessorOrLogger);
    }

    public static JavaLangAccess getJavaLangAccess(Object langAccess, Object accessorOrLogger) {
        return new JavaLangAccess(langAccess, accessorOrLogger);
    }

    public static ModuleAccess getModule(Object module, Object accessorOrLogger) {
        return new ModuleAccess(module, accessorOrLogger);
    }

    public static ModuleDescriptorAccess getModuleDescriptor(Object moduleDescriptor, Object accessorOrLogger) {
        return new ModuleDescriptorAccess(moduleDescriptor, accessorOrLogger);
    }

    public static ModuleDescriptorBuilderAccess getModuleDescriptorBuilder(String moduleName, Object accessorOrLogger) {
        return (ModuleDescriptorBuilderAccess)ModuleSystemAccessor.invokeStatic(accessorOrLogger, MODULE_DESCRIPTOR_CLASS, "newAutomaticModule", moduleName);
    }

    public static ModuleDescriptorBuilderAccess getModuleDescriptorBuilder(Object builder, Object accessorOrLogger) {
        return new ModuleDescriptorBuilderAccess(builder, accessorOrLogger);
    }

    public static ModuleLayerAccess getModuleLayer(Object moduleLayer, Object accessorOrLogger) {
        return new ModuleLayerAccess(moduleLayer, accessorOrLogger);
    }

    public static ModuleReferenceAccess getModuleReference(Object moduleReference, Object accessorOrLogger) {
        return Objects.nonNull(moduleReference) ? new ModuleReferenceAccess(moduleReference, accessorOrLogger) : null;
    }

    public static ResolvedModuleAccess getResolvedModule(Object resolvedModule, Object accessorOrLogger) {
        return Objects.nonNull(resolvedModule) ? new ResolvedModuleAccess(resolvedModule, accessorOrLogger) : null;
    }

    @IndirectCallers
    public static <T> T getStatic(String className, String name, Object accessorOrLogger) {
        return ModuleSystemAccessor.getStatic(className, name, false, accessorOrLogger);
    }

    @IndirectCallers
    public static <T> T getStatic(Class<?> target, String name, Object accessorOrLogger) {
        return ModuleSystemAccessor.getStatic(target, name, false, accessorOrLogger);
    }

    public static <T> T getStatic(String className, String name, boolean direct, Object accessorOrLogger) {
        return ModuleSystemAccessor.getStatic(ModuleSystemAccessor.getClassForName(className, accessorOrLogger), name, direct, accessorOrLogger);
    }

    public static <T> T getStatic(Class<?> target, String name, boolean direct, Object accessorOrLogger) {
        if (Objects.nonNull(target)) {
            return direct ? Hacks.getFieldStaticDirect(target, name) : Hacks.getFieldStatic(target, name);
        }
        String msg = "Cannot get static field " + name + " on null target class!";
        Logger logger = ModuleSystemAccessor.getAsLogger(accessorOrLogger);
        if (Objects.nonNull(logger)) {
            logger.error(msg);
        } else {
            System.err.println(msg);
        }
        return null;
    }

    @IndirectCallers
    public static <T> T getStaticDirect(String className, String name, Object accessorOrLogger) {
        return ModuleSystemAccessor.getStatic(className, name, true, accessorOrLogger);
    }

    public static <T> T getStaticDirect(Class<?> target, String name, Object accessorOrLogger) {
        return ModuleSystemAccessor.getStatic(target, name, true, accessorOrLogger);
    }

    public static <T> T invokeStatic(Object accessorOrLogger, String targetName, String methodName, Object ... args) {
        return ModuleSystemAccessor.invokeStatic(accessorOrLogger, targetName, methodName, false, args);
    }

    public static <T> T invokeStatic(Object accessorOrLogger, Class<?> target, String methodName, Object ... args) {
        return ModuleSystemAccessor.invokeStatic(accessorOrLogger, target, methodName, false, args);
    }

    public static <T> T invokeStatic(Object accessorOrLogger, String targetName, String methodName, boolean direct, Object ... args) {
        return ModuleSystemAccessor.invokeStatic(accessorOrLogger, ModuleSystemAccessor.getClassForName(targetName, accessorOrLogger), methodName, direct, args);
    }

    public static <T> T invokeStatic(Object accessorOrLogger, Class<?> target, String methodName, boolean direct, Object ... args) {
        if (Objects.nonNull(target)) {
            return direct ? Hacks.invokeStaticDirect(target, methodName, args) : Hacks.invokeStatic(target, methodName, args);
        }
        String msg = "Cannot invoke static method " + methodName + " on null target class!";
        Logger logger = ModuleSystemAccessor.getAsLogger(accessorOrLogger);
        if (Objects.nonNull(logger)) {
            logger.error(msg);
        } else {
            System.err.println(msg);
        }
        return null;
    }

    public static <T> T invokeStaticDirect(Object accessorOrLogger, Class<?> target, String methodName, Object ... args) {
        return ModuleSystemAccessor.invokeStatic(accessorOrLogger, target, methodName, true, args);
    }

    public static <T> T invokeStaticDirect(Object accessorOrLogger, String targetClass, String methodName, Object ... args) {
        return ModuleSystemAccessor.invokeStatic(accessorOrLogger, targetClass, methodName, true, args);
    }

    public static ModuleAccess newModule(Object accessorOrLogger, Object layer, ClassLoader loader, Object descriptor, URI uri) {
        return ModuleSystemAccessor.getModule(ModuleSystemAccessor.construct(accessorOrLogger, MODULE_CLASS, layer, loader, descriptor, uri), accessorOrLogger);
    }

    public static ResolvedModuleAccess newResolvedModule(Object accessorOrLogger, Object configuration, Object moduleReference) {
        Object resolvedModule = ModuleSystemAccessor.construct(accessorOrLogger, RESOLVED_MODULE_CLASS, configuration, moduleReference);
        return ModuleSystemAccessor.getResolvedModule(resolvedModule, accessorOrLogger);
    }

    public Object access();

    default public <T> T as(Object o) {
        return (T)o;
    }

    default public <T> T as(Object o, T ifNull) {
        return Objects.nonNull(o) ? this.as(o) : ifNull;
    }

    @IndirectCallers
    default public <T> Collection<T> asCollection(Object object) {
        return this.as(object, Collections.emptySet());
    }

    @IndirectCallers
    default public <T> List<T> asList(Object object) {
        return this.as(object, Collections.emptyList());
    }

    @IndirectCallers
    default public <K, V> Map<K, V> asMap(Object object) {
        return this.as(object, Collections.emptyMap());
    }

    @IndirectCallers
    default public Map<String, Object> asMapDefault(Object object) {
        return this.as(object, Collections.emptyMap());
    }

    @IndirectCallers
    default public <K, V> Map<K, Collection<V>> asMapCollectionValue(Object object) {
        return this.as(object, Collections.emptyMap());
    }

    @IndirectCallers
    default public <T> Optional<T> asOptional(Object object) {
        return this.as(object, Optional.empty());
    }

    @IndirectCallers
    default public <T> T asOptionalResult(Object object) {
        return this.asOptionalResult(object, null);
    }

    default public <T> T asOptionalResult(Object object, T orElse) {
        Optional<T> optional = this.asOptional(object);
        return optional.orElse(orElse);
    }

    @IndirectCallers
    default public <T> Set<T> asSet(Object object) {
        return this.as(object, Collections.emptySet());
    }

    default public <T> T get(String name) {
        return this.get(name, false);
    }

    default public <T> T get(String name, boolean direct) {
        Object obj = this.access();
        if (Objects.nonNull(obj)) {
            return direct ? Hacks.getFieldDirect(obj, name) : Hacks.getField(obj, name);
        }
        this.logOrPrintError("Cannot get field " + name + "! (return value of access() was null)");
        return null;
    }

    @IndirectCallers
    default public <T> T getDirect(String name) {
        return this.get(name, true);
    }

    default public <T> T invoke(String name, Object ... args) {
        return this.invoke(name, false, args);
    }

    default public <T> T invoke(String name, boolean direct, Object ... args) {
        Object obj = this.access();
        if (Objects.nonNull(obj)) {
            return direct ? Hacks.invokeDirect(obj, name, args) : Hacks.invoke(obj, name, args);
        }
        this.logger().error("Cannot invoke method {}! (return value of access() was null)", (Object)name);
        return null;
    }

    default public <T> T invokeDirect(String name, Object ... args) {
        return this.invoke(name, true, args);
    }

    default public void logOrPrint(String msg, BiConsumer<Logger, String> log) {
        this.logOrPrint(msg, false, log);
    }

    default public void logOrPrint(String msg, boolean isError, BiConsumer<Logger, String> log) {
        this.logOrPrint(msg, isError, log, null);
    }

    default public void logOrPrint(String msg, boolean isError, BiConsumer<Logger, String> log, Throwable t) {
        Logger logger = this.logger();
        if (Objects.nonNull(logger)) {
            if (Objects.nonNull(log)) {
                log.accept(logger, msg);
            } else {
                msg = "[MISSING LOG FUNCTION] " + msg;
                if (Objects.nonNull(t)) {
                    logger.info(msg, t);
                } else {
                    logger.info(msg);
                }
            }
        } else if (isError) {
            System.err.println(msg);
            if (Objects.nonNull(t)) {
                t.printStackTrace(System.err);
            }
        } else {
            System.out.println(msg);
            if (Objects.nonNull(t)) {
                t.printStackTrace(System.out);
            }
        }
    }

    default public void logOrPrintError(String msg) {
        this.logOrPrint(msg, true, Logger::error);
    }

    default public void logOrPrintError(String msg, Throwable t) {
        this.logOrPrint(msg, true, (logger, s) -> logger.error(s, t), t);
    }

    public Logger logger();

    default public void set(String name, Object value) {
        this.set(name, value, false);
    }

    default public void set(String name, Object value, boolean direct) {
        Object obj = this.access();
        if (Objects.nonNull(obj)) {
            if (direct) {
                Hacks.setFieldDirect(obj, name, value);
            } else {
                Hacks.setField(obj, name, value);
            }
            return;
        }
        this.logOrPrintError("Cannot set field " + name + " to " + value + "! (return value of access() was null)");
    }

    @IndirectCallers
    default public void setDirect(String name, Object value) {
        this.set(name, value, true);
    }
}

