/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.AbstractModuleSystemAccessor;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ServiceProviderAccess;
import org.apache.logging.log4j.Logger;

public class ServicesCatalogAccess
extends AbstractModuleSystemAccessor {
    static final String SERVICE_PROVIDER_CLASS = "jdk.internal.module.ServicesCatalog$ServiceProvider";

    ServicesCatalogAccess(Object servicesCatalog, Object accessorOrLogger) {
        super(servicesCatalog, accessorOrLogger);
    }

    @IndirectCallers
    public void addProvider(String serviceName, ModuleAccess module, String providerName) {
        this.addProvider(serviceName, this.constructProvider(module, providerName));
    }

    public void addProvider(String serviceName, Object module, String providerName) {
        this.addProvider(serviceName, this.constructProvider(module, providerName));
    }

    public void addProvider(String serviceName, ServiceProviderAccess provider) {
        this.invokeDirect("addProviders", serviceName, provider.access);
    }

    public ServiceProviderAccess asProvider(Object provider) {
        return new ServiceProviderAccess(provider, this);
    }

    public ServiceProviderAccess constructProvider(ModuleAccess module, String providerName) {
        return this.constructProvider(module.access(), providerName);
    }

    public ServiceProviderAccess constructProvider(Object module, String providerName) {
        return this.asProvider(Hacks.construct(this.providerClass(), module, providerName));
    }

    boolean containsProviderFor(String service, String impl, String moduleName) {
        Map<String, List<Object>> existingProviders = this.providers();
        if (!existingProviders.containsKey(service)) {
            return false;
        }
        for (Object provider : existingProviders.get(service)) {
            ServiceProviderAccess access = this.asProvider(provider);
            if (!impl.equals(access.providerName()) || !moduleName.equals(access.moduleName())) continue;
            return true;
        }
        return false;
    }

    Map<String, List<String>> getProvidersFor(String module) {
        HashMap<String, List<String>> providers = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<Object>> serviceEntry : this.providers().entrySet()) {
            String service = serviceEntry.getKey();
            for (Object provider : serviceEntry.getValue()) {
                ServiceProviderAccess access = this.asProvider(provider);
                if (!module.equals(access.moduleName())) continue;
                providers.putIfAbsent(service, new ArrayList());
                ((List)providers.get(service)).add(access.providerName());
            }
        }
        return providers;
    }

    public void inheritProviders(ServicesCatalogAccess catalog, Object module, String moduleName, Collection<String> serviceMovementBlacklist) {
        this.logger.info("Inherting providers for {} (blacklist = {})", module, serviceMovementBlacklist);
        Map<String, List<String>> serviceMap = catalog.getProvidersFor(moduleName);
        for (Map.Entry<String, List<String>> serviceEntry : serviceMap.entrySet()) {
            String service = serviceEntry.getKey();
            for (String provider : serviceEntry.getValue()) {
                if (this.containsProviderFor(service, provider, moduleName)) continue;
                this.addProvider(service, module, provider);
            }
        }
        catalog.removeProviders(serviceMap, serviceMovementBlacklist);
    }

    public Class<?> providerClass() {
        return Hacks.findClass(SERVICE_PROVIDER_CLASS);
    }

    public Map<String, List<Object>> providers() {
        return (Map)this.getDirect("map");
    }

    public void registerModule(ModuleAccess module) {
        if (Objects.nonNull(module)) {
            this.logOrPrint("Registering module " + module.getName() + " to service catalog", Logger::info);
            this.registerModule(module.access);
        } else {
            this.logOrPrint("Not registering null module accessor", Logger::warn);
        }
    }

    public void registerModule(Object module) {
        if (Objects.nonNull(module)) {
            this.invokeDirect("register", module);
        } else {
            this.logOrPrint("Not registering null module", Logger::warn);
        }
    }

    public boolean removeImplementations(String service, String impl) {
        return ((List)this.providers().getOrDefault(service, new ArrayList())).removeIf(provider -> impl.equals(this.asProvider(provider).providerName()));
    }

    void removeProviders(Map<String, List<String>> serviceMap, Collection<String> serviceMovementBlacklist) {
        Map<String, List<Object>> existingServiceMap = this.providers();
        for (Map.Entry<String, List<String>> serviceEntry : serviceMap.entrySet()) {
            String service = serviceEntry.getKey();
            if (serviceMovementBlacklist.contains(service)) continue;
            List<String> providers = serviceEntry.getValue();
            if (!existingServiceMap.containsKey(service)) continue;
            List<Object> values = existingServiceMap.get(service);
            values.removeIf(o -> providers.contains(this.asProvider(o).providerName()));
            if (!values.isEmpty()) continue;
            existingServiceMap.remove(service);
        }
    }
}

