/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.integration;

import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.integration.ModAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import org.jetbrains.annotations.Nullable;

public abstract class Weather2API
implements ModAPI {
    public static final String MODID = "weather2remaster";
    public static final String NAME = "Weather 2 - Remastered";

    protected Weather2API() {
    }

    @IndirectCallers
    @Nullable
    public abstract WeatherData getClosestBlizzard(WorldAPI<?> var1, BlockPosAPI<?> var2, double var3);

    @IndirectCallers
    @Nullable
    public abstract WeatherData getClosestCloud(WorldAPI<?> var1, BlockPosAPI<?> var2, double var3);

    @IndirectCallers
    @Nullable
    public abstract WeatherData getClosestHurricane(WorldAPI<?> var1, BlockPosAPI<?> var2, double var3);

    @IndirectCallers
    @Nullable
    public abstract WeatherData getClosestSandStorm(WorldAPI<?> var1, BlockPosAPI<?> var2, double var3);

    @IndirectCallers
    @Nullable
    public abstract WeatherData getClosestStorm(WorldAPI<?> var1, BlockPosAPI<?> var2, double var3);

    @IndirectCallers
    @Nullable
    public abstract WeatherData getClosestTornado(WorldAPI<?> var1, BlockPosAPI<?> var2, double var3);

    @Override
    public String getID() {
        return MODID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isCompatible(CoreAPI.ModLoader loader, CoreAPI.Side side, CoreAPI.GameVersion version) {
        return version.isV12() && loader.isLegacyForge() || loader.isModernForge() && (version.isV18() || version.isV20());
    }

    public static enum WeatherType {
        BLIZZARD,
        CLOUD,
        HURRICANE,
        RAIN,
        SANDSTORM,
        SUPERCELL,
        THUNDER,
        TORNADO,
        TROPICAL_DEPRESSION,
        TROPICAL_DISTURBANCE,
        TROPICAL_STORM;

    }

    public static class WeatherData {
        private final WeatherType type;
        private final Vector3 pos;
        private int level;

        public WeatherData(@Nullable WeatherType type, Vector3 pos, int level) {
            this.type = type;
            this.pos = pos;
            this.level = level;
        }

        @IndirectCallers
        public boolean isBlizzard() {
            return this.type == WeatherType.BLIZZARD;
        }

        @IndirectCallers
        public boolean isHurricane() {
            return this.type == WeatherType.HURRICANE;
        }

        @IndirectCallers
        public boolean isSandstorm() {
            return this.type == WeatherType.SANDSTORM;
        }

        @IndirectCallers
        public boolean isTornado() {
            return this.type == WeatherType.TORNADO;
        }

        @IndirectCallers
        public boolean isTropical() {
            return this.type == WeatherType.TROPICAL_DEPRESSION || this.type == WeatherType.TROPICAL_DISTURBANCE || this.type == WeatherType.TROPICAL_STORM;
        }

        @Generated
        public WeatherType getType() {
            return this.type;
        }

        @Generated
        public Vector3 getPos() {
            return this.pos;
        }

        @Generated
        public int getLevel() {
            return this.level;
        }

        @Generated
        public void setLevel(int level) {
            this.level = level;
        }
    }
}

