/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ArrayHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.integration.ModHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.io.FileHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Patterns;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class LogHelper {
    public static ModLogger create(String modid) {
        return LogHelper.create(modid, null);
    }

    public static ModLogger create(String modid, @Nullable String name) {
        return new ModLogger(modid, name);
    }

    @IndirectCallers
    public static void logCollection(ModLogger logger, Level level, String msg, Collection<Object> elements) {
        logger.log(level, LogHelper.collectionToString(msg, elements, Object::toString, 0), new Object[0]);
    }

    @IndirectCallers
    public static void logCollection(ModLogger logger, Level level, String msg, Collection<Object> elements, Function<Object, String> toString) {
        logger.log(level, LogHelper.collectionToString(msg, elements, toString, 0), new Object[0]);
    }

    @IndirectCallers
    public static void logCollection(ModLogger logger, Level level, String msg, Collection<Object> elements, Function<Object, String> toString, int perLine) {
        logger.log(level, LogHelper.collectionToString(msg, elements, toString, perLine), new Object[0]);
    }

    @IndirectCallers
    public static void logAndThrow(Logger logger, Level level, String msg, Throwable t, Object ... args) throws RuntimeException {
        if (level == Level.FATAL) {
            LogHelper.logFatalAndThrow(logger, msg, t, args);
        } else if (level == Level.ERROR) {
            LogHelper.logErrorAndThrow(logger, msg, t, args);
        } else if (level == Level.WARN) {
            LogHelper.logWarnAndThrow(logger, msg, t, args);
        } else if (level == Level.INFO) {
            LogHelper.logInfoAndThrow(logger, msg, t, args);
        } else if (level == Level.DEBUG) {
            LogHelper.logDebugAndThrow(logger, msg, t, args);
        } else if (level == Level.TRACE) {
            LogHelper.logTraceAndThrow(logger, msg, t, args);
        } else {
            TILRef.logWarn("Log level '{}' not supported for LogHelper#logAndThrow! Assuming ERROR level", new Object[0]);
            LogHelper.logErrorAndThrow(logger, msg, t, args);
        }
    }

    public static void logDebugAndThrow(Logger logger, String msg, Throwable t, Object ... args) throws RuntimeException {
        logger.debug(msg, (Object)args, (Object)t);
        throw new RuntimeException(LogHelper.injectParameters(msg, args), t);
    }

    public static void logErrorAndThrow(Logger logger, String msg, Throwable t, Object ... args) throws RuntimeException {
        logger.error(msg, (Object)args, (Object)t);
        throw new RuntimeException(LogHelper.injectParameters(msg, args), t);
    }

    public static void logFatalAndThrow(Logger logger, String msg, Throwable t, Object ... args) throws RuntimeException {
        logger.fatal(msg, (Object)args, (Object)t);
        throw new RuntimeException(LogHelper.injectParameters(msg, args), t);
    }

    public static void logInfoAndThrow(Logger logger, String msg, Throwable t, Object ... args) throws RuntimeException {
        logger.info(msg, (Object)args, (Object)t);
        throw new RuntimeException(LogHelper.injectParameters(msg, args), t);
    }

    public static void logTraceAndThrow(Logger logger, String msg, Throwable t, Object ... args) throws RuntimeException {
        logger.trace(msg, (Object)args, (Object)t);
        throw new RuntimeException(LogHelper.injectParameters(msg, args), t);
    }

    public static void logWarnAndThrow(Logger logger, String msg, Throwable t, Object ... args) throws RuntimeException {
        logger.warn(msg, (Object)args, (Object)t);
        throw new RuntimeException(LogHelper.injectParameters(msg, args), t);
    }

    public static String collectionToString(String msg, Collection<Object> elements, Function<Object, String> toString, int perLine) {
        StringJoiner joiner = new StringJoiner(" ");
        int count = 0;
        for (Object element : elements) {
            String elementStr;
            String string = Objects.nonNull(element) ? (Objects.nonNull(toString) ? toString.apply(element) : element.toString()) : (elementStr = "null");
            if (count > perLine) {
                joiner.add(elementStr + "\n");
                count = 0;
                continue;
            }
            joiner.add(elementStr);
            ++count;
        }
        return TextHelper.isNotEmpty(msg) ? msg + " " + joiner : joiner.toString();
    }

    private static String fixRegex(@Nullable Object value) {
        return String.valueOf(value).replace("$", "\\$");
    }

    public static String injectParameters(String message, Object ... parameters) {
        if (Objects.isNull(message)) {
            return "null";
        }
        if (ArrayHelper.isNotEmpty(parameters)) {
            for (Object parameter : parameters) {
                if (!message.contains("{}")) break;
                message = message.replaceFirst(Patterns.BRACKETS_LITERAL, LogHelper.fixRegex(parameter));
            }
        }
        return message;
    }

    public static class ModLogger {
        private final File logFile;
        private final String logName;
        private Writer writer;
        private int linesWritten;

        private ModLogger(String modid, @Nullable String name) {
            this.logFile = FileHelper.get(LogHelper.injectParameters("./logs/mods/{}.log", modid), true);
            this.logName = Objects.nonNull(name) ? name : this.getModName(modid);
            this.linesWritten = 0;
            this.writer = this.initWriter();
        }

        public void all(String message, Object ... parameters) {
            this.log(Level.ALL, message, parameters);
        }

        public void debug(String message, Object ... parameters) {
            this.log(Level.DEBUG, message, parameters);
        }

        public void error(String message, Object ... parameters) {
            this.log(Level.ERROR, message, parameters);
        }

        @IndirectCallers
        public void fatal(String message, Object ... parameters) {
            this.log(Level.FATAL, message, parameters);
        }

        private String finalizeMessage(Level level, String constructedMessage) {
            return this.formattedTimeStamp(LocalDateTime.now()) + " " + this.formattedLogLevel(level) + ": " + constructedMessage + "\n";
        }

        private String formattedLogLevel(Level level) {
            String name = Objects.nonNull(level) ? level.name() : "NULL";
            return LogHelper.injectParameters("[{}/{}]", this.logName, name.length() < 5 ? name + " " : name);
        }

        private String formattedMilli(int milli) {
            if (milli < 10) {
                return "00" + milli;
            }
            if (milli < 100) {
                return "0" + milli;
            }
            return String.valueOf(milli);
        }

        private String formattedTimeStamp(LocalDateTime time) {
            int hour = time.getHour();
            int minute = time.getMinute();
            int second = time.getSecond();
            return LogHelper.injectParameters("[{}:{}:{}:{}]", hour < 10 ? "0" + hour : Integer.valueOf(hour), minute < 10 ? "0" + minute : Integer.valueOf(minute), second < 10 ? "0" + second : Integer.valueOf(second), this.formattedMilli(time.getNano() / 1000000));
        }

        private String getModName(String modid) {
            String name = ModHelper.getModName(modid);
            return TextHelper.isNotBlank(name) ? name : modid;
        }

        public void info(String message, Object ... parameters) {
            this.log(Level.INFO, message, parameters);
        }

        Writer initWriter() {
            Path path = this.logFile.toPath();
            try {
                return new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), StandardCharsets.UTF_8);
            }
            catch (Exception ex) {
                TILRef.logError("Could not create log file for {}", this.logName, ex);
                return null;
            }
        }

        public void log(Level level, String msg, Object ... parameters) {
            String message = this.finalizeMessage(level, LogHelper.injectParameters(msg, parameters));
            if (Objects.isNull(this.writer)) {
                TILRef.logError("Tried to write the following message with a null writer: `{}`", message);
                this.writer = this.initWriter();
            } else {
                this.writeMessage(message);
            }
        }

        @IndirectCallers
        public void off(String message, Object ... parameters) {
            this.log(Level.OFF, message, parameters);
        }

        @IndirectCallers
        public void trace(String message, Object ... parameters) {
            this.log(Level.TRACE, message, parameters);
        }

        @IndirectCallers
        public void warn(String message, Object ... parameters) {
            this.log(Level.WARN, message, parameters);
        }

        void writeMessage(String message) {
            block2: {
                try {
                    this.writer.write(message);
                    this.writer.flush();
                    ++this.linesWritten;
                }
                catch (IOException ex) {
                    TILRef.logError("Failed to write message to {}: `{}`", this.logFile, message, ex);
                    if (!(ex instanceof ClosedChannelException)) break block2;
                    TILRef.logInfo("Attempting to reinitialize closed logger", new Object[0]);
                    this.writer = this.initWriter();
                }
            }
        }

        @Generated
        public int getLinesWritten() {
            return this.linesWritten;
        }
    }
}

