/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.iterator;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Mappable<K, V>
implements Map<K, V>,
Iterable<Map.Entry<K, V>> {
    private final Map<K, V> map;

    public static <K, V> Mappable<K, V> make(Supplier<Map<K, V>> supplier) {
        return new Mappable<K, V>(supplier.get(), false);
    }

    @IndirectCallers
    public static <K, V> Mappable<K, V> make(Supplier<Map<K, V>> supplier, Consumer<Mappable<K, V>> settings) {
        Mappable<K, V> mappable = Mappable.make(supplier);
        settings.accept(mappable);
        return mappable;
    }

    public static <K, V> Mappable<K, V> makeSynchronized(Supplier<Map<K, V>> supplier) {
        return new Mappable<K, V>(supplier.get(), true);
    }

    @IndirectCallers
    public static <K, V> Mappable<K, V> makeSynchronized(Supplier<Map<K, V>> supplier, Consumer<Mappable<K, V>> settings) {
        Mappable<K, V> mappable = Mappable.make(supplier);
        settings.accept(mappable);
        return mappable;
    }

    public Mappable(Map<K, V> map, boolean isSynchronized) {
        this.map = isSynchronized ? Collections.synchronizedMap(map) : map;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    @Nullable
    public V compute(@Nullable K key, @NotNull BiFunction<? super K, ? super V, ? extends V> remappingFunc) {
        if (Objects.isNull(key)) {
            return null;
        }
        return this.map.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunc);
    }

    @Override
    @Nullable
    public V computeIfAbsent(@Nullable K key, @NotNull Function<? super K, ? extends V> mappingFunc) {
        if (Objects.isNull(key)) {
            return null;
        }
        return this.map.computeIfAbsent((K)key, mappingFunc);
    }

    @Override
    @Nullable
    public V computeIfPresent(@Nullable K key, @NotNull BiFunction<? super K, ? super V, ? extends V> remappingFunc) {
        if (Objects.isNull(key)) {
            return null;
        }
        return this.map.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunc);
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return Objects.nonNull(key) && this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<K, V>> action) {
        this.entrySet().forEach(action);
    }

    @IndirectCallers
    public void forEachKey(Consumer<? super K> action) {
        this.keySet().forEach(action);
    }

    @IndirectCallers
    public void forEachValue(Consumer<? super V> action) {
        this.values().forEach(action);
    }

    @Override
    @Nullable
    public V get(@Nullable Object key) {
        return Objects.nonNull(key) ? (V)this.map.get(key) : null;
    }

    public K getKeyOrDefault(Function<V, Boolean> matcher, K defVal) {
        for (Map.Entry<K, V> entry : this) {
            if (!matcher.apply(entry.getValue()).booleanValue()) continue;
            return entry.getKey();
        }
        return defVal;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.entrySet().iterator();
    }

    @IndirectCallers
    public boolean keyAbsent(@Nullable Object key) {
        return Objects.isNull(key) || !this.containsKey(key);
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @IndirectCallers
    public Stream<Map.Entry<K, V>> parallelStream() {
        return this.entrySet().parallelStream();
    }

    @Override
    @Nullable
    public V put(@Nullable K key, V value) {
        return Objects.nonNull(key) ? (V)this.map.put(key, value) : null;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> otherMap) {
        this.map.putAll(otherMap);
    }

    @Override
    @Nullable
    public V putIfAbsent(@Nullable K key, V value) {
        if (Objects.isNull(key)) {
            return null;
        }
        return this.map.putIfAbsent(key, value);
    }

    @Override
    @Nullable
    public V remove(@Nullable Object key) {
        return Objects.nonNull(key) ? (V)this.map.remove(key) : null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Spliterator<Map.Entry<K, V>> spliterator() {
        return this.entrySet().spliterator();
    }

    public Stream<Map.Entry<K, V>> stream() {
        return this.entrySet().stream();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.map.values();
    }
}

