/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.JVMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.iterator.Mappable;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageDirectionInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageHandlerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageHandlerDefault;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import org.jetbrains.annotations.Nullable;

public class NetworkHandler {
    private static final boolean ALLOW_LATE_REGISTRATION = CoreAPI.isFabric();
    private static final boolean BOTH_SIDES = CoreAPI.isLegacy();
    private static final boolean DEBUG = TILDev.DEBUG_NETWORK;
    private static final boolean ENABLE_LOGIN = !CoreAPI.isForge() && !CoreAPI.isLegacy();
    private static final Mappable<?, MessageDirectionInfo<?>> DIRECTION_INFO = Mappable.makeSynchronized(HashMap::new);
    private static boolean initialized;
    private static boolean loadComplete;

    static boolean canRegisterLate() {
        return ALLOW_LATE_REGISTRATION && !TILRef.CLIENT_ONLY && !loadComplete;
    }

    @Nullable
    public static <DIR> MessageDirectionInfo<DIR> getDirectionInfo(DIR dir) {
        return (MessageDirectionInfo)GenericUtils.cast(DIRECTION_INFO.get(dir));
    }

    private static <DIR> MessageDirectionInfo<?> getOrInitDirectionInfo(DIR dir) {
        Mappable map = (Mappable)GenericUtils.cast(DIRECTION_INFO);
        if (Objects.isNull(map)) {
            TILRef.logError("Failed to get or initialize direction info for {}", dir);
            return null;
        }
        map.putIfAbsent(dir, new MessageDirectionInfo<DIR>(dir));
        return (MessageDirectionInfo)map.get(dir);
    }

    public static <DIR> boolean isRegistered(Class<?> msgClass, DIR dir) {
        MessageDirectionInfo<?> info = DIRECTION_INFO.get(dir);
        return Objects.nonNull(info) && info.contains(msgClass);
    }

    public static void load() {
        if (TILRef.CLIENT_ONLY) {
            if (DEBUG) {
                TILRef.logInfo("Skipping network registration since CLIENT_ONLY is enabled", new Object[0]);
            }
            return;
        }
        int id = 0;
        if (DEBUG) {
            if (DIRECTION_INFO.isEmpty()) {
                TILRef.logInfo("There are no network messages to register", new Object[0]);
            } else {
                TILRef.logInfo("Loading network messages for {} directions", DIRECTION_INFO.size());
            }
        }
        NetworkHelper.messageRegistrationStarted();
        for (MessageDirectionInfo<?> info : DIRECTION_INFO.values()) {
            NetworkHelper.registerMessage(info, id);
            if (DEBUG) {
                TILRef.logInfo("Registered network direction info: {} (id={})", info, id);
            }
            if (!JVMHelper.isJava17()) continue;
            ++id;
        }
        NetworkHelper.messageRegistrationFinished();
        initialized = true;
    }

    private static void logDirectionRegistrationDebug(Class<?> msgClass, boolean client) {
        if (DEBUG) {
            String dir = client ? "client" : "server";
            TILRef.logInfo("Tried to register {} as a {} login message, but the login direction is disabled!Registering as a {} message instead", msgClass, dir, dir);
        }
    }

    public static void onLoadComplete() {
        loadComplete = true;
    }

    @Nullable
    public static <DIR> MessageDirectionInfo<DIR> readDirectionInfo(ByteBuf buf) {
        return NetworkHandler.getDirectionInfo(NetworkHelper.readDir(buf));
    }

    public static <M extends MessageAPI<?>> void registerMsgToClient(Class<M> clazz, Function<ByteBuf, M> decoder) {
        NetworkHandler.registerMsg(clazz, decoder, NetworkHelper.getDirToClient());
    }

    public static <M extends MessageAPI<?>> void registerMsgToClient(Class<M> clazz, MessageHandlerAPI handler) {
        NetworkHandler.registerMsg(clazz, handler, NetworkHelper.getDirToClient());
    }

    public static <M extends MessageAPI<?>> void registerMsgToClientLogin(Class<M> clazz, Function<ByteBuf, M> decoder) {
        if (ENABLE_LOGIN) {
            NetworkHandler.registerMsg(clazz, decoder, NetworkHelper.getDirToClientLogin());
        } else {
            NetworkHandler.logDirectionRegistrationDebug(clazz, true);
            NetworkHandler.registerMsgToClient(clazz, decoder);
        }
    }

    public static <M extends MessageAPI<?>> void registerMsgToClientLogin(Class<M> clazz, MessageHandlerAPI handler) {
        if (ENABLE_LOGIN) {
            NetworkHandler.registerMsg(clazz, handler, NetworkHelper.getDirToClientLogin());
        } else {
            NetworkHandler.logDirectionRegistrationDebug(clazz, true);
            NetworkHandler.registerMsgToClient(clazz, handler);
        }
    }

    public static <M extends MessageAPI<?>> void registerMsgToServer(Class<M> clazz, Function<ByteBuf, M> decoder) {
        NetworkHandler.registerMsg(clazz, decoder, NetworkHelper.getDirToServer());
    }

    public static <M extends MessageAPI<?>> void registerMsgToServer(Class<M> clazz, MessageHandlerAPI handler) {
        NetworkHandler.registerMsg(clazz, handler, NetworkHelper.getDirToServer());
    }

    public static <M extends MessageAPI<?>> void registerMsgToServerLogin(Class<M> clazz, Function<ByteBuf, M> decoder) {
        if (ENABLE_LOGIN) {
            NetworkHandler.registerMsg(clazz, decoder, NetworkHelper.getDirToServerLogin());
        } else {
            NetworkHandler.logDirectionRegistrationDebug(clazz, false);
            NetworkHandler.registerMsgToServer(clazz, decoder);
        }
    }

    public static <M extends MessageAPI<?>> void registerMsgToServerLogin(Class<M> clazz, MessageHandlerAPI handler) {
        if (ENABLE_LOGIN) {
            NetworkHandler.registerMsg(clazz, handler, NetworkHelper.getDirToServerLogin());
        } else {
            NetworkHandler.logDirectionRegistrationDebug(clazz, false);
            NetworkHandler.registerMsgToServer(clazz, handler);
        }
    }

    private static <DIR, M extends MessageAPI<?>> void registerMsg(Class<M> clazz, Function<ByteBuf, M> decoder, DIR dir) {
        if (DEBUG) {
            TILRef.logInfo("Registering message {} to direction {} with function {}", clazz, dir, decoder);
        }
        NetworkHandler.registerMsg(dir, dirInfo -> new MessageInfo(clazz, (MessageDirectionInfo<?>)dirInfo, decoder));
        if (DEBUG) {
            TILRef.logInfo("Successfully registered {} function handler for message {}", dir, clazz);
        }
    }

    public static <DIR, M extends MessageAPI<?>> void registerMsg(Class<M> clazz, MessageHandlerAPI handler, DIR dir) {
        if (DEBUG) {
            TILRef.logInfo("Registering message {} to direction {} with handler type {}", clazz, dir, Objects.nonNull(handler) ? handler.getClass() : null);
        }
        NetworkHandler.registerMsg(dir, dirInfo -> new MessageInfo(clazz, (MessageDirectionInfo<?>)dirInfo, handler));
        if (DEBUG) {
            TILRef.logInfo("Successfully registered {} handler for message {}", dir, clazz);
        }
    }

    private static <DIR> void registerMsg(DIR dir, Function<MessageDirectionInfo<?>, MessageInfo<?>> infoSupplier) {
        ArrayList infos = null;
        if (Objects.nonNull(dir)) {
            MessageDirectionInfo<?> info = NetworkHandler.getOrInitDirectionInfo(dir);
            if (Objects.nonNull(info)) {
                info.supply(infoSupplier);
                infos = new ArrayList();
                infos.add(GenericUtils.cast(info));
            } else {
                TILRef.logError("Failed to register message for direction {}", dir);
            }
            if (BOTH_SIDES) {
                MessageDirectionInfo<?> oppositeInfo;
                DIR oppositeDir = NetworkHelper.getOppositeDir(dir);
                if (DEBUG) {
                    TILRef.logInfo("Registering message to opposite direction {} (direction={})", oppositeDir, dir);
                }
                if (Objects.nonNull(oppositeInfo = NetworkHandler.getOrInitDirectionInfo(oppositeDir))) {
                    oppositeInfo.supply(infoSupplier);
                    if (Objects.isNull(infos)) {
                        infos = new ArrayList();
                    }
                    infos.add(GenericUtils.cast(oppositeInfo));
                } else {
                    TILRef.logError("Failed to register message for opposite direction {}", oppositeDir);
                }
            }
        }
        if (initialized && NetworkHandler.canRegisterLate()) {
            NetworkHelper.registerLateMessages(infos);
        }
    }

    public static void registerMsgs(MessageInfo<?> ... infos) {
        NetworkHandler.registerMsgs(Arrays.asList(infos));
    }

    public static void registerMsgs(Iterable<MessageInfo<?>> infos) {
        for (MessageInfo<?> info : infos) {
            NetworkHandler.registerMsg(info.getMsgClass(), new MessageHandlerDefault(info::decode), info.getDirectionInfo().getDirection());
        }
    }

    @Generated
    public static boolean isInitialized() {
        return initialized;
    }
}

