/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.network.message;

import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageDirectionInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageHandlerAPI;

public final class MessageInfo<M extends MessageAPI<?>> {
    private final MessageDirectionInfo<?> directionInfo;
    private final Class<M> msgClass;
    private final MessageHandlerAPI handler;

    public MessageInfo(Class<M> clazz, MessageDirectionInfo<?> directionInfo) {
        this(clazz, directionInfo, MessageHandlerAPI.getDefault(clazz));
    }

    public MessageInfo(Class<M> clazz, MessageDirectionInfo<?> directionInfo, Function<ByteBuf, M> decoder) {
        this(clazz, directionInfo, MessageHandlerAPI.getDefault(decoder));
    }

    public MessageInfo(Class<M> clazz, MessageDirectionInfo<?> directionInfo, MessageHandlerAPI handler) {
        this.msgClass = clazz;
        this.directionInfo = directionInfo;
        this.handler = handler;
    }

    public M decode(ByteBuf buf) {
        return this.handler.decode(buf);
    }

    public void encode(M message, ByteBuf buf) {
        this.handler.encode(message, buf);
    }

    public <CTX> MessageAPI<CTX> handle(M message, CTX context) {
        return this.handler.handle(message, context);
    }

    @Generated
    public MessageDirectionInfo<?> getDirectionInfo() {
        return this.directionInfo;
    }

    @Generated
    public Class<M> getMsgClass() {
        return this.msgClass;
    }
}

