/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.registry.item;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ActionResult;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.TILItemUseContext;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ToolTierAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.item.ItemBuilderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.item.ItemProperties;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.tab.CreativeTabAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import org.jetbrains.annotations.Nullable;

public abstract class ToolBuilderAPI
extends ItemBuilderAPI {
    protected ItemBuilderAPI.ToolType toolType;
    protected float damageModifier;
    protected Collection<BlockAPI<?>> effectiveBlocks;
    protected float speedModifier;
    protected ToolTierAPI<?> toolTier;

    protected ToolBuilderAPI(@Nullable ItemBuilderAPI parent, ItemBuilderAPI.ToolType type) {
        super(parent);
        this.itemType = ItemBuilderAPI.ItemType.TOOL;
        this.toolType = type;
        this.damageModifier = 1.0f;
        this.effectiveBlocks = new HashSet();
        this.speedModifier = 1.0f;
        this.toolTier = ItemHelper.getToolTier("wood");
    }

    public ToolBuilderAPI addEffectiveBlock(BlockAPI<?> block) {
        this.effectiveBlocks.add(block);
        return this;
    }

    public ToolBuilderAPI addEffectiveBlocks(Collection<BlockAPI<?>> blocks) {
        this.effectiveBlocks.addAll(blocks);
        return this;
    }

    @Override
    public ToolBuilderAPI addProperty(ResourceLocationAPI<?> key, BiFunction<ItemStackAPI<?>, WorldAPI<?>, Float> propertyGetter) {
        this.propertyMap.put(key, propertyGetter);
        return this;
    }

    protected <I> I makeItem(ItemProperties properties) {
        Object[] args;
        String baseClassName;
        Object tier = this.toolTier.unwrap();
        switch (this.toolType) {
            case AXE: {
                Object[] objectArray;
                baseClassName = "TILItemAxe";
                if (VERSION.isAtLeast(CoreAPI.GameVersion.V21_1)) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = tier;
                    objectArray = objectArray2;
                    objectArray2[1] = properties;
                } else {
                    Object[] objectArray3 = new Object[4];
                    objectArray3[0] = tier;
                    objectArray3[1] = Float.valueOf(this.damageModifier);
                    objectArray3[2] = Float.valueOf(this.speedModifier);
                    objectArray = objectArray3;
                    objectArray3[3] = properties;
                }
                args = objectArray;
                break;
            }
            case HOE: {
                Object[] objectArray;
                baseClassName = "TILItemHoe";
                if (VERSION == CoreAPI.GameVersion.V12_2 || VERSION.isAtLeast(CoreAPI.GameVersion.V21_1)) {
                    Object[] objectArray4 = new Object[2];
                    objectArray4[0] = tier;
                    objectArray = objectArray4;
                    objectArray4[1] = properties;
                } else {
                    Object[] objectArray5 = new Object[4];
                    objectArray5[0] = tier;
                    objectArray5[1] = (int)this.damageModifier;
                    objectArray5[2] = Float.valueOf(this.speedModifier);
                    objectArray = objectArray5;
                    objectArray5[3] = properties;
                }
                args = objectArray;
                break;
            }
            case PICKAXE: {
                Object[] objectArray;
                baseClassName = "TILItemPickaxe";
                if (VERSION == CoreAPI.GameVersion.V12_2 || VERSION.isAtLeast(CoreAPI.GameVersion.V21_1)) {
                    Object[] objectArray6 = new Object[2];
                    objectArray6[0] = tier;
                    objectArray = objectArray6;
                    objectArray6[1] = properties;
                } else {
                    Object[] objectArray7 = new Object[4];
                    objectArray7[0] = tier;
                    objectArray7[1] = (int)this.damageModifier;
                    objectArray7[2] = Float.valueOf(this.speedModifier);
                    objectArray = objectArray7;
                    objectArray7[3] = properties;
                }
                args = objectArray;
                break;
            }
            case SHOVEL: {
                Object[] objectArray;
                baseClassName = "TILItemShovel";
                if (VERSION == CoreAPI.GameVersion.V12_2 || VERSION.isAtLeast(CoreAPI.GameVersion.V21_1)) {
                    Object[] objectArray8 = new Object[2];
                    objectArray8[0] = tier;
                    objectArray = objectArray8;
                    objectArray8[1] = properties;
                } else {
                    Object[] objectArray9 = new Object[4];
                    objectArray9[0] = tier;
                    objectArray9[1] = Float.valueOf(this.damageModifier);
                    objectArray9[2] = Float.valueOf(this.speedModifier);
                    objectArray = objectArray9;
                    objectArray9[3] = properties;
                }
                args = objectArray;
                break;
            }
            case SWORD: {
                Object[] objectArray;
                baseClassName = "TILItemSword";
                if (VERSION == CoreAPI.GameVersion.V12_2 || VERSION.isAtLeast(CoreAPI.GameVersion.V21_1)) {
                    Object[] objectArray10 = new Object[2];
                    objectArray10[0] = tier;
                    objectArray = objectArray10;
                    objectArray10[1] = properties;
                } else {
                    Object[] objectArray11 = new Object[4];
                    objectArray11[0] = tier;
                    objectArray11[1] = (int)this.damageModifier;
                    objectArray11[2] = Float.valueOf(this.speedModifier);
                    objectArray = objectArray11;
                    objectArray11[3] = properties;
                }
                args = objectArray;
                break;
            }
            default: {
                baseClassName = "TILCustomTool";
                HashSet blocks = new HashSet();
                this.effectiveBlocks.forEach(block -> blocks.add(block.unwrap()));
                args = new Object[]{tier, (int)this.damageModifier, Float.valueOf(this.speedModifier), blocks, properties};
                break;
            }
        }
        return (I)this.findAndInitializeForVersion(baseClassName, args);
    }

    @Override
    public ToolBuilderAPI setCreativeTab(CreativeTabAPI<?> tab) {
        this.creativeTab = tab;
        return this;
    }

    public ToolBuilderAPI setDamageModifier(float mod) {
        this.damageModifier = mod;
        return this;
    }

    public ToolBuilderAPI setEffectiveBlocks(Collection<BlockAPI<?>> blocks) {
        this.effectiveBlocks = Objects.nonNull(blocks) ? blocks : new HashSet();
        return this;
    }

    @Override
    public ToolBuilderAPI setItemType(ItemBuilderAPI.ItemType type) {
        this.itemType = type;
        return this;
    }

    @Override
    public ToolBuilderAPI setRegistryName(ResourceLocationAPI<?> name) {
        this.registryName = name;
        return this;
    }

    public ToolBuilderAPI setSpeedModifier(float speed) {
        this.speedModifier = speed;
        return this;
    }

    @Override
    public ToolBuilderAPI setStackSize(int size) {
        this.stackSize = Math.max(1, size);
        return this;
    }

    public ToolBuilderAPI setToolTier(String name) {
        return this.setToolTier(ItemHelper.getToolTier(name));
    }

    public ToolBuilderAPI setToolTier(ToolTierAPI<?> tier) {
        this.toolTier = tier;
        return this;
    }

    @Override
    public ToolBuilderAPI setTooltipFunction(BiFunction<ItemStackAPI<?>, WorldAPI<?>, Collection<TextAPI<?>>> descFunc) {
        this.descFunc = descFunc;
        return this;
    }

    @Override
    public ToolBuilderAPI setToolType(ItemBuilderAPI.ToolType type) {
        this.toolType = type;
        return this;
    }

    @Override
    public ToolBuilderAPI setUseFunc(Function<TILItemUseContext, ActionResult> func) {
        this.useFunc = func;
        return this;
    }
}

