/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.server.CommandHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.server.CommandSenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.MinecraftServerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.ServerHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import org.apache.logging.log4j.util.TriConsumer;

public abstract class CommandAPI {
    protected final CommandAPI parent;
    protected final String name;
    protected final ArgType type;
    protected final boolean executionNode;
    protected final Collection<CommandAPI> subCommands;
    protected String exceptionKey;
    protected Object[] exceptionArgs;

    public CommandAPI(String name, CommandAPI parent, ArgType type, boolean executionNode) {
        this.name = name;
        this.parent = parent;
        this.type = type;
        this.executionNode = executionNode;
        this.subCommands = new HashSet<CommandAPI>();
        if (Objects.nonNull(this.parent)) {
            this.parent.addSubCommand(this);
        }
    }

    @IndirectCallers
    public void addBasicSubCommand(String name, ArgType type, final TriConsumer<MinecraftServerAPI<?>, CommandSenderAPI<?>, String[]> executor) {
        this.addSubCommand(new CommandAPI(name, this, type, Objects.nonNull(executor)){

            @Override
            public void execute(MinecraftServerAPI<?> server, CommandSenderAPI<?> sender, String input, String remaining) {
                if (Objects.nonNull(executor)) {
                    executor.accept(server, sender, (Object)new String[]{input, remaining});
                }
            }

            @Override
            public List<String> getTabCompletions(MinecraftServerAPI<?> server, CommandSenderAPI<?> sender, String input, String remaining) {
                return Collections.emptyList();
            }

            @Override
            public void prepareExceptionInfo() {
            }
        });
    }

    @IndirectCallers
    public void addSubCommand(CommandAPI cmd) {
        this.subCommands.add(cmd);
    }

    protected void buildStack(List<CommandAPI> stack) {
        stack.add(this);
        if (Objects.nonNull(this.parent)) {
            this.parent.buildStack(stack);
        }
    }

    public void execute(Object unwrappedSender, String input, String remaining) throws Exception {
        this.execute(this.getServer(), this.getSender(unwrappedSender), input, remaining);
    }

    public abstract void execute(MinecraftServerAPI<?> var1, CommandSenderAPI<?> var2, String var3, String var4) throws Exception;

    protected String getErrorKey(String ... extras) {
        String[] keys = new String[extras.length + 1];
        keys[0] = "error";
        System.arraycopy(extras, 0, keys, 1, extras.length);
        return this.getMessageKey(keys);
    }

    protected String getMessageKey(String ... keys) {
        StringJoiner joiner = new StringJoiner(".");
        joiner.add("commands");
        for (CommandAPI node : this.getStackReverse()) {
            joiner.add(node.getName());
        }
        for (String key : keys) {
            joiner.add(key);
        }
        return joiner.toString();
    }

    public CommandAPI getRoot() {
        List<CommandAPI> stack = this.getStack();
        return stack.get(stack.size() - 1);
    }

    public String getRootName() {
        return this.getRoot().getName();
    }

    public CommandSenderAPI<?> getSender(Object sender) {
        return WrapperHelper.wrapCommandSender(sender);
    }

    public MinecraftServerAPI<?> getServer() {
        return ServerHelper.getAPI();
    }

    public List<CommandAPI> getStack() {
        ArrayList<CommandAPI> stack = new ArrayList<CommandAPI>();
        this.buildStack(stack);
        return stack;
    }

    public List<CommandAPI> getStackReverse() {
        List<CommandAPI> stack = this.getStack();
        Collections.reverse(stack);
        return stack;
    }

    public List<String> getTabCompletions(Object unwrappedSender, String input, String remaining) {
        return this.getTabCompletions(this.getServer(), this.getSender(unwrappedSender), input, remaining);
    }

    public abstract List<String> getTabCompletions(MinecraftServerAPI<?> var1, CommandSenderAPI<?> var2, String var3, String var4);

    protected String getUsageKey() {
        return this.getMessageKey("usage");
    }

    protected boolean hasParentInput(String input) {
        CommandAPI parent = this.getParent();
        if (Objects.isNull(parent) || parent == this.getRoot()) {
            return true;
        }
        String[] args = input.split(" ");
        List<CommandAPI> stack = this.getStackReverse();
        for (int i = args.length - 1; i >= 0; --i) {
            String arg;
            String string = arg = args[i].charAt(0) == '/' ? args[i].substring(1) : args[i];
            if (i < stack.size() && stack.get(i).isValidInput(arg)) continue;
            return false;
        }
        return true;
    }

    public boolean isValidInput(String input) {
        switch (this.getType()) {
            case BOOLEAN: {
                return Misc.equalsAny(input, "true", "false");
            }
            case BYTE: {
                return this.isValidNumber(input, Byte::parseByte);
            }
            case DOUBLE: {
                return this.isValidNumber(input, Double::parseDouble);
            }
            case FLOAT: {
                return this.isValidNumber(input, Float::parseFloat);
            }
            case INTEGER: {
                return this.isValidNumber(input, Integer::parseInt);
            }
            case LITERAL: {
                return this.getName().equals(input);
            }
            case ROOT: {
                return this.getRoot() == this;
            }
            case LONG: {
                return this.isValidNumber(input, Long::parseLong);
            }
            case SHORT: {
                return this.isValidNumber(input, Short::parseShort);
            }
            case STRING: {
                return this.isValidString(input);
            }
        }
        return true;
    }

    protected boolean isValidString(String input) {
        return true;
    }

    protected boolean isValidNumber(String input, Function<String, Number> func) {
        try {
            func.apply(input);
            return true;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    @IndirectCallers
    public <T> T parseArgAs(Object[] arg, Class<T> ignored) throws Exception {
        return this.type.parseArg(arg);
    }

    public abstract void prepareExceptionInfo();

    public <E> E unwrapEntity(CommandSenderAPI<?> sender) {
        EntityAPI<?, ?> entity = sender.getEntity();
        return Objects.nonNull(entity) ? (E)entity.getEntity() : null;
    }

    @Generated
    public CommandAPI getParent() {
        return this.parent;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ArgType getType() {
        return this.type;
    }

    @Generated
    public boolean isExecutionNode() {
        return this.executionNode;
    }

    @Generated
    public Collection<CommandAPI> getSubCommands() {
        return this.subCommands;
    }

    @Generated
    public String getExceptionKey() {
        return this.exceptionKey;
    }

    @Generated
    public Object[] getExceptionArgs() {
        return this.exceptionArgs;
    }

    public static enum ArgType {
        BOOLEAN(1, 1, obj -> Boolean.parseBoolean(obj[0].toString())),
        BLOCK_POS(3, 3, obj -> CommandHelper.parseBlockPos((EntityAPI)obj[0], obj[1].toString())),
        BYTE(1, 1, obj -> Byte.parseByte(obj[0].toString())),
        DOUBLE(1, 1, obj -> Double.parseDouble(obj[0].toString())),
        ENTITY(1, 1, obj -> {
            try {
                return CommandHelper.parseEntity((MinecraftServerAPI)obj[0], (CommandSenderAPI)obj[1], obj[2].toString());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }),
        FLOAT(1, 1, obj -> Boolean.parseBoolean(obj[0].toString())),
        INTEGER(1, 1, obj -> Boolean.parseBoolean(obj[0].toString())),
        LITERAL(1, 1, obj -> String.valueOf(obj[0])),
        LONG(1, 1, obj -> Boolean.parseBoolean(obj[0].toString())),
        PLAYER(1, 1, obj -> {
            try {
                return CommandHelper.parsePlayer((MinecraftServerAPI)obj[0], (CommandSenderAPI)obj[1], obj[2].toString());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }),
        POS(3, 3, obj -> CommandHelper.parsePos((EntityAPI)obj[0], obj[1].toString())),
        ROOT(1, 1, obj -> obj[0].toString()),
        SHORT(1, 1, obj -> Boolean.parseBoolean(obj[0].toString())),
        STRING(1, 1, obj -> String.valueOf(obj[0]));

        private final int minLength;
        private final int maxLength;
        private final Function<Object[], ?> parser;

        private <T> ArgType(int minLength, int maxLength, Function<Object[], T> parser) {
            this.minLength = minLength;
            this.maxLength = maxLength;
            this.parser = parser;
        }

        public <T> T parseArg(Object[] objs) throws Exception {
            return (T)this.parser.apply(objs);
        }
    }
}

