/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.shapes;

import java.util.function.Supplier;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.FuzzBall;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Shape2D;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.util.RandomHelper;

public interface Shape {
    public boolean checkToleranceBounds(Vector3 var1, Box var2);

    default public Shape copy() {
        return this.getScaled(1.0, 1.0, 1.0);
    }

    public Shape2D[] getAs2DArray();

    default public Vector3 getBounded(Vector3 pos) {
        return new Vector3(this.getBoundedX(pos), this.getBoundedY(pos), this.getBoundedZ(pos));
    }

    default public Vector3 getBounded(double x, double y, double z) {
        return new Vector3(this.getBoundedX(x, y, z), this.getBoundedY(x, y, z), this.getBoundedZ(x, y, z));
    }

    default public double getBoundedX(Vector3 pos) {
        return this.getBoundedX(pos.dX(), pos.dY(), pos.dZ());
    }

    public double getBoundedX(double var1, double var3, double var5);

    default public Vector2 getBoundedXY(Vector2 xy) {
        return new Vector2(this.getBoundedX(xy.dX(), xy.dY(), 0.0), this.getBoundedY(xy.dX(), xy.dY(), 0.0));
    }

    default public Vector2 getBoundedXY(double x, double y) {
        return new Vector2(this.getBoundedX(x, y, 0.0), this.getBoundedY(x, y, 0.0));
    }

    default public Vector2 getBoundedXZ(Vector2 xz) {
        return new Vector2(this.getBoundedX(xz.dX(), 0.0, xz.dY()), this.getBoundedZ(xz.dX(), 0.0, xz.dY()));
    }

    default public Vector2 getBoundedXZ(double x, double z) {
        return new Vector2(this.getBoundedX(x, 0.0, z), this.getBoundedZ(x, 0.0, z));
    }

    default public double getBoundedY(Vector3 pos) {
        return this.getBoundedY(pos.dX(), pos.dY(), pos.dZ());
    }

    public double getBoundedY(double var1, double var3, double var5);

    default public Vector2 getBoundedYZ(Vector2 yz) {
        return new Vector2(this.getBoundedY(0.0, yz.dX(), yz.dY()), this.getBoundedZ(0.0, yz.dX(), yz.dY()));
    }

    default public Vector2 getBoundedYZ(double y, double z) {
        return new Vector2(this.getBoundedY(0.0, y, z), this.getBoundedZ(0.0, y, z));
    }

    default public double getBoundedZ(Vector3 pos) {
        return this.getBoundedZ(pos.dX(), pos.dY(), pos.dZ());
    }

    public double getBoundedZ(double var1, double var3, double var5);

    default public Vector3 getCenter(Vector3 center) {
        return center;
    }

    public double getDepth();

    public double getHeight();

    default public Shape getScaled(double scale) {
        return this.getScaled(scale, scale, scale);
    }

    default public Shape getScaled(Vector2 scale) {
        return this.getScaled(scale.dX(), scale.dY(), scale.dX());
    }

    default public Shape getScaled(double scaleH, double scaleV) {
        return this.getScaled(scaleH, scaleV, scaleH);
    }

    default public Shape getScaled(Vector3 scale) {
        return this.getScaled(scale.dX(), scale.dY(), scale.dZ());
    }

    public Shape getScaled(double var1, double var3, double var5);

    public double getWidth();

    public boolean isInside(double var1, double var3, double var5);

    default public boolean isInside(Vector3 pos) {
        return this.isInside(pos.dX(), pos.dY(), pos.dZ());
    }

    default public FuzzBall makeFuzzBall(int minCount, int maxCount, float minWidth, float maxWidth) {
        return this.makeFuzzBall(minCount, maxCount, minWidth, maxWidth, ColorHelper.BLACK, 0.75f, 1.0f);
    }

    default public FuzzBall makeFuzzBall(int minCount, int maxCount, float minWidth, float maxWidth, ColorCache baseColor, float minAlpha, float maxAlpha) {
        return this.makeFuzzBall(minCount, maxCount, minWidth, maxWidth, baseColor, RandomHelper.randomFloat(0.75f, 1.0f));
    }

    default public FuzzBall makeFuzzBall(int minCount, int maxCount, float minWidth, float maxWidth, ColorCache baseColor, float alpha) {
        return this.makeFuzzBall(minCount, maxCount, minWidth, maxWidth, () -> baseColor.withAlpha(alpha));
    }

    public FuzzBall makeFuzzBall(int var1, int var2, float var3, float var4, Supplier<ColorCache> var5);

    public Vector2 random2D();

    public Vector3 random3D();
}

