/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.shapes;

import java.util.function.Supplier;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.FuzzBall;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Shape;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorSuppliers;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import mods.thecomputerizer.theimpossiblelibrary.api.util.RandomHelper;

public abstract class Shape2D
implements Shape {
    private static final Vector2 ZERO_2D = VectorHelper.zero2D();
    private static final Vector3 ZERO_3D = VectorHelper.zero3D();
    protected final Vector3 direction;

    protected Shape2D(Vector3 direction) {
        this.direction = direction;
    }

    @Override
    public Shape2D copy() {
        return this.getScaled(1.0, 1.0);
    }

    @Override
    public Shape2D[] getAs2DArray() {
        return new Shape2D[]{this};
    }

    @Override
    public double getBoundedZ(double x, double y, double z) {
        return z;
    }

    public Vector3 getDirectionAngles() {
        double angleX = new Vector2(0.0, 1.0).angle(new Vector2(this.direction.dZ(), this.direction.dY()));
        double angleY = new Vector2(0.0, 1.0).angle(new Vector2(this.direction.dX(), this.direction.dZ()));
        double angleZ = new Vector2(0.0, 1.0).angle(new Vector2(this.direction.dX(), this.direction.dY()));
        return new Vector3(angleX, angleY, angleZ);
    }

    public VectorSuppliers.VectorSupplier2D getOutlineSupplier(Box bounds) {
        return this.getVectorSupplier(bounds);
    }

    public Vector2 getRelativeCoordinate(double x, double y, double z) {
        return this.getRelativeCoordinate(new Vector3(x, y, z));
    }

    public Vector2 getRelativeCoordinate(Vector3 world) {
        int inf = 0;
        for (double d : world.dArrray()) {
            if (d == Double.POSITIVE_INFINITY && inf == 0) {
                inf = 1;
                continue;
            }
            if (d != Double.NEGATIVE_INFINITY) continue;
            inf = inf == 1 ? 2 : 1;
        }
        if (inf > 0) {
            return inf == 1 ? VectorHelper.inf2D() : VectorHelper.negInf2D();
        }
        Vector3 angles = this.getDirectionAngles();
        double distance = world.distance(ZERO_3D) / this.direction.distance(ZERO_3D);
        Vector3 rotated = world.rotateX(-angles.dX(), new Vector3()).rotateY(-angles.dY()).rotateZ(-angles.dZ());
        return new Vector2(rotated.dX(), rotated.dY()).mulScalar(distance);
    }

    @Override
    public Shape2D getScaled(double scale) {
        return this.getScaled(scale, scale);
    }

    @Override
    public Shape2D getScaled(Vector2 scale) {
        return this.getScaled(scale.dX(), scale.dY());
    }

    @Override
    public Shape2D getScaled(double scaleX, double scaleY) {
        return this.getScaled(scaleX, scaleY, scaleX);
    }

    @Override
    public Shape2D getScaled(Vector3 scale) {
        return this.getScaled(scale.dX(), scale.dY());
    }

    @Override
    public abstract Shape2D getScaled(double var1, double var3, double var5);

    public abstract VectorSuppliers.VectorSupplier2D getVectorSupplier(Box var1);

    public Vector3 getWorldCoordinate(double x, double y) {
        return this.getWorldCoordinate(new Vector2(x, y));
    }

    public Vector3 getWorldCoordinate(Vector2 relative) {
        if (Misc.equalsAny(Double.POSITIVE_INFINITY, relative.dX(), relative.dY()) || Misc.equalsAny(Double.NEGATIVE_INFINITY, relative.dX(), relative.dY())) {
            return Misc.equalsAny(Double.NEGATIVE_INFINITY, relative.dX(), relative.dY()) ? VectorHelper.negInf3D() : VectorHelper.inf3D();
        }
        Vector3 angles = this.getDirectionAngles();
        double distance = relative.distance(ZERO_2D) * this.direction.distance(ZERO_3D);
        return new Vector3(relative, (Number)0.0).rotateX(angles.dX()).rotateY(angles.dY()).rotateZ(angles.dZ()).mulScalar(distance);
    }

    @Override
    public boolean isInside(double x, double y, double z) {
        return this.isInside(new Vector3(x, y, z));
    }

    @Override
    public boolean isInside(Vector3 pos) {
        return this.isInsideRelative(new Vector2(pos.dX(), pos.dY()));
    }

    public abstract boolean isInsideRelative(Vector2 var1);

    @Override
    public FuzzBall makeFuzzBall(int minCount, int maxCount, float minWidth, float maxWidth, Supplier<ColorCache> colorGenerator) {
        return new FuzzBall(() -> ScreenHelper.randomPointSupplier2D(this::random2D, minCount, maxCount), null, () -> Float.valueOf(RandomHelper.randomFloat(minWidth, maxWidth)), colorGenerator);
    }

    public boolean sameDirection(Shape2D other) {
        return Misc.equalsNullable(this.direction, other.direction);
    }

    @Generated
    public Vector3 getDirection() {
        return this.direction;
    }
}

