/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.shapes;

import java.util.Objects;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Plane;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorHelper;

public class Square
extends Plane {
    protected double sideLength;
    protected double heightRatio;

    public Square(Vector3 direction, double length, double heightRatio) {
        super(direction, VectorHelper.zero2D(), VectorHelper.zero2D());
        this.setSideLength(length, heightRatio);
    }

    @Override
    public Square copy() {
        return this.getScaled(1.0);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (Objects.isNull(other)) {
            return false;
        }
        if (other.getClass() == Square.class) {
            Square square = (Square)other;
            return this.sameDirection(square) && this.sideLength == square.sideLength && this.heightRatio == square.heightRatio;
        }
        return false;
    }

    @Override
    public Square getScaled(double scale) {
        if (scale <= 0.0) {
            scale = 1.0;
        }
        return new Square(new Vector3(this.direction), this.sideLength * scale, this.heightRatio);
    }

    @Override
    public Square getScaled(Vector2 scale) {
        return this.getScaled(scale.dX(), scale.dY());
    }

    @Override
    public Square getScaled(double scaleX, double scaleY) {
        return this.getScaled(scaleX == 1.0 ? scaleY : scaleX);
    }

    @Override
    public Square getScaled(Vector3 scale) {
        return this.getScaled(scale.dX(), scale.dY(), scale.dZ());
    }

    @Override
    public Square getScaled(double scaleX, double scaleY, double scaleZ) {
        return this.getScaled(scaleX == 1.0 ? (scaleY == 1.0 ? scaleZ : scaleY) : scaleX);
    }

    @Override
    public void setRelativeMax(Vector2 max) {
    }

    @Override
    public void setRelativeMin(Vector2 min) {
    }

    public void setSideLength(double length, double heightRatio) {
        this.sideLength = length;
        this.heightRatio = heightRatio;
        double halfLenX = Math.abs(length * Math.min(heightRatio, 1.0)) / 2.0;
        double halfLenY = Math.abs(length * Math.min(1.0 / heightRatio, 1.0)) / 2.0;
        this.relativeMax = new Vector2(halfLenX, halfLenY);
        this.relativeMin = new Vector2(-halfLenX, -halfLenY);
        this.worldMin = this.getWorldCoordinate(this.relativeMin);
        this.worldMax = this.getWorldCoordinate(this.relativeMax);
        this.calculateSize();
    }

    @Generated
    public double getSideLength() {
        return this.sideLength;
    }

    @Generated
    public double getHeightRatio() {
        return this.heightRatio;
    }
}

