/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.wrappers;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreStateAccessor;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import org.jetbrains.annotations.Nullable;

public interface Wrapped<W>
extends CoreStateAccessor {
    public W getWrapped();

    @Nullable
    default public <V> V getIfNotNull(Function<W, V> getter) {
        W wrapped = this.getWrapped();
        return Objects.nonNull(wrapped) ? (V)getter.apply(wrapped) : null;
    }

    default public <V> V getIfNotNullOrDefault(Function<W, V> getter, V defaultValue) {
        Supplier<Object> defaultValueSupplier = () -> defaultValue;
        return (V)this.getIfNotNullOrDefault(getter, defaultValueSupplier);
    }

    default public <V> V getIfNotNullOrDefault(Function<W, V> getter, Supplier<V> defaultValueSupplier) {
        W wrapped = this.getWrapped();
        return Objects.nonNull(wrapped) ? getter.apply(wrapped) : defaultValueSupplier.get();
    }

    default public Class<W> getWrappedClass() {
        return (Class)GenericUtils.cast(this.getWrapped().getClass());
    }

    @IndirectCallers
    default public boolean isNull() {
        return Objects.isNull(this.getWrapped());
    }

    @IndirectCallers
    default public boolean isNullGetter(Function<W, ?> getter) {
        W wrapped = this.getWrapped();
        return Objects.isNull(wrapped) || Objects.isNull(getter.apply(wrapped));
    }

    @IndirectCallers
    default public boolean notNull() {
        return Objects.nonNull(this.getWrapped());
    }

    @IndirectCallers
    default public boolean notNullGetter(Function<W, ?> getter) {
        W wrapped = this.getWrapped();
        return Objects.nonNull(wrapped) && Objects.nonNull(getter.apply(wrapped));
    }

    @IndirectCallers
    @Nullable
    default public <V> V supplyIfNull(Function<W, V> getter, Supplier<V> ifNullSupplier) {
        V value = this.getIfNotNull(getter);
        return Objects.nonNull(value) ? value : ifNullSupplier.get();
    }

    default public <U> U unwrap() {
        return (U)GenericUtils.cast(this.getWrapped());
    }

    @Nullable
    default public <V, R> R wrapIfNotNull(Function<W, V> getter, Function<V, R> wrapper) {
        V value = this.getIfNotNull(getter);
        return Objects.nonNull(value) ? (R)wrapper.apply(value) : null;
    }

    @IndirectCallers
    default public <V, R> R wrapIfNotNullOrDefault(Function<W, V> getter, Function<V, R> wrapper, R defaultValue) {
        Supplier<Object> defaultValueSupplier = () -> defaultValue;
        return (R)this.wrapIfNotNullOrDefault(getter, wrapper, defaultValueSupplier);
    }

    @IndirectCallers
    default public <V, R> R wrapIfNotNullOrDefault(Function<W, V> getter, Function<V, R> wrapper, Supplier<R> defaultValueSupplier) {
        V value = this.getIfNotNull(getter);
        return Objects.nonNull(value) ? wrapper.apply(value) : defaultValueSupplier.get();
    }
}

