/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.fabric.common.event;

import java.lang.reflect.InvocationHandler;
import java.util.Objects;
import java.util.function.Function;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.EventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import net.fabricmc.fabric.api.event.Event;

public interface CommonFabricEvent {
    public static <T> void register(EventWrapper<?> wrapper, Event<T> event, EventWrapper.EventType<?> type) {
        if (Objects.isNull(event)) {
            return;
        }
        Object invoker = event.invoker();
        Class eventType = (Class)GenericUtils.cast(invoker.getClass().getInterfaces()[0]);
        TILRef.logInfo("Event invoker class is {}", eventType);
        event.register(ClassHelper.newProxy(eventType, ((CommonFabricEvent)((Object)wrapper)).createEventProxy(type)));
    }

    @IndirectCallers
    default public void cancel() {
        EventWrapper wrapper = (EventWrapper)((Object)this);
        if (wrapper.isCancelable()) {
            wrapper.setCanceled(true);
        }
    }

    default public InvocationHandler createEventProxy(EventWrapper.EventType<?> type) {
        return (proxy, method, args) -> {
            if (method.getReturnType() == Boolean.class) {
                return this.registerReturn(type, args);
            }
            this.registerInvoke(type, args);
            return null;
        };
    }

    public Event<?> getEventInstance();

    default public void register() {
        EventWrapper wrapper = (EventWrapper)((Object)this);
        CommonFabricEvent.register(wrapper, this.getEventInstance(), wrapper.getType());
    }

    default public void registerInvoke(EventWrapper.EventType<?> type, Object ... args) {
        type.invoke(args);
    }

    default public boolean registerReturn(EventWrapper.EventType<?> type, Object ... args) {
        type.invoke(args);
        EventWrapper wrapper = (EventWrapper)((Object)this);
        return !wrapper.isCancelable() || wrapper.isCancelable() && !wrapper.isCanceled();
    }

    default public <T> Function<Object[], T> wrapArrayGetter(int index, Class<T> clazz) {
        return args -> {
            Object arg = ((Object[])args).length > index ? args[index] : null;
            return Objects.nonNull(arg) ? clazz.cast(arg) : null;
        };
    }

    default public <T> Function<Object[], T> wrapArrayGetter(int index) {
        return args -> GenericUtils.cast(((Object[])args).length > index ? args[index] : null);
    }
}

