/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.fabric.core.asm;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import mods.thecomputerizer.theimpossiblelibrary.api.common.CommonEntryPoint;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ModWriter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.TypeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import mods.thecomputerizer.theimpossiblelibrary.fabric.core.FabricHelper;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.api.ModInitializer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ModWriterFabric
extends ModWriter {
    protected static final String FABRIC_HELPER_INTERNAL = Type.getType(FabricHelper.class).getInternalName();
    protected static final String FINALIZER_DESC = TypeHelper.voidMethod(CommonEntryPoint.class).getDescriptor();
    final String clientInit;
    final String commonInit;
    final String serverInit;

    public ModWriterFabric(CoreAPI core, MultiVersionModInfo info) {
        this(core, info, ClientModInitializer.class, ModInitializer.class, DedicatedServerModInitializer.class);
    }

    protected ModWriterFabric(CoreAPI core, MultiVersionModInfo info, Class<?> client, Class<?> common, Class<?> server) {
        this(core, info, Type.getInternalName(client), Type.getInternalName(common), Type.getInternalName(server));
    }

    protected ModWriterFabric(CoreAPI core, MultiVersionModInfo info, String client, String common, String server) {
        super(core, info);
        this.clientInit = client;
        this.commonInit = common;
        this.serverInit = server;
    }

    protected void addEntryHooks(MethodVisitor visitor, boolean isStatic, String method) {
        this.addEntryHooks(visitor, isStatic, method, false);
    }

    protected Map.Entry<ClassWriter, Type> addInnerEntryPoint(ClassVisitor outerClass, boolean client) {
        if (client ? !this.isClient() : !this.isServer()) {
            return null;
        }
        return this.addInnerClass(outerClass, "Loader" + (client ? "Client" : "Server"), inner -> {
            this.writeMethod((ClassVisitor)inner, cv -> ASMHelper.getConstructor(cv, 1, new Type[0]), constructor -> ASMHelper.addSuperConstructor(constructor, ASMRef.OBJECT_TYPE_NAME, ASMRef.EMPTY_METHOD_DESC, false));
            String init = client ? "onInitializeClient" : "onInitializeServer";
            this.writeMethod((ClassVisitor)inner, cv -> ASMHelper.getMethod(cv, 1, init, new Type[0]), method -> this.addEntryHooks((MethodVisitor)method, true, init));
        }, client, !client);
    }

    @Override
    protected Type getEventMethod(String className) {
        return ASMRef.EMPTY_METHOD;
    }

    @Override
    protected List<String[]> entryPointMappings() {
        return Arrays.asList({"<init>", "", "onConstructed", "onPreRegistration"}, {"onInitialize", "", "onCommonSetup"}, {"onInitializeClient", "", "checkClientSetup", "onInterModEnqueue"}, {"onInitializeServer", "", "checkDedicatedServerSetup", "onInterModEnqueue"});
    }

    @Override
    protected String[] modInterfaces(boolean client, boolean server) {
        return new String[]{client && server ? this.commonInit : (client ? this.clientInit : this.serverInit)};
    }

    @Override
    protected void writeMod(ClassWriter writer, List<Map.Entry<String, byte[]>> classBytes) {
        super.writeMod(writer, classBytes);
        String init = "onInitialize";
        this.writeMethod((ClassVisitor)writer, cv -> ASMHelper.getMethod(cv, 1, "onInitialize", new Type[0]), method -> {
            this.addEntryHooks((MethodVisitor)method, false, "onInitialize");
            this.entryPointGetter((MethodVisitor)method);
            method.visitMethodInsn(184, FABRIC_HELPER_INTERNAL, "finalizeEntrypoints", FINALIZER_DESC, false);
        });
        for (boolean b : BOOLEAN_VALUES) {
            this.writeInnerClass(this.addInnerEntryPoint((ClassVisitor)writer, b), classBytes);
        }
    }
}

