/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core;

import cpw.mods.modlauncher.Launcher;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleLayerAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ResolvedModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.bootstrap.TILLauncherForge;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.ArgumentHandlerAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.ForgeModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.ModFileInfoAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.ModuleClassLoaderAccess;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ForgeCoreLoader {
    private static final String API_PKG = "mods.thecomputerizer.theimpossiblelibrary.api";
    private static final String COREAPI_CLASS = "mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI";
    private static final String FORGE_PKG = "mods.thecomputerizer.theimpossiblelibrary.forge";
    private static final String FORGE_CORE_PKG = "mods.thecomputerizer.theimpossiblelibrary.forge.core";
    private static final Logger LOGGER = LogManager.getLogger((String)"TIL ForgeCoreLoader");
    public static final boolean SECURE_CLASSLOADER_FORMAT = ForgeCoreLoader.newModuleClassLoaderFormat();

    private static boolean newModuleClassLoaderFormat() {
        if (ForgeCoreLoader.isJava8()) {
            return false;
        }
        String newFormatClassName = "net.minecraftforge.securemodules.SecureModuleClassLoader";
        try {
            Class<?> ignored = Class.forName("net.minecraftforge.securemodules.SecureModuleClassLoader");
            return true;
        }
        catch (Throwable ignored) {
            LOGGER.debug("Assuming 1.18.2-1.20.1 ModuleClassLoader format (missing {})", (Object)"net.minecraftforge.securemodules.SecureModuleClassLoader");
            return false;
        }
    }

    public static void addLibraryToGameLayer(String pkg, String gameLayerName) {
        ModuleClassLoaderAccess bootLoader = ForgeCoreLoader.bootLoaderAccess();
        ModuleClassLoaderAccess gameLoader = ForgeModuleAccess.getModuleClassLoader("GAME");
        ResolvedModuleAccess module = bootLoader.getResolvedModule(pkg);
        Set<String> packages = module.packages(false);
        Object descriptor = gameLoader.getModuleDescriptorDirect(gameLayerName);
        ForgeModuleAccess.moveModule(bootLoader, gameLoader, module, true);
        TILLauncherForge.checkHacksInit(false, gameLoader.unwrap());
        ForgeCoreLoader.addPackagesToDescriptor(module, packages, descriptor);
    }

    static void addPackagesToDescriptor(Object source, Set<String> packages, @Nullable Object descriptor) {
        if (Objects.isNull(descriptor)) {
            LOGGER.error("Cannot add packages from {} to null game layer module descriptor", source);
            return;
        }
        String target = (String)Hacks.invoke(descriptor, "name", new Object[0]);
        if (packages.isEmpty()) {
            LOGGER.warn("Tried adding 0 packages from {} to game layer module {}", source, (Object)target);
            return;
        }
        LOGGER.info("Adding {} packages from {} to game layer module {}", (Object)packages.size(), source, (Object)target);
        Hacks.setFieldDirect(descriptor, "packages", packages);
    }

    public static ClassLoader bootLoader() {
        ClassLoader loader = Launcher.class.getClassLoader();
        return Objects.nonNull(loader) ? loader : ClassLoader.getSystemClassLoader();
    }

    static ModuleClassLoaderAccess bootLoaderAccess() {
        return ForgeModuleAccess.getModuleClassLoader(ForgeCoreLoader.bootLoader(), "BOOT");
    }

    @Nullable
    public static Object getBootLoadedCoreAPI() {
        return ForgeCoreLoader.getCoreAPIReflectively(ForgeCoreLoader.bootLoader());
    }

    static Object getCoreAPIReflectively(ClassLoader loader) {
        if (loader == ForgeCoreLoader.class.getClassLoader()) {
            return CoreAPI.getInstanceDirect();
        }
        try {
            return Hacks.CallStrategy.STATIC_DIRECT.get(Hacks.findClass(COREAPI_CLASS, loader), "INSTANCE");
        }
        catch (Throwable t) {
            LOGGER.debug("Failed to get CoreAPI instance on {}", (Object)loader);
            return null;
        }
    }

    public static <E extends Enum<E>> E getEnum(String className, ClassLoader loader, String name) {
        Class<?> foundClass = Hacks.findClassInHeirarchy(className, loader);
        return Objects.nonNull(foundClass) ? (E)ForgeCoreLoader.getEnum(foundClass, name) : null;
    }

    static <E extends Enum<E>> E getEnum(Class<?> enumClass, String name) {
        if (Objects.isNull(name)) {
            LOGGER.error("Tried to get value of enum {} from null name!", enumClass);
            return null;
        }
        try {
            return (E)Enum.valueOf(enumClass, name);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to get enum {} of type {}", (Object)name, enumClass, (Object)t);
            return null;
        }
    }

    public static Object getLogger() {
        return LOGGER;
    }

    static <T> int getMatchingArrayIndex(T[] array, T value) {
        if (Objects.isNull(array) || array.length == 0) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!value.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    static String getVersionFromForgeVersion(String forgeVersion) {
        String ignore = "forge-";
        String actualVersion = forgeVersion.startsWith(ignore) ? forgeVersion.substring(ignore.length()) : forgeVersion;
        String version = "1.21.1";
        if (actualVersion.startsWith("49.")) {
            version = "1.20.4";
        } else if (actualVersion.startsWith("50.")) {
            version = "1.20.6";
        }
        LOGGER.info("Guessed mc version {} from forge version {}", (Object)version, (Object)forgeVersion);
        return version;
    }

    static String getVersionStr() {
        ArgumentHandlerAccess handler = ForgeModuleAccess.getLauncher().argumentHandler();
        if (Objects.isNull(handler)) {
            return null;
        }
        Object[] rawArgs = handler.getArgs();
        if (Objects.isNull(rawArgs)) {
            LOGGER.error("Failed to find version using handler {}", handler.access());
            return null;
        }
        int versionIndex = ForgeCoreLoader.getMatchingArrayIndex(rawArgs, "--fml.mcVersion") + 1;
        if (versionIndex > 0) {
            LOGGER.debug("Found fml.mcVersion arg at index {} -> {}", (Object)versionIndex, (Object)rawArgs[versionIndex]);
            return rawArgs[versionIndex];
        }
        LOGGER.debug("--fml.mcVersion was not found so the mc version will be guessed from --version instead");
        versionIndex = ForgeCoreLoader.getMatchingArrayIndex(rawArgs, "--version") + 1;
        if (versionIndex > 0) {
            LOGGER.debug("Found forge version arg at index {}", (Object)versionIndex);
            return ForgeCoreLoader.getVersionFromForgeVersion((String)rawArgs[versionIndex]);
        }
        LOGGER.error("Failed to find fml.mcVersion or version flags from args {}", (Object)Arrays.toString(rawArgs));
        int javaVersion = 17;
        String mcVersion = "1.20.1";
        if (ForgeCoreLoader.isJava8()) {
            javaVersion = 8;
            mcVersion = "1.16.5";
        } else if (ForgeCoreLoader.isJava21()) {
            javaVersion = 21;
            mcVersion = "1.21.1";
        }
        LOGGER.warn("Guessing the current Minecraft version is {} since this is Java {}", (Object)mcVersion, (Object)javaVersion);
        return mcVersion;
    }

    @IndirectCallers
    @Nullable
    public static Object initCoreAPI() {
        return ForgeCoreLoader.initCoreAPI(ForgeCoreLoader.bootLoader());
    }

    @Nullable
    public static Object initCoreAPI(ClassLoader loader) {
        Hacks.checkBurningWaveInit();
        LOGGER.debug("Starting CoreAPI init");
        Object bootInstance = ForgeCoreLoader.getBootLoadedCoreAPI();
        if (Objects.nonNull(bootInstance)) {
            LOGGER.debug("Returning existing CoreAPI instance found in the BOOT layer");
            return bootInstance;
        }
        String version = ForgeCoreLoader.getVersionStr();
        Class<?> coreClass = ForgeCoreLoader.loadAPI(version);
        try {
            return coreClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            LOGGER.fatal("Caught reflection exception while trying to get CoreAPI instance as {}", coreClass, (Object)ex);
        }
        catch (Exception ex) {
            LOGGER.fatal("Unknown error while trying to get CoreAPI instance as {}", coreClass, (Object)ex);
        }
        LOGGER.fatal("Failed to initialize CoreAPI [Forge-{}] using {}", (Object)version, (Object)loader);
        return null;
    }

    public static boolean isJava8() {
        return System.getProperty("java.version").startsWith("1.");
    }

    public static boolean isJava21() {
        return System.getProperty("java.version").startsWith("21");
    }

    public static ClassLoader layerClassLoader(String layerName) {
        return ForgeModuleAccess.getModuleClassLoader(layerName).unwrap();
    }

    static Class<?> loadAPI(String version) {
        ClassLoader loader = ForgeCoreLoader.bootLoader();
        String className = ForgeCoreLoader.versionClassName("core.TILCoreForge", version);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, loader);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to load class {} for {}", (Object)className, (Object)loader, (Object)ex);
        }
        if (Objects.isNull(clazz)) {
            throw new RuntimeException("Failed to load CoreAPI instance [Forge-" + version + "]");
        }
        if (ForgeCoreLoader.isJava8()) {
            String forgeModLoading = "mods.thecomputerizer.theimpossiblelibrary.forge.core.loader.ForgeModLoading";
            try {
                Class.forName(forgeModLoading, true, loader);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to load class {} for {}", (Object)forgeModLoading, (Object)loader, (Object)ex);
            }
        }
        LOGGER.debug("Successfully loaded CoreAPI instance {}", clazz);
        return clazz;
    }

    public static void nukeAndFinalizeJava8(Set<Class<?>> getSourcesFrom, ClassLoader target, boolean first) {
        if (getSourcesFrom.isEmpty()) {
            LOGGER.error("No classes to get sources from!");
            return;
        }
        HashSet<String> sources = new HashSet<String>();
        for (Class<?> from : getSourcesFrom) {
            ClassHelper.addSource(sources, from);
        }
        CoreAPI core = CoreAPI.getInstance();
        if (first) {
            core.addSources(sources);
        }
        LOGGER.info("Adding {} sources to target loader {}", (Object)sources.size(), (Object)target);
        sources.forEach(source -> {
            LOGGER.info("Adding source {}", source);
            core.addURLToClassLoader(target, (String)source);
        });
    }

    @IndirectCallers
    public static void verifyModule(String className, IModInfo info, Object moduleLayer) {
        ModuleLayerAccess layerAccess;
        Optional<Object> optionalModule;
        LOGGER.info("Verifying that {} is valid for {} and can be found in {}", (Object)className, (Object)info, moduleLayer);
        String modid = info.getModId();
        ModFileInfoAccess fileInfo = ForgeModuleAccess.getModFileInfo(info.getOwningFile());
        String moduleName = fileInfo.moduleName();
        if (!modid.equals(moduleName)) {
            LOGGER.error("Mod id {} does not equal module name {}!", (Object)modid, (Object)moduleName);
        }
        if (!(optionalModule = (layerAccess = ForgeModuleAccess.getModuleLayer(moduleLayer)).findModule(moduleName)).isPresent()) {
            layerAccess.findAndAddModule(moduleLayer, moduleName, modid);
            optionalModule = layerAccess.findModule(moduleName);
        }
        if (optionalModule.isPresent()) {
            ForgeModuleAccess.getModule(optionalModule.get()).addClassIfMissing(className, layerAccess);
        } else {
            LOGGER.error("Module {} is not present in the target layer!", (Object)moduleName);
        }
        LOGGER.info("Finished verifying {}", (Object)className);
    }

    static String versionClassName(String name, String version) {
        return ForgeCoreLoader.versionPackage(version) + "." + ForgeCoreLoader.versionQuantify(name, version);
    }

    static String versionPackage(String version) {
        String[] split = version.split("\\.");
        if (split.length < 3) {
            throw new RuntimeException("Can't parse package for unknown version " + version);
        }
        return "mods.thecomputerizer.theimpossiblelibrary.forge.v" + split[1] + ".m" + split[2];
    }

    static String versionQuantify(String name, String version) {
        return name + version.replace('.', '_');
    }
}

