/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core.bootstrap;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import org.apache.logging.log4j.Logger;

public class TILBootJar {
    static final String MODULE_DATA_PROVIDER = "cpw.mods.jarhandling.SecureJar$ModuleDataProvider";
    final Object providerProxy;

    static Optional<URI> findFile(FileSystem ufs, Object name) {
        Path path = ufs.getPath((String)name, new String[0]);
        Path root = (Path)Hacks.invoke(ufs, "getRoot", new Object[0]);
        if (Objects.isNull(root)) {
            return Optional.empty();
        }
        return Optional.of(root.resolve(path)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toUri);
    }

    @IndirectCallers
    static void updateReference(Logger logger, Object reference, URI uri) {
        Object provider = new TILBootJar(Hacks.getFieldDirect((Object)reference, (String)"jar"), (URI)uri).providerProxy;
        if (Objects.nonNull(provider)) {
            Hacks.setFieldDirect(reference, "jar", provider);
            logger.info("Updated ModuleDataProvider for JarModuleReference");
        } else {
            logger.error("Failed to create proxy for {}", (Object)MODULE_DATA_PROVIDER);
        }
    }

    private TILBootJar(Object provider, URI uri) {
        this.providerProxy = this.createProxy(this.getClass().getClassLoader(), provider, uri);
    }

    Object createProxy(ClassLoader loader, Object provider, URI uri) {
        FileSystem ufs = Paths.get(uri).getFileSystem();
        return ClassHelper.newGenericProxy(loader, MODULE_DATA_PROVIDER, (methodName, args) -> {
            switch (methodName) {
                case "descriptor": {
                    return Hacks.invoke(provider, "descriptor", new Object[0]);
                }
                case "findFile": {
                    return TILBootJar.findFile(ufs, args[0]);
                }
                case "getManifest": {
                    return Hacks.invoke(provider, "getManifest", new Object[0]);
                }
                case "name": {
                    return Hacks.invoke(provider, "name", new Object[0]);
                }
                case "open": {
                    return TILBootJar.findFile(ufs, args[0]).map(Paths::get).map(LamdbaExceptionUtils.rethrowFunction(x$0 -> Files.newInputStream(x$0, new OpenOption[0])));
                }
                case "uri": {
                    return uri;
                }
                case "verifyAndGetSigners": {
                    return Hacks.invoke(provider, "verifyAndGetSigners", args[0], args[1]);
                }
            }
            return null;
        });
    }
}

