/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core.loader;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.TypeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionLoaderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModCandidate;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModData;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModFinder;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.io.FileHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.ForgeCoreLoader;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.loader.TILBetterModScan;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.loader.TILLoaderJar;
import net.minecraftforge.fml.loading.ModDirTransformerDiscoverer;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModFileParser;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import net.minecraftforge.forgespi.locating.ModFileFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ForgeModLoading {
    static final Logger LOGGER = LogManager.getLogger((String)"Forge Mod Loading");
    static final BiConsumer<TILBetterModScan, Object> AFTER_WRITING_MODS = (scan, language) -> {
        LOGGER.debug("Injecting scan data into the language loader");
        Consumer visitor = (Consumer)Hacks.invokeDirect(language, "getFileVisitor", new Object[0]);
        if (Objects.nonNull(visitor)) {
            visitor.accept(scan);
        }
    };
    static final Map<MultiVersionModCandidate, ModFile> CANDIDATE_MAP = new HashMap<MultiVersionModCandidate, ModFile>();
    static final Map<Object, Map<MultiVersionModInfo, MultiVersionModData>> FILE_INFO_MAP = new HashMap<Object, Map<MultiVersionModInfo, MultiVersionModData>>();
    static final Map<String, Manifest> MANIFEST_MAP = new HashMap<String, Manifest>();
    static final Map<String, Object> PATH_OR_JAR_MAP = new HashMap<String, Object>();
    static final Collection<Object> IDENTIFIED_FILES = new HashSet<Object>();
    static final String COREMOD_ENGINE = "net.minecraftforge.coremod.CoreModEngine";
    static final String JAR_METADATA = "cpw.mods.jarhandling.JarMetadata";
    static final String MOD_CLASS_VISITOR = "net.minecraftforge.fml.loading.moddiscovery.ModClassVisitor";
    static final String MOD_FILE_OR_EXCEPTION = "net.minecraftforge.forgespi.locating.IModLocator$ModFileOrException";
    static final String MOD_FILE_PARSER = "net.minecraftforge.fml.loading.moddiscovery.ModFileParser";
    static final String MOD_PROVIDER = "net.minecraftforge.forgespi.locating.IModProvider";
    static final String NAMED_PATH = "cpw.mods.modlauncher.api.NamedPath";
    static final String NIGHT_CONFIG_WRAPPER = "net.minecraftforge.fml.loading.moddiscovery.NightConfigWrapper";
    static final String SCANNER = "net.minecraftforge.fml.loading.moddiscovery.Scanner";
    static final String SECURE_JAR = "cpw.mods.jarhandling.SecureJar";
    static final String SELF_ENTRYPOINT = "mods.thecomputerizer.theimpossiblelibrary.api.common.TILCommonEntryPoint";
    static final String SIMPLE_JAR_METADATA = "cpw.mods.jarhandling.impl.SimpleJarMetadata";
    static Attributes.Name automaticModuleName;
    static Function<ModFile, IModFileInfo> langProviderFileInfo;
    static BiFunction<URL, String, Path> urlToPath;
    static BiFunction<Path, Object, Manifest> pathToManifest;
    static String[] coreModExtensions;
    static BiFunction<ModFile, Collection<?>, ModFileInfo> modFileInfoCreator;
    static Class<?> dynamicModFileClass;
    static boolean fixedCoreMods;
    static boolean pathBased;
    static boolean locatorBased;
    static boolean secureLoadingFormat;
    static String workingVersion;
    static boolean scanned;
    static boolean initalized;

    private static void addFoundModPath(Object file, String type) {
        if (pathBased || !"MOD".equals(type)) {
            return;
        }
        Object foundPath = ForgeModLoading.toNamedPath((Path)Hacks.invoke(file, "getFilePath", new Object[0]));
        if (Objects.isNull(foundPath)) {
            return;
        }
        Hacks.addToCollectionField("found", foundPath, f -> Hacks.getFieldList(ModDirTransformerDiscoverer.class, "getFieldStatic", f));
    }

    private static <F> void addScannedMod(Object file, List<F> mods, String type) {
        if (locatorBased) {
            Hacks.setFieldDirect(file, "modFileType", ForgeModLoading.getModFileType(type));
            mods.add(GenericUtils.cast(file));
        } else {
            mods.add(Hacks.construct(MOD_FILE_OR_EXCEPTION, file, null));
        }
        ForgeModLoading.addFoundModPath(file, type);
    }

    static void checkPath(MultiVersionLoaderAPI loader, Path path, Predicate<Path> filter) {
        String loaderName = loader.getName();
        LOGGER.debug("[{}]: Checking if {} is the loader", (Object)loaderName, (Object)path);
        if (Objects.isNull(MultiVersionModCandidate.getLoaderFile()) && TILDev.isLoaderPath(path)) {
            LOGGER.debug("[{}]: File is the loader", (Object)loaderName);
            MultiVersionModCandidate.setLoaderPath(path);
        }
        if (filter.test(path)) {
            LOGGER.info("[{}]: Found mod candidate at {}", (Object)loaderName, (Object)path);
            loader.addPotentialModPath(path);
        }
    }

    static void checkURL(MultiVersionLoaderAPI loader, URL url, Predicate<Path> filter) {
        LOGGER.debug("[{}]: Checking URL {} for MANIFEST {}", (Object)loader.getName(), (Object)url, (Object)"META-INF/MANIFEST.MF");
        ForgeModLoading.checkPath(loader, urlToPath.apply(url, "META-INF/MANIFEST.MF"), filter);
    }

    public static Supplier<Manifest> createLoaderManfiest(Path sourcePath) {
        if (!TILDev.DEV || Objects.isNull(sourcePath) || !TILDev.isLoaderPath(sourcePath)) {
            return null;
        }
        return () -> {
            LOGGER.info("Creating loader manifest for {}", (Object)sourcePath);
            return ForgeModLoading.getDefaultManifest("theimpossiblelibrary").get();
        };
    }

    static ModFile createModFile(ModFile reference, ModFileFactory.ModFileInfoParser parser, String type, String moduleName) {
        return ForgeModLoading.createModFile(reference.getFilePath(), ForgeModLoading.modFileLocator(reference), parser, type, moduleName);
    }

    static ModFile createModFile(Path path, Object locator, ModFileFactory.ModFileInfoParser parser, String type, String moduleName) {
        if (Objects.isNull(dynamicModFileClass)) {
            LOGGER.error("Cannot create ModFile with null dynamicModFileClass! Did it fail to initialize?");
            return null;
        }
        LOGGER.debug("Creating mod file of type {} with module name {} at path {}", (Object)type, (Object)moduleName, (Object)path);
        String pathType = pathBased ? "Path" : "SecureJar";
        Object pathOrJar = null;
        boolean updatePathMap = false;
        if (Objects.nonNull(moduleName)) {
            if (PATH_OR_JAR_MAP.containsKey(moduleName)) {
                LOGGER.debug("Found existing {} for module {}", (Object)pathType, (Object)moduleName);
                pathOrJar = PATH_OR_JAR_MAP.get(moduleName);
            } else {
                updatePathMap = true;
            }
        }
        if (Objects.isNull(pathOrJar)) {
            pathOrJar = ForgeModLoading.getDefaultJar(moduleName, path);
        }
        ModFile file = (ModFile)Hacks.constructAndCast(dynamicModFileClass, pathOrJar, locator, parser, type);
        if (updatePathMap) {
            LOGGER.debug("Adding {} instance for module {} to the cache", (Object)pathType, (Object)moduleName);
            PATH_OR_JAR_MAP.put(moduleName, pathOrJar);
        }
        return file;
    }

    @Nullable
    static Class<?> dynamicModFileCreator() {
        Hacks.checkBurningWaveInit();
        String pkgName = ForgeModLoading.class.getPackage().getName();
        String className = pkgName + ".TILForgeModFile";
        byte[] byteCode = ForgeModLoading.generateModFileExtension(className);
        if (Objects.isNull(byteCode)) {
            LOGGER.error("Failed to define bytecode for {}", (Object)className);
            return null;
        }
        ASMHelper.writeDebugByteCode(className, byteCode);
        LOGGER.info("Successfully generated bytecode for {}", (Object)className);
        try {
            Class<?> defined = ClassHelper.defineAndResolveClass(ModFile.class.getClassLoader(), className, byteCode);
            LOGGER.info("Successfully generated ModFile extension {}", defined);
            if (!ForgeCoreLoader.isJava8()) {
                Hacks.setFieldDirect(defined, "module", Hacks.invoke(ForgeModLoading.class, "getModule", new Object[0]));
            }
            return defined;
        }
        catch (Throwable t) {
            LOGGER.error("Failed to generate ModFile extension {}", (Object)className, (Object)t);
            return null;
        }
    }

    static Path findFilePath(Object modFile, String ... paths) {
        Object[] objectArray;
        String method;
        Object target = pathBased ? ForgeModLoading.modFileLocator(modFile) : modFile;
        String string = method = pathBased ? "findPath" : "findResource";
        if (pathBased) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = modFile;
            objectArray = objectArray2;
            objectArray2[1] = paths;
        } else {
            objectArray = paths;
        }
        Object[] args = objectArray;
        return (Path)Hacks.invoke(target, method, args);
    }

    static void findFiles(MultiVersionLoaderAPI loader, Predicate<Path> filter, File ... files) {
        LOGGER.info("[{}]: Checking {} mod files for potential loading", (Object)loader.getName(), (Object)files.length);
        for (File mod : files) {
            LOGGER.debug("[{}]: Potentially loading mod file at path {}", (Object)loader.getName(), (Object)mod.toPath());
            ForgeModLoading.checkPath(loader, mod.toPath(), filter);
        }
    }

    public static Optional<Manifest> findManifest(Path path) {
        return ForgeModLoading.findManifest(path, ForgeModLoading.createLoaderManfiest(path));
    }

    public static Optional<Manifest> findManifest(Path path, @Nullable Supplier<Manifest> fallback) {
        Optional<Manifest> optionalManifest;
        block19: {
            optionalManifest = Optional.empty();
            try {
                File file = path.toFile();
                if (!file.exists()) {
                    LOGGER.warn("Tried to find manifest of nonexistant path {}", (Object)path);
                    break block19;
                }
                if (file.isDirectory()) {
                    File manifest = new File(file, "META-INF/MANIFEST.MF");
                    if (manifest.exists()) {
                        optionalManifest = Optional.ofNullable(ForgeModLoading.parseManifest(manifest));
                    } else {
                        LOGGER.warn("Manifest not found at {}", (Object)manifest);
                    }
                    break block19;
                }
                try (JarFile jar = new JarFile(path.toFile());){
                    Manifest manifest = jar.getManifest();
                    if (Objects.nonNull(manifest)) {
                        optionalManifest = Optional.of(manifest);
                    }
                }
            }
            catch (Throwable t) {
                LOGGER.error("Failed to find manifest for {}", (Object)path, (Object)t);
            }
        }
        return optionalManifest.isPresent() || Objects.isNull(fallback) ? optionalManifest : Optional.ofNullable(fallback.get());
    }

    public static void findPaths(ClassLoader classLoader, MultiVersionLoaderAPI loader, Object locator) {
        Predicate<Path> filter = path -> {
            if (Objects.isNull(path)) {
                return false;
            }
            Manifest manifest = pathToManifest.apply((Path)path, locator);
            if (Objects.isNull(manifest)) {
                return false;
            }
            return MultiVersionModFinder.hasMods(manifest.getMainAttributes());
        };
        ForgeModLoading.findURLs(loader, classLoader, filter);
        ForgeModLoading.findFiles(loader, filter, FileHelper.list(loader.findModRoot(), File::isFile));
    }

    static void findURLs(MultiVersionLoaderAPI loader, ClassLoader classLoader, Predicate<Path> filter) {
        try {
            Enumeration<URL> manifests = ClassLoader.getSystemClassLoader().getResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                ForgeModLoading.checkURL(loader, manifests.nextElement(), filter);
            }
        }
        catch (IOException ex) {
            LOGGER.error("[{}]: Failed to calculate URLs for paths with {} using {}", (Object)loader.getName(), (Object)"META-INF/MANIFEST.MF", (Object)classLoader, (Object)ex);
        }
    }

    public static void fixCoreModPackages() {
        HashSet<String> allowed = (HashSet<String>)Hacks.getFieldStaticDirect(COREMOD_ENGINE, "ALLOWED_PACKAGES");
        if (Objects.isNull(allowed)) {
            LOGGER.error("Failed to get ALLOWED_PACKAGES for {}! Cannot expand package whitelist", (Object)COREMOD_ENGINE);
            return;
        }
        allowed = new HashSet<String>(allowed);
        allowed.add("mods.thecomputerizer.theimpossiblelibrary.api.core");
        allowed.add("mods.thecomputerizer.theimpossiblelibrary.forge.core");
        for (String extension : coreModExtensions) {
            allowed.add("mods.thecomputerizer.theimpossiblelibrary.forge." + extension + ".core");
        }
        LOGGER.debug("Expanded coremod package whitelist to {}", allowed);
        Hacks.setFieldStaticDirect(COREMOD_ENGINE, "ALLOWED_PACKAGES", Collections.unmodifiableSet(allowed));
    }

    private static byte[] generateModFileExtension(String className) {
        Class locatorClass;
        Class pathOrJarClass = pathBased ? Path.class : Hacks.findClass(SECURE_JAR);
        Class clazz = locatorClass = locatorBased ? IModLocator.class : Hacks.findClass(MOD_PROVIDER);
        int javaVer = ForgeCoreLoader.isJava8() ? 52 : (ForgeCoreLoader.isJava21() ? 65 : 61);
        ClassWriter writer = ASMHelper.getWriter(javaVer, 1, TypeHelper.fromBinary(className), TypeHelper.get(ModFile.class));
        if (Objects.isNull(pathOrJarClass) || Objects.isNull(locatorClass)) {
            LOGGER.error("Cannot add dynamic ModFile creator! Found null parameter class {} or {}", pathOrJarClass, locatorClass);
            return null;
        }
        String constructorDesc = TypeHelper.voidMethodDesc(pathOrJarClass, locatorClass, ModFileFactory.ModFileInfoParser.class, String.class);
        String superDesc = pathBased ? TypeHelper.voidMethodDesc(pathOrJarClass, locatorClass, ModFileFactory.ModFileInfoParser.class) : constructorDesc;
        String modFile = TypeHelper.get(ModFile.class).getInternalName();
        String modLoading = TypeHelper.get(ForgeModLoading.class).getInternalName();
        String writeModsDesc = TypeHelper.methodDesc(ModFileScanData.class, ModFile.class);
        String identifyModsDesc = TypeHelper.methodDesc(Type.BOOLEAN_TYPE, ASMRef.OBJECT_TYPE);
        MethodVisitor constructor = writer.visitMethod(1, "<init>", constructorDesc, null, null);
        constructor.visitCode();
        for (int i = 0; i < (pathBased ? 4 : 5); ++i) {
            constructor.visitVarInsn(25, i);
        }
        constructor.visitMethodInsn(183, modFile, "<init>", superDesc, false);
        constructor.visitInsn(177);
        ASMHelper.finishMethod(constructor);
        MethodVisitor compileContent = writer.visitMethod(1, "compileContent", TypeHelper.methodDesc(ModFileScanData.class), null, null);
        compileContent.visitCode();
        compileContent.visitVarInsn(25, 0);
        compileContent.visitMethodInsn(184, modLoading, "writeMods", writeModsDesc, false);
        compileContent.visitInsn(176);
        ASMHelper.finishMethod(compileContent);
        MethodVisitor identifyMods = writer.visitMethod(1, "identifyMods", "()Z", null, null);
        identifyMods.visitCode();
        identifyMods.visitVarInsn(25, 0);
        identifyMods.visitMethodInsn(184, modLoading, "identifyMods", identifyModsDesc, false);
        identifyMods.visitInsn(172);
        ASMHelper.finishMethod(identifyMods);
        if (!pathBased) {
            int i;
            String findResourceDesc = TypeHelper.methodDesc(Path.class, String[].class);
            String queryCoreModsDesc = TypeHelper.voidMethodDesc(String[].class);
            MethodVisitor findResource = writer.visitMethod(1, "findResource", findResourceDesc, null, null);
            findResource.visitCode();
            for (i = 0; i < 2; ++i) {
                findResource.visitVarInsn(25, i);
            }
            findResource.visitMethodInsn(184, modLoading, "queryCoreMods", queryCoreModsDesc, false);
            for (i = 0; i < 2; ++i) {
                findResource.visitVarInsn(25, i);
            }
            findResource.visitMethodInsn(183, modFile, "findResource", findResourceDesc, false);
            findResource.visitInsn(176);
            ASMHelper.finishMethod(findResource);
        }
        return writer.toByteArray();
    }

    private static Supplier<Manifest> getDefaultManifest(String automaticModuleName) {
        return () -> {
            if (Objects.isNull(automaticModuleName)) {
                return new Manifest();
            }
            if (MANIFEST_MAP.containsKey(automaticModuleName)) {
                return MANIFEST_MAP.get(automaticModuleName);
            }
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.put(Attributes.Name.IMPLEMENTATION_TITLE, "The Impossible Library");
            attributes.put(Attributes.Name.IMPLEMENTATION_VERSION, "0.4.7");
            LOGGER.debug("Setting Automatic-Module-Name for Manifest to {}", (Object)automaticModuleName);
            ForgeModLoading.setAutomaticModuleName(manifest.getMainAttributes(), automaticModuleName);
            MANIFEST_MAP.put(automaticModuleName, manifest);
            return manifest;
        };
    }

    private static Object getDefaultJar(String moduleName, Path path) {
        if (pathBased) {
            return path;
        }
        Supplier<Manifest> defaultManifest = ForgeModLoading.getDefaultManifest(moduleName);
        if ("theimpossibleloader".equals(moduleName) || "theimpossiblelibrary".equals(moduleName)) {
            return TILLoaderJar.get(defaultManifest, moduleName, path, !locatorBased);
        }
        Function<Object, Object> jarMetadataSupplier = ForgeModLoading.getJarMetadataSupplier(path);
        return Hacks.invokeStatic(SECURE_JAR, "from", defaultManifest, jarMetadataSupplier, path);
    }

    public static IModFileInfo getFileInfo(IModFile file, Collection<?> infos) {
        if (file instanceof ModFile) {
            return (IModFileInfo)modFileInfoCreator.apply((ModFile)file, infos);
        }
        LOGGER.error("Cannot get IModFileInfo for IModFile that is not an instance of ModFile! {}", (Object)file);
        return null;
    }

    @IndirectCallers
    private static String getFirstModId(Collection<MultiVersionModInfo> infos) {
        return ForgeModLoading.getFirstModId(null, infos);
    }

    private static String getFirstModId(MultiVersionModCandidate candidate, Collection<MultiVersionModInfo> infos) {
        for (MultiVersionModInfo info : infos) {
            String modid = info.getModID();
            if (!Objects.nonNull(modid) || modid.isEmpty()) continue;
            return modid;
        }
        if (Objects.nonNull(candidate)) {
            LOGGER.debug("Returning file name for MultiVersionModCandidate as first modid");
            return candidate.getFile().getName();
        }
        LOGGER.debug("First modid not found! Returning null");
        return null;
    }

    private static Function<Object, Object> getJarMetadataSupplier(Path ... paths) {
        return secureJar -> {
            String name;
            HashSet packages = new HashSet();
            ArrayList providers = new ArrayList();
            Object manifestHolder = locatorBased ? secureJar : Hacks.invoke(secureJar, "moduleDataProvider", new Object[0]);
            Manifest manifest = (Manifest)Hacks.invoke(manifestHolder, "getManifest", new Object[0]);
            String string = name = Objects.nonNull(manifest) ? manifest.getMainAttributes().getValue(automaticModuleName) : null;
            if (Objects.isNull(name)) {
                LOGGER.info("Falling back to default jar metatdata since {} attribute was not found for: {}", (Object)automaticModuleName, (Object)paths);
                return Hacks.invokeStatic(JAR_METADATA, "from", secureJar, paths);
            }
            Object candidate = Hacks.invokeStatic(JAR_METADATA, "fromFileName", paths[0], packages, providers);
            if (Objects.isNull(candidate)) {
                LOGGER.error("Failed to get jar metadata candidate from paths {}", (Object)paths);
                return Hacks.invokeStatic(JAR_METADATA, "from", secureJar, paths);
            }
            LOGGER.debug("Returning customized JarMetadata for module {}", (Object)name);
            return Hacks.construct(SIMPLE_JAR_METADATA, name, Hacks.invoke(candidate, "version", new Object[0]), packages, providers);
        };
    }

    public static IModFile.Type getModFileType(String name) {
        if (Objects.isNull(name) || name.isEmpty()) {
            LOGGER.error("Null or empty mod file type! LIBRARY will be assumed");
            return IModFile.Type.LIBRARY;
        }
        switch (name) {
            case "GAMELIBRARY": {
                LOGGER.warn("The GAMELIBRARY mod file type is unable to be supported in all Forge versions! Please use LANGPROVIDER, LIBRARY, or MOD");
                LOGGER.warn("MOD will be assumed for now, but things could break soon");
                return IModFile.Type.MOD;
            }
            case "LANGPROVIDER": {
                return IModFile.Type.LANGPROVIDER;
            }
            case "LIBRARY": {
                return IModFile.Type.LIBRARY;
            }
            case "MOD": {
                return IModFile.Type.MOD;
            }
        }
        LOGGER.error("Unknown mod file type {}! LIBRARY will be assumed", (Object)name);
        return IModFile.Type.LIBRARY;
    }

    private static boolean hasCoreModPath(String ... paths) {
        for (String path : paths) {
            if (!path.contains("coremods.json")) continue;
            return true;
        }
        return false;
    }

    @IndirectCallers
    public static boolean identifyMods(Object file) {
        ModFile modFile = (ModFile)file;
        String fileName = modFile.getFileName();
        Path absolutePath = modFile.getFilePath().toAbsolutePath();
        LOGGER.debug("Finalizing mod identification for {} (path={})", (Object)fileName, (Object)absolutePath);
        if (!CANDIDATE_MAP.containsValue(modFile)) {
            LOGGER.warn("There are no mods to identify for {}", (Object)fileName);
            return false;
        }
        if (IDENTIFIED_FILES.contains(file)) {
            LOGGER.debug("Skipping file that was already identified {}", (Object)fileName);
        } else {
            if (pathBased) {
                ForgeModLoading.parseAndSetModFileInfo(file);
            }
            LOGGER.debug("Querying coremods for mod file {}", (Object)fileName);
            ForgeModLoading.queryCoreMods(file);
            String[] atPaths = new String[]{"META-INF", "accesstransformer.cfg"};
            Hacks.setFieldDirect(file, "accessTransformer", ForgeModLoading.findFilePath(file, atPaths));
            IDENTIFIED_FILES.add(file);
        }
        LOGGER.debug("Finalized mod identification for {} (path={})", (Object)fileName, (Object)absolutePath);
        int candidateCount = CANDIDATE_MAP.size();
        int identifiedCount = IDENTIFIED_FILES.size();
        if (identifiedCount >= candidateCount) {
            LOGGER.debug("Successfully identified {}/{} mod files", (Object)identifiedCount, (Object)candidateCount);
        }
        return true;
    }

    private static Config initConfigDependencies() {
        Config dependency = Config.inMemory();
        dependency.set("mandatory", (Object)true);
        dependency.set("modId", (Object)"theimpossiblelibrary");
        dependency.set("ordering", (Object)"AFTER");
        dependency.set("side", (Object)"BOTH");
        dependency.set("versionRange", (Object)"[0.4.0,)");
        return dependency;
    }

    private static List<Config> initConfigMods(Config config, Collection<MultiVersionModInfo> infos) {
        if (Objects.isNull(infos)) {
            return Collections.emptyList();
        }
        ArrayList<Config> mods = new ArrayList<Config>();
        boolean setLicense = false;
        for (MultiVersionModInfo info : infos) {
            if (!setLicense) {
                config.set("license", (Object)info.getLicense());
                setLicense = true;
            }
            Config mod = Config.inMemory();
            mod.set("description", (Object)info.getDescription());
            mod.set("displayName", (Object)info.getName());
            mod.set("license", (Object)info.getLicense());
            mod.set("logoFile", (Object)"logo.png");
            mod.set("modId", (Object)info.getModID());
            mod.set("version", (Object)info.getVersion());
            mods.add(mod);
        }
        if (!setLicense) {
            config.set("license", (Object)"LGPL V3");
        }
        return mods;
    }

    public static IConfigurable initFileConfig(Collection<?> infos) {
        Config config = Config.inMemory();
        config.set("modLoader", (Object)"multiversionprovider");
        config.set("loaderVersion", (Object)"[0.4.0,)");
        List<Config> mods = ForgeModLoading.initConfigMods(config, (Collection)GenericUtils.cast(infos));
        config.add("mods", mods);
        if (!mods.isEmpty() && !"theimpossiblelibrary".equals(mods.get(0).get("modId"))) {
            config.add("dependencies", new ArrayList<Config>(Collections.singletonList(ForgeModLoading.initConfigDependencies())));
        }
        return ForgeModLoading.wrapConfig((UnmodifiableConfig)config);
    }

    private static Map<MultiVersionModInfo, MultiVersionModData> initInfoMap(Collection<MultiVersionModInfo> infos) {
        HashMap<MultiVersionModInfo, MultiVersionModData> infoMap = new HashMap<MultiVersionModInfo, MultiVersionModData>();
        for (MultiVersionModInfo info : infos) {
            infoMap.put(info, null);
        }
        LOGGER.info("Created <info,data> map with {} entries for multiversion mod file ({}) using {}", (Object)infos.size(), (Object)workingVersion, infos);
        return infoMap;
    }

    public static boolean initModLoading(ClassLoader loader, Object locator, Map<String, ?> arguments) {
        if (initalized) {
            LOGGER.debug("Skipping duplicate Forge mod loading initialization call");
            return false;
        }
        LOGGER.info("Initializing Forge mod loading with args {}", arguments);
        CoreAPI core = CoreAPI.getInstance(loader);
        if (Objects.isNull(core)) {
            throw new RuntimeException("Failed to initialize Forge mod loading! Cannot find CoreAPI on " + loader);
        }
        Hacks.checkBurningWaveInit();
        ForgeModLoading.findPaths(loader, (MultiVersionLoaderAPI)Hacks.invoke(core, "getLoader", new Object[0]), locator);
        ForgeModLoading.loadMods(loader, locator, core);
        initalized = true;
        return true;
    }

    @Nullable
    private static TILBetterModScan initModScanner(ModFile file) {
        LOGGER.info("Starting multiversion mod scan");
        TILBetterModScan scan = new TILBetterModScan();
        scan.addModFileInfo(file.getModFileInfo());
        file.scanFile(p -> ForgeModLoading.scanReflectively(Hacks.construct(SCANNER, file), p, scan));
        LOGGER.debug("Injecting @Mod annotations from multiversion mod info");
        if (Objects.nonNull(scan.getAnnotations())) {
            return scan;
        }
        LOGGER.error("@Mod scan annotation set for multiversion mod is null???");
        return null;
    }

    private static IModFileInfo langFileInfo(IModFile file) {
        if (!(file instanceof ModFile)) {
            LOGGER.error("IModFile instance must extend ModFile to be supported for IModFileInfo construction!");
            return null;
        }
        return langProviderFileInfo.apply((ModFile)file);
    }

    private static Config langProviderConfig() {
        Config config = Config.inMemory();
        config.set("modLoader", (Object)"minecraft");
        config.set("loaderVersion", (Object)"1");
        Config mod = Config.inMemory();
        mod.set("modId", (Object)"multiversionprovider");
        mod.set("version", (Object)"0.4.7");
        mod.set("displayName", (Object)"Multiversion Language Provider");
        mod.set("logoFile", (Object)"logo.png");
        mod.set("authors", (Object)"The_Computerizer");
        mod.set("description", (Object)"Multiversion language loader for The Impossible Library");
        config.set("mods", new ArrayList<Config>(Collections.singletonList(mod)));
        return config;
    }

    public static ModFile langProviderModFile(ModFile reference, String moduleName) {
        return ForgeModLoading.createModFile(reference, ForgeModLoading::langFileInfo, "LANGPROVIDER", moduleName);
    }

    private static void loadCandidateInfos(Object locator, Map<?, ?> infoMap) {
        if (Objects.isNull(infoMap)) {
            LOGGER.error("Tried to load mod candidate info with null info map! locator = {}", locator);
            return;
        }
        for (Map.Entry<?, ?> entry : infoMap.entrySet()) {
            MultiVersionModCandidate candidate = (MultiVersionModCandidate)entry.getKey();
            Collection infos = (Collection)GenericUtils.cast(entry.getValue());
            if (Objects.isNull(infos)) {
                LOGGER.error("Null MultiVersionModInfo collection for candidate {}", (Object)candidate);
                continue;
            }
            ModFileFactory.ModFileInfoParser parser = file -> ForgeModLoading.getFileInfo(file, infos);
            String firstModId = ForgeModLoading.getFirstModId(candidate, infos);
            ModFile file2 = ForgeModLoading.createModFile(candidate.getFile().toPath(), locator, parser, "MOD", firstModId);
            CANDIDATE_MAP.put(candidate, file2);
            FILE_INFO_MAP.put(file2, ForgeModLoading.initInfoMap(infos));
        }
    }

    private static void loadMods(ClassLoader loader, Object locator, Object core) {
        Hacks.invoke(core, "loadCoreModInfo", loader);
        Hacks.invoke(core, "instantiateCoreMods", new Object[0]);
        Hacks.invoke(core, "writeModContainers", loader);
        ForgeModLoading.loadCandidateInfos(locator, (Map)Hacks.invoke(core, "getModInfo", new Object[0]));
    }

    private static Object modFileLocator(Object modFile) {
        return Hacks.invoke(modFile, locatorBased ? "getLocator" : "getProvider", new Object[0]);
    }

    private static TILBetterModScan onFinishedWritingMods(TILBetterModScan scan, IModFile file) {
        Object loader = Hacks.invokeDirect(file, pathBased ? "getLoader" : "getLoaders", new Object[0]);
        if (Objects.isNull(loader)) {
            LOGGER.error("Why are there no language loaders??");
        } else if (loader instanceof Collection) {
            Collection loaders = (Collection)loader;
            if (loaders.isEmpty()) {
                LOGGER.error("Why are there no language loaders??");
            } else {
                for (Object l : loaders) {
                    AFTER_WRITING_MODS.accept(scan, l);
                }
            }
        } else {
            AFTER_WRITING_MODS.accept(scan, loader);
        }
        LOGGER.debug("Finishing multiversion mod scan");
        scan.addFilePath(file.getFilePath());
        return scan;
    }

    static void parseAndSetModFileInfo(Object modFile) {
        Object modFileInfoParser = Hacks.getFieldDirect(modFile, "parser");
        if (Objects.nonNull(modFileInfoParser)) {
            LOGGER.debug("Parsing ModFileInfo for {}", modFile);
            Class c = Hacks.findClass(MOD_FILE_PARSER);
            Object modFileInfo = Hacks.invokeStatic(c, "readModList", modFile, modFileInfoParser);
            Hacks.setFieldDirect(modFile, "modFileInfo", modFileInfo);
        } else {
            LOGGER.error("Failed to get ModFileInfoParser for {}!", modFile);
        }
    }

    @Nullable
    static Manifest parseManifest(File file) {
        Manifest manifest = null;
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            manifest = new Manifest(stream);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to parse manifest from {}", (Object)file, (Object)ex);
        }
        return manifest;
    }

    public static void populateMultiversionData(Map<MultiVersionModInfo, MultiVersionModData> infoMap, Map<String, MultiVersionModData> dataMap) {
        if (Objects.isNull(dataMap)) {
            LOGGER.error("Tried to populate multiversion mod data with null data map! infoMap = {}", infoMap);
            return;
        }
        for (MultiVersionModData data : dataMap.values()) {
            MultiVersionModInfo info = data.getInfo();
            if (!infoMap.containsKey(info)) continue;
            LOGGER.debug("Populated data for {}", (Object)info);
            infoMap.put(info, data);
        }
    }

    public static void queryCoreMods(String ... resourcePaths) {
        if (!fixedCoreMods && ForgeModLoading.hasCoreModPath(resourcePaths)) {
            ForgeModLoading.fixCoreModPackages();
            fixedCoreMods = true;
        }
    }

    public static void queryCoreMods(Object file) {
        List coremods;
        try {
            coremods = (List)Hacks.invokeStaticDirect(ModFileParser.class, "getCoreMods", file);
        }
        catch (Throwable ignored) {
            coremods = Collections.emptyList();
        }
        if (Objects.nonNull(coremods)) {
            Hacks.setFieldDirect(file, "coreMods", coremods);
            if (!fixedCoreMods && !coremods.isEmpty()) {
                ForgeModLoading.fixCoreModPackages();
                fixedCoreMods = true;
            }
        }
    }

    public static <F> List<F> scanMods() {
        if (scanned) {
            LOGGER.debug("Skipping duplicate mod scan");
            return Collections.emptyList();
        }
        ClassLoader context = Thread.currentThread().getContextClassLoader();
        LOGGER.debug("Scanning for mods in multiversion jars (context = {})", (Object)context);
        ArrayList mods = new ArrayList();
        LOGGER.debug("Getting CoreAPI instance");
        CoreAPI instance = CoreAPI.getInstance();
        if (Objects.isNull(instance)) {
            LOGGER.error("Failed to get CoreAPI instance :(");
        }
        Map data = (Map)Hacks.invoke(instance, "getModData", new File("."));
        for (Map.Entry<MultiVersionModCandidate, ModFile> candidateEntry : CANDIDATE_MAP.entrySet()) {
            ModFile candidateFile = candidateEntry.getValue();
            Map<MultiVersionModInfo, MultiVersionModData> map = FILE_INFO_MAP.get(candidateFile);
            if (Objects.isNull(map)) {
                LOGGER.error("Cannot populate multiversion data with null info map! Was the getter set up correctly?");
                continue;
            }
            ForgeModLoading.populateMultiversionData(map, data);
            if (candidateEntry.getKey().getModClassNames().contains(SELF_ENTRYPOINT)) {
                LOGGER.info("Adding scanned lang provider mod {}", (Object)candidateFile);
                ForgeModLoading.addScannedMod(ForgeModLoading.langProviderModFile(candidateFile, "theimpossibleloader"), mods, "LANGPROVIDER");
            }
            LOGGER.info("Adding scanned mod {}", (Object)candidateFile);
            ForgeModLoading.addScannedMod(candidateFile, mods, "MOD");
        }
        scanned = true;
        return Collections.unmodifiableList(mods);
    }

    private static void scanReflectively(Object scanner, Path path, ModFileScanData scan) {
        LOGGER.trace("Attempting to scan multiversion jar path {}", (Object)path);
        try {
            Hacks.invokeDirect(scanner, "fileVisitor", path, scan);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to scan {}!", (Object)path, (Object)t);
        }
    }

    private static void setAutomaticModuleName(Attributes attributes, String moduleName) {
        if (Objects.isNull(automaticModuleName)) {
            automaticModuleName = new Attributes.Name("Automatic-Module-Name");
        }
        attributes.put(automaticModuleName, moduleName);
    }

    private static String[] setCoreModExtensions(String version) {
        switch (version) {
            case "16": 
            case "16_5": {
                return new String[]{"v16.m5"};
            }
            case "18": 
            case "18_2": {
                return new String[]{"v18.m2"};
            }
            case "19": 
            case "19_2": {
                return new String[]{"v19", "v19.m2"};
            }
            case "19_4": {
                return new String[]{"v19", "v19.m4"};
            }
            case "20": 
            case "20_1": {
                return new String[]{"v20", "v20.m1"};
            }
            case "20_4": {
                return new String[]{"v20", "v20.m4"};
            }
            case "20_6": {
                return new String[]{"v20", "v20.m6"};
            }
            case "21": 
            case "21_1": {
                return new String[]{"v21", "v21.m1"};
            }
        }
        return new String[0];
    }

    public static void setFileVersion(Class<?> caller, String version, String actualVersion) {
        workingVersion = version;
        pathBased = Misc.equalsAny(version, "16", "16_5");
        locatorBased = pathBased || Misc.equalsAny(version, "18", "18_2");
        secureLoadingFormat = Misc.equalsAny(version, "20_4", "20_6", "21", "21_1");
        modFileInfoCreator = ForgeModLoading.setModFileInfoCreator(version);
        dynamicModFileClass = ForgeModLoading.dynamicModFileCreator();
        langProviderFileInfo = ForgeModLoading.setLangProviderFileInfo(version);
        coreModExtensions = ForgeModLoading.setCoreModExtensions(version);
        String lClass = "net.minecraftforge.fml.loading." + (pathBased ? "LibraryFinder" : "ClasspathLocatorUtils");
        String arg2 = pathBased ? "manifest_jar" : "META-INF/MANIFEST.MF";
        urlToPath = (url, manifest) -> (Path)Hacks.invokeStatic(lClass, "findJarPathFor", manifest, arg2, url);
        pathToManifest = ForgeModLoading.setPathToManifest();
        LOGGER.info("{} Forge Locator plugin loaded on {}", (Object)actualVersion, (Object)caller.getClassLoader());
    }

    private static Function<ModFile, IModFileInfo> setLangProviderFileInfo(String version) {
        switch (version) {
            case "16": 
            case "16_5": {
                return file -> Hacks.construct(ModFileInfo.class, file, ForgeModLoading.wrapConfig((UnmodifiableConfig)ForgeModLoading.langProviderConfig()));
            }
            case "18": 
            case "18_2": 
            case "19": 
            case "19_2": 
            case "19_4": {
                return file -> Hacks.construct(ModFileInfo.class, file, ForgeModLoading.wrapConfig((UnmodifiableConfig)ForgeModLoading.langProviderConfig()), Collections.emptyList());
            }
            case "20": 
            case "20_1": 
            case "20_4": 
            case "20_6": 
            case "21": 
            case "21_1": {
                return file -> {
                    IConfigurable configWrapper = ForgeModLoading.wrapConfig((UnmodifiableConfig)ForgeModLoading.langProviderConfig());
                    Consumer<IModFileInfo> consumer = info -> Hacks.invokeDirect(configWrapper, "setFile", info);
                    List languageSpecs = Collections.emptyList();
                    return (IModFileInfo)Hacks.construct(ModFileInfo.class, file, configWrapper, consumer, languageSpecs);
                };
            }
        }
        return file -> {
            LOGGER.error("Unknown version for creating a ModFileInfo instance {}", (Object)version);
            return null;
        };
    }

    @IndirectCallers
    public static boolean setLoadingVersion(Class<?> caller) {
        if (Objects.nonNull(workingVersion)) {
            LOGGER.debug("Tried to set loading version from {} after it was already set", caller);
            return false;
        }
        String version = String.valueOf((Object)CoreAPI.gameVersion());
        String checkedVersion = version.substring(2).replace('.', '_');
        ForgeModLoading.setFileVersion(caller, checkedVersion, version);
        LOGGER.info("Successfully set Forge mod loading version ({}->{})", (Object)checkedVersion, (Object)version);
        return true;
    }

    static BiFunction<ModFile, Collection<?>, ModFileInfo> setModFileInfoCreator(String version) {
        switch (version) {
            case "16": 
            case "16_5": 
            case "18": 
            case "18_2": 
            case "19": 
            case "19_2": 
            case "19_4": {
                return (file, infos) -> Hacks.construct(ModFileInfo.class, file, ForgeModLoading.initFileConfig(infos));
            }
            case "20": 
            case "20_1": 
            case "20_4": 
            case "20_6": 
            case "21": 
            case "21_1": {
                return (file, infos) -> {
                    IConfigurable configWrapper = ForgeModLoading.initFileConfig(infos);
                    Consumer<IModFileInfo> configConsumer = info -> Hacks.invoke(configWrapper, "setFile", info);
                    return Hacks.construct(ModFileInfo.class, file, configWrapper, configConsumer);
                };
            }
        }
        LOGGER.error("Cannot set ModFileInfo creator function for unknown version {}", (Object)version);
        return (file, infos) -> null;
    }

    private static BiFunction<Path, Object, Manifest> setPathToManifest() {
        if (pathBased) {
            return (path, locator) -> {
                try {
                    Optional optional = (Optional)Hacks.invoke(locator, "findManifest", path);
                    return Objects.nonNull(optional) ? (Manifest)optional.orElse(null) : null;
                }
                catch (Throwable ignoredT) {
                    LOGGER.warn("Failed to get manifest from path {}", path);
                    return null;
                }
            };
        }
        Class jarClass = Hacks.findClass(SECURE_JAR);
        if (locatorBased) {
            return (path, ignored) -> {
                try {
                    Object jar = Hacks.invokeStatic(jarClass, "from", path);
                    return (Manifest)Hacks.invoke(jar, "getManifest", new Object[0]);
                }
                catch (Throwable ignoredT) {
                    LOGGER.warn("Failed to get manifest from path {}", path);
                    return null;
                }
            };
        }
        return (path, ignored) -> {
            try {
                Object manifestHolder = Hacks.invokeStatic(jarClass, "from", path);
                if (Objects.nonNull(manifestHolder) && !locatorBased) {
                    manifestHolder = Hacks.invoke(manifestHolder, "moduleDataProvider", new Object[0]);
                }
                return Objects.nonNull(manifestHolder) ? (Manifest)Hacks.invoke(manifestHolder, "getManifest", new Object[0]) : null;
            }
            catch (Throwable ignoredT) {
                LOGGER.warn("Failed to get manifest from path {}", path);
                return null;
            }
        };
    }

    @IndirectCallers
    public static Object stupidCast(Object o) {
        LOGGER.info("Stupidly casting {}", o);
        return o;
    }

    static Object toNamedPath(Path path) {
        if (Objects.isNull(path)) {
            return null;
        }
        String name = path.toFile().getName();
        return ForgeModLoading.toNamedPath(name.contains(".") ? name.substring(0, name.lastIndexOf(46)) : name, new Path[]{path});
    }

    static Object toNamedPath(String name, Path[] paths) {
        if (Objects.isNull(name) || Objects.isNull(paths) || paths.length == 0) {
            return null;
        }
        return Hacks.construct(NAMED_PATH, name, paths);
    }

    private static IConfigurable wrapConfig(UnmodifiableConfig config) {
        return (IConfigurable)Hacks.construct(NIGHT_CONFIG_WRAPPER, config);
    }

    private static void writeClassBytes(IModFile file, TILBetterModScan scan, MultiVersionModData data, String className, byte[] bytes) {
        scan.addWrittenClass(className, data.getInfo(), file, bytes);
        ClassVisitor visitor = (ClassVisitor)Hacks.construct(MOD_CLASS_VISITOR, new Object[0]);
        ClassReader reader = new ClassReader(bytes);
        reader.accept(visitor, 0);
        Hacks.invokeDirect(visitor, "buildData", scan.getClasses(), scan.getAnnotations());
    }

    private static void writeEntry(IModFile file, TILBetterModScan scan, Map.Entry<MultiVersionModInfo, MultiVersionModData> entry) {
        MultiVersionModInfo info = entry.getKey();
        String modid = info.getModID();
        MultiVersionModData data = entry.getValue();
        if (Objects.isNull(data)) {
            LOGGER.warn("Skipping mod injection for {} since no data exists", (Object)modid);
            return;
        }
        for (Map.Entry<String, byte[]> classBytes : data.writeModClass()) {
            ForgeModLoading.writeClassBytes(file, scan, data, classBytes.getKey(), classBytes.getValue());
        }
    }

    @IndirectCallers
    public static ModFileScanData writeMods(ModFile file) {
        TILBetterModScan scan;
        Map<MultiVersionModInfo, MultiVersionModData> infoMap = FILE_INFO_MAP.get(file);
        if (Objects.isNull(infoMap) || infoMap.isEmpty()) {
            LOGGER.error("Cannot write multiversion mods for {} with null or empty info map! {}", (Object)file, infoMap);
        }
        if (Objects.isNull((Object)(scan = ForgeModLoading.initModScanner(file)))) {
            LOGGER.error("Failed to initialize TILBetterModScan!");
            return null;
        }
        for (Map.Entry<MultiVersionModInfo, MultiVersionModData> entry : infoMap.entrySet()) {
            ForgeModLoading.writeEntry((IModFile)file, scan, entry);
        }
        return ForgeModLoading.onFinishedWritingMods(scan, (IModFile)file);
    }

    @Generated
    public static boolean isPathBased() {
        return pathBased;
    }

    @Generated
    public static boolean isLocatorBased() {
        return locatorBased;
    }

    @Generated
    public static boolean isSecureLoadingFormat() {
        return secureLoadingFormat;
    }

    @Generated
    public static String getWorkingVersion() {
        return workingVersion;
    }
}

