/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core.loader;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationHandler;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.CodeSigner;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ResolvedModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.loader.ForgeModLoading;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.loader.TILLoaderJarMetadata;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.loader.TILLoaderJarModuleDataProvider;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.ForgeModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.ModuleClassLoaderAccess;
import org.jetbrains.annotations.Nullable;

public class TILLoaderJar {
    static final Set<String> BOOT_PACKAGES = new HashSet<String>();
    static final CodeSigner[] EMPTY_CODESIGNERS = new CodeSigner[0];
    static final String MANIFEST_VERIFIER = "cpw.mods.jarhandling.impl.ManifestVerifier";
    static final String SECURE_JAR = "cpw.mods.jarhandling.SecureJar";
    final Object jarProxy;

    static Set<String> bootPackages() {
        ModuleClassLoaderAccess loader;
        ResolvedModuleAccess moudle;
        if (BOOT_PACKAGES.isEmpty() && Objects.nonNull(moudle = (loader = ForgeModuleAccess.getModuleClassLoader("BOOT")).configuration().getModule("theimpossiblebootstrap"))) {
            BOOT_PACKAGES.addAll(moudle.packages(false));
        }
        return BOOT_PACKAGES;
    }

    static Object get(Supplier<Manifest> manifestSupplier, String moduleName, Path path, boolean jarModuleData) {
        return new TILLoaderJar((Manifest)manifestSupplier.get(), (String)moduleName, (Path)path, (boolean)jarModuleData).jarProxy;
    }

    private static CodeSigner[] getSignersOrEmpty(Map<String, StatusData> dataMap, String name) {
        return TILLoaderJar.getSigners(dataMap, name, EMPTY_CODESIGNERS);
    }

    private static CodeSigner[] getSigners(Map<String, StatusData> dataMap, String name) {
        return TILLoaderJar.getSigners(dataMap, name, null);
    }

    private static CodeSigner[] getSigners(Map<String, StatusData> dataMap, String name, CodeSigner[] defaultSigners) {
        return dataMap.containsKey(name) ? dataMap.get((Object)name).signers : defaultSigners;
    }

    private static <E extends Enum<E>> E getStatus(Map<String, StatusData> dataMap, String name, boolean hasSecurityData) {
        Class enumClass = StatusData.enumClass();
        if (Objects.isNull(enumClass)) {
            return null;
        }
        if (!hasSecurityData) {
            return Enum.valueOf(enumClass, "UNVERIFIED");
        }
        return (E)(dataMap.containsKey(name) ? (Enum)GenericUtils.cast(dataMap.get((Object)name).status) : Enum.valueOf(enumClass, "NONE"));
    }

    private static boolean hasSecurityData(Object instance) {
        return Hacks.invokeDefault(false, instance, "hasSecurityData", new Object[0]);
    }

    private static Object maybeWrapProxy(Object jarProxy, TILLoaderJarModuleDataProvider provider, Path path, Object metadata) {
        return Objects.nonNull(provider.providerProxy) ? jarProxy : TILLoaderJar.wrapProxyForOldHandler(jarProxy, provider.ufs, path, metadata);
    }

    private static Object wrapProxyForOldHandler(Object jarProxy, Object fileSystem, Path path, Object metadata) {
        String jarClassName = "mods.thecomputerizer.theimpossiblelibrary.forge.v18.m2.core.loader.TILLoaderJar1_18_2";
        Class jarClass = Hacks.findClass("mods.thecomputerizer.theimpossiblelibrary.forge.v18.m2.core.loader.TILLoaderJar1_18_2", TILLoaderJar.class.getClassLoader());
        return Hacks.invokeStatic(jarClass, "get", jarProxy, fileSystem, path, metadata);
    }

    TILLoaderJar(Manifest manifest, String moduleName, Path path, boolean jarModuleData) {
        Object metadata = TILLoaderJarMetadata.get(moduleName);
        TILLoaderJarModuleDataProvider provider = TILLoaderJarModuleDataProvider.get(this, metadata, manifest, jarModuleData);
        this.jarProxy = this.createAndMaybeWrapProxy(this.getClass().getClassLoader(), manifest, metadata, provider, moduleName, path);
    }

    Object createAndMaybeWrapProxy(ClassLoader loader, Manifest manifest, Object metadata, TILLoaderJarModuleDataProvider provider, String moduleName, Path path) {
        return TILLoaderJar.maybeWrapProxy(this.createProxy(loader, manifest, provider, moduleName, path), provider, path, metadata);
    }

    Object createProxy(ClassLoader loader, Manifest manifest, TILLoaderJarModuleDataProvider provider, String moduleName, Path primaryPath) {
        Object verifier = Hacks.construct(MANIFEST_VERIFIER, new Object[0]);
        HashMap statusData = new HashMap();
        Hashtable pendingSigners = new Hashtable();
        Hashtable verifiedSigners = new Hashtable();
        Supplier<Path> primaryPathSupplier = ForgeModLoading.isSecureLoadingFormat() ? () -> primaryPath : () -> (Path)Hacks.invoke(provider.ufs, "getPrimaryPath", new Object[0]);
        InvocationHandler proxyHandler = (instance, method, args) -> {
            switch (method.getName()) {
                case "equals": {
                    return Objects.nonNull(args[0]) && args[0].hashCode() == instance.hashCode();
                }
                case "findFile": {
                    return provider.findFile((String)args[0]);
                }
                case "getFileStatus": {
                    String name = (String)args[0];
                    boolean hasSecurityData = Hacks.invokeDefault(false, instance, "hasSecurityData", new Object[0]);
                    return TILLoaderJar.getStatus(statusData, name, hasSecurityData);
                }
                case "getManifest": {
                    return provider.manifest;
                }
                case "getManifestSigners": {
                    return statusData.containsKey("META-INF/MANIFEST.MF") ? ((StatusData)statusData.get((Object)"META-INF/MANIFEST.MF")).signers : null;
                }
                case "getPackages": {
                    return TILLoaderJar.bootPackages();
                }
                case "getPath": {
                    return provider.ufs.getPath((String)args[0], (String[])args[1]);
                }
                case "getPrimaryPath": {
                    return primaryPathSupplier.get();
                }
                case "getProviders": {
                    return Collections.emptyList();
                }
                case "getRootPath": {
                    return provider.ufs.getPath("", new String[0]);
                }
                case "getTrustedManifestEntries": {
                    String name = (String)args[0];
                    Attributes attributes = manifest.getAttributes(name);
                    CodeSigner[] manifestSigners = TILLoaderJar.getSigners(statusData, "META-INF/MANIFEST.MF");
                    CodeSigner[] objectSigners = TILLoaderJar.getSignersOrEmpty(statusData, name);
                    return Objects.isNull(manifestSigners) || manifestSigners.length == objectSigners.length ? attributes : null;
                }
                case "hasSecurityData": {
                    return !pendingSigners.isEmpty() || !verifiedSigners.isEmpty();
                }
                case "hashCode": {
                    return instance.hashCode();
                }
                case "moduleDataProvider": {
                    return provider.providerProxy;
                }
                case "name": {
                    return moduleName;
                }
                case "toString": {
                    return "Jar[" + provider.uri + "]";
                }
                case "verifyAndGetSigners": {
                    if (!TILLoaderJar.hasSecurityData(instance)) {
                        return null;
                    }
                    String name = (String)args[0];
                    if (statusData.containsKey(name)) {
                        return ((StatusData)statusData.get((Object)name)).signers;
                    }
                    CodeSigner[] signers = Hacks.invokeDefault("invokeDirect", null, verifier, "verify", manifest, pendingSigners, verifiedSigners, name, args[2]);
                    if (Objects.isNull(signers)) {
                        StatusData.add(statusData, "INVALID", null);
                        return null;
                    }
                    StatusData.add(statusData, "VERIFIED", signers);
                    return signers;
                }
                case "verifyPath": {
                    Path path = (Path)GenericUtils.cast(args[0]);
                    if (Objects.isNull(path)) {
                        throw new IllegalArgumentException("Null path??");
                    }
                    if (path.getFileSystem() != provider.ufs) {
                        throw new IllegalArgumentException("Wrong filesystem");
                    }
                    String pathName = path.toString();
                    if (statusData.containsKey(pathName)) {
                        return TILLoaderJar.getStatus(statusData, pathName, TILLoaderJar.hasSecurityData(instance));
                    }
                    try {
                        byte[] bytes = Files.readAllBytes(path);
                        Hacks.invoke(instance, "verifyAndGetSigners", pathName, bytes);
                        return Hacks.invoke(instance, "getFileStatus", pathName);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
            }
            return null;
        };
        return ClassHelper.newProxy(loader, proxyHandler, SECURE_JAR, JarData.class);
    }

    static final class StatusData {
        static final String SECURE_JAR_STATUS = "cpw.mods.jarhandling.SecureJar$Status";
        static Class<Enum<?>> statusClass;
        final Enum<?> status;
        final CodeSigner[] signers;

        static void add(Map<String, StatusData> statusData, String name, @Nullable CodeSigner[] signers) {
            StatusData data = StatusData.get(name, signers);
            if (Objects.nonNull(data)) {
                statusData.put(name, data);
            }
        }

        static <E extends Enum<E>> Class<E> enumClass() {
            if (Objects.isNull(statusClass)) {
                statusClass = (Class)GenericUtils.cast(Hacks.findClass(SECURE_JAR_STATUS));
            }
            return (Class)GenericUtils.cast(statusClass);
        }

        static <E extends Enum<E>> StatusData get(String name, @Nullable CodeSigner[] signers) {
            Class<E> enumClass = StatusData.enumClass();
            if (Objects.isNull(enumClass)) {
                TILRef.logError("Enum class {} not found?? Cannot instantiate StatusData", SECURE_JAR_STATUS);
                return null;
            }
            return new StatusData((Enum<?>)Enum.valueOf(enumClass, name), signers);
        }

        StatusData(Enum<?> status, CodeSigner[] signers) {
            this.status = status;
            this.signers = signers;
        }
    }

    static interface JarData {
        @IndirectCallers
        public CodeSigner[] verifyAndGetSigners(String var1, byte[] var2);
    }
}

