/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core.loader;

import java.util.Collections;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;

public class TILLoaderJarMetadata {
    static final String JAR_METADATA = "cpw.mods.jarhandling.JarMetadata";
    static final String MODULE_DESCRIPTOR = "java.lang.module.ModuleDescriptor";
    final Object metadataProxy;
    Object descriptor;

    static Object buildNewModule(String moduleName, String version) {
        System.out.println("Building new ModuleDescriptor for " + moduleName);
        Object builder = Hacks.invokeStatic(MODULE_DESCRIPTOR, "newAutomaticModule", moduleName);
        Hacks.invoke(builder, "version", version);
        return Hacks.invoke(builder, "build", new Object[0]);
    }

    static Object get(String moduleName) {
        return new TILLoaderJarMetadata((String)moduleName, (String)"0.4.7").metadataProxy;
    }

    TILLoaderJarMetadata(String moduleName, String version) {
        this.metadataProxy = this.createProxy(this.getClass().getClassLoader(), moduleName, version);
    }

    Object createProxy(ClassLoader loader, String moduleName, String version) {
        return ClassHelper.newGenericProxy(loader, JAR_METADATA, (methodName, args) -> {
            switch (methodName) {
                case "descriptor": {
                    if (Objects.isNull(this.descriptor)) {
                        this.descriptor = TILLoaderJarMetadata.buildNewModule(moduleName, version);
                    }
                    return this.descriptor;
                }
                case "name": {
                    return moduleName;
                }
                case "providers": {
                    return Collections.emptyList();
                }
                case "version": {
                    return version;
                }
            }
            return null;
        });
    }
}

