/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core.modules;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ClassAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ConfigurationAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleLayerAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleSystemAccessor;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ResolvedModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ServicesCatalogAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.ForgeCoreLoader;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.EnvironmentAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.JarMetadataAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.LauncherAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.LayerInfoAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.ModFileAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.ModFileInfoAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.ModuleClassLoaderAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.ModuleLayerHandlerAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.SecureJarAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.SecureJarProviderAccess;
import org.apache.logging.log4j.Logger;

public class ForgeModuleAccess {
    public static final String LAYER_ENUM_CLASS = "cpw.mods.modlauncher.api.IModuleLayerManager$Layer";

    public static String calculateLayerName(ModuleLayerAccess layer) {
        if (Objects.nonNull(layer.getLayerName())) {
            return layer.getLayerName();
        }
        HashSet<String> completedLayerNames = new HashSet<String>();
        for (Enum<?> completedLayer : ForgeModuleAccess.getModuleLayerHandler().completedLayers().keySet()) {
            completedLayerNames.add(completedLayer.toString());
        }
        return ForgeModuleAccess.calculateLayerName(layer, completedLayerNames.toArray(new String[0]));
    }

    public static String calculateLayerName(ModuleLayerAccess layer, String ... validLayerNames) {
        if (Objects.nonNull(layer.getLayerName())) {
            return layer.getLayerName();
        }
        String name = "UNKNOWN-LAYER";
        for (String layerName : validLayerNames) {
            ModuleLayerAccess validLayer = ForgeModuleAccess.getModuleLayer(layerName);
            if (!Objects.nonNull(validLayer) || layer.access() != validLayer.access()) continue;
            name = layerName;
            break;
        }
        layer.setLayerName(name);
        return name;
    }

    public static String changing(String secure, String old) {
        return ForgeCoreLoader.SECURE_CLASSLOADER_FORMAT ? secure : old;
    }

    @IndirectCallers
    public static void cloneModuleTo(ModuleClassLoaderAccess loader, String moduleName, String newName) {
        ModuleLayerAccess layer = loader.getModuleLayer();
        layer.cloneModule(ForgeModuleAccess.getModuleClassLoader(layer.getLayerName()), moduleName, newName);
        loader.configuration().cloneModule(moduleName, newName);
        loader.cloneModule(moduleName, newName);
    }

    public static void combineModules(String layerName, URI combinedLocation, String combinedName, String base, String ... others) {
        ModuleClassLoaderAccess loader = ForgeModuleAccess.getModuleClassLoader(layerName);
        if (!base.equals(combinedName)) {
            loader.renameModule(base, combinedName);
        }
        loader.combineModules(combinedLocation, combinedName, others);
    }

    static Object defaultLogger() {
        return ForgeCoreLoader.getLogger();
    }

    @IndirectCallers
    public static void exportAllPackages(String ... layerNames) {
        ForgeModuleAccess.exportAllPackages(ForgeModuleAccess.defaultLogger(), layerNames);
    }

    public static void exportAllPackages(Object accessorOrLogger, String ... layerNames) {
        for (String layer : layerNames) {
            ForgeModuleAccess.getModuleLayer(layer, accessorOrLogger).exportPackagesToAll();
        }
    }

    public static String findConfigurationLayerName(ConfigurationAccess configuration) {
        Set<Enum<?>> potentialLayers = ForgeModuleAccess.getModuleLayerHandler().completedLayers().keySet();
        for (Enum<?> potentialLayer : potentialLayers) {
            String layerName = potentialLayer.toString();
            if (ForgeModuleAccess.getModuleClassLoader(layerName).configuration().access() != configuration.access()) continue;
            return layerName;
        }
        return "UNKNOWN LAYER";
    }

    @IndirectCallers
    public static ModuleAccess findModuleInAnyLayer(String moduleName) {
        return ForgeModuleAccess.findModuleInLayers(moduleName, "BOOT", "SERVICE", "PLUGIN", "GAME");
    }

    public static ModuleAccess findModuleInLayers(String moduleName, String ... layerNames) {
        for (String layerName : layerNames) {
            ModuleAccess module = ForgeModuleAccess.findModuleInLayer(moduleName, layerName);
            if (!Objects.nonNull(module)) continue;
            return module;
        }
        Logger logger = ModuleSystemAccessor.getAsLogger(ForgeModuleAccess.defaultLogger());
        logger.error("Failed to find module {} in the following layers: {}", (Object)moduleName, (Object)Arrays.toString(layerNames));
        return null;
    }

    public static ModuleAccess findModuleInLayer(String moduleName, String layerName) {
        return ForgeModuleAccess.getModuleLayer(layerName).getModule(moduleName);
    }

    public static ResolvedModuleAccess findResolvedModuleIn(String moduleName, String layerName) {
        return ForgeModuleAccess.getModuleClassLoader(layerName).configuration().getModule(moduleName);
    }

    @IndirectCallers
    public static ClassAccess getClassAccess(Class<?> clazz) {
        return Objects.nonNull(clazz) ? ModuleSystemAccessor.getClassAccess(clazz, ForgeModuleAccess.defaultLogger()) : null;
    }

    public static EnvironmentAccess getEnvironment() {
        return ForgeModuleAccess.getLauncher().environment();
    }

    public static EnvironmentAccess getEnvironment(Object accessorOrLogger) {
        return ForgeModuleAccess.getLauncher(accessorOrLogger).environment();
    }

    @IndirectCallers
    public static EnvironmentAccess getEnvironment(Object environment, Object accessorOrLogger) {
        return new EnvironmentAccess(environment, accessorOrLogger);
    }

    public static JarMetadataAccess getJarMetadata(Object jarMetadata, Object accessorOrLogger) {
        return new JarMetadataAccess(jarMetadata, accessorOrLogger);
    }

    public static LauncherAccess getLauncher() {
        return ForgeModuleAccess.getLauncher(ForgeModuleAccess.defaultLogger());
    }

    public static LauncherAccess getLauncher(Object accessorOrLogger) {
        return new LauncherAccess(accessorOrLogger);
    }

    @IndirectCallers
    public static ClassLoader getLayerClassLoader(String layerName, Object accessorOrLogger) {
        return ForgeModuleAccess.getLayerInfo(layerName, accessorOrLogger).getClassLoader();
    }

    public static Enum<?> getLayerEnum(String layerName) {
        return ForgeCoreLoader.getEnum(LAYER_ENUM_CLASS, ForgeCoreLoader.bootLoader(), layerName);
    }

    @IndirectCallers
    public static LayerInfoAccess getLayerInfo(String layerName) {
        return ForgeModuleAccess.getLayerInfo(layerName, ForgeModuleAccess.defaultLogger());
    }

    public static LayerInfoAccess getLayerInfo(String layerName, Object accessorOrLogger) {
        LayerInfoAccess layerInfo = ForgeModuleAccess.getLayerInfo(ForgeModuleAccess.getLayerEnum(layerName), accessorOrLogger);
        layerInfo.setLayerName(layerName);
        return layerInfo;
    }

    public static LayerInfoAccess getLayerInfo(Enum<?> layerEnum, Object accessorOrLogger) {
        return ForgeModuleAccess.getModuleLayerHandler(accessorOrLogger).getLayerInfo(layerEnum);
    }

    public static LayerInfoAccess getLayerInfo(Object layerInfo, Object accessorOrLogger) {
        return new LayerInfoAccess(layerInfo, accessorOrLogger);
    }

    public static ModFileAccess getModFile(Object modFile, Object accessorOrLogger) {
        return new ModFileAccess(modFile, accessorOrLogger);
    }

    public static ModFileInfoAccess getModFileInfo(Object modFileInfo) {
        return ForgeModuleAccess.getModFileInfo(modFileInfo, ForgeModuleAccess.defaultLogger());
    }

    public static ModFileInfoAccess getModFileInfo(Object modFileInfo, Object accessorOrLogger) {
        return new ModFileInfoAccess(modFileInfo, accessorOrLogger);
    }

    public static ModuleAccess getModule(Object module) {
        return ModuleSystemAccessor.getModule(module, ForgeModuleAccess.defaultLogger());
    }

    @IndirectCallers
    public static ModuleClassLoaderAccess[] getModuleClassLoaders(String ... layerNames) {
        ModuleClassLoaderAccess[] loaders = new ModuleClassLoaderAccess[layerNames.length];
        for (int i = 0; i < layerNames.length; ++i) {
            loaders[i] = ForgeModuleAccess.getModuleClassLoader(layerNames[i]);
        }
        return loaders;
    }

    public static ModuleClassLoaderAccess getModuleClassLoader(String layerName) {
        return ForgeModuleAccess.getLayerInfo(layerName, ForgeModuleAccess.defaultLogger()).getModuleClassLoader();
    }

    @IndirectCallers
    public static ModuleClassLoaderAccess getModuleClassLoader(String layerName, Object accessorOrLogger) {
        return ForgeModuleAccess.getLayerInfo(layerName, accessorOrLogger).getModuleClassLoader();
    }

    public static ModuleClassLoaderAccess getModuleClassLoader(ClassLoader loader) {
        return new ModuleClassLoaderAccess(loader, ForgeModuleAccess.defaultLogger());
    }

    public static ModuleClassLoaderAccess getModuleClassLoader(ClassLoader loader, String layerName) {
        ModuleClassLoaderAccess moduleClassLoader = ForgeModuleAccess.getModuleClassLoader(loader);
        moduleClassLoader.setLayerName(layerName);
        return moduleClassLoader;
    }

    @IndirectCallers
    public static ModuleClassLoaderAccess getModuleClassLoader(ClassLoader loader, Object accessorOrLogger) {
        return new ModuleClassLoaderAccess(loader, accessorOrLogger);
    }

    public static ModuleLayerAccess getModuleLayer(Object moduleLayer) {
        return ModuleSystemAccessor.getModuleLayer(moduleLayer, ForgeModuleAccess.defaultLogger());
    }

    public static ModuleLayerAccess getModuleLayer(String layerName) {
        return ForgeModuleAccess.getModuleLayer(layerName, ForgeModuleAccess.defaultLogger());
    }

    public static ModuleLayerAccess getModuleLayer(String layerName, Object accessorOrLogger) {
        return ForgeModuleAccess.getModuleLayerHandler(accessorOrLogger).getModuleLayer(layerName);
    }

    public static ModuleLayerHandlerAccess getModuleLayerHandler() {
        return ForgeModuleAccess.getEnvironment().getModuleLayerHandler();
    }

    public static ModuleLayerHandlerAccess getModuleLayerHandler(Object accessorOrLogger) {
        return ForgeModuleAccess.getEnvironment(accessorOrLogger).getModuleLayerHandler();
    }

    @IndirectCallers
    public static ModuleLayerHandlerAccess getModuleLayerHandler(Object moduleLayerHandler, Object accessorOrLogger) {
        return new ModuleLayerHandlerAccess(moduleLayerHandler, accessorOrLogger);
    }

    @IndirectCallers
    public static String getModuleLayerName(ModuleAccess module) {
        return ForgeModuleAccess.calculateLayerName(module.getLayer());
    }

    public static SecureJarAccess getSecureJar(Object secureJar, Object accessorOrLogger) {
        return new SecureJarAccess(secureJar, accessorOrLogger);
    }

    public static SecureJarProviderAccess getSecureJarProvider(Object provider) {
        return ForgeModuleAccess.getSecureJarProvider(provider, ForgeModuleAccess.defaultLogger());
    }

    public static SecureJarProviderAccess getSecureJarProvider(Object provider, Object accessorOrLogger) {
        return new SecureJarProviderAccess(provider, accessorOrLogger);
    }

    public static void moveModule(String layer, String targetLayer, String moduleName, boolean moveClasses) {
        ForgeModuleAccess.moveModule(ForgeModuleAccess.getModuleClassLoader(layer), ForgeModuleAccess.getModuleClassLoader(targetLayer), moduleName, moveClasses);
    }

    public static void moveModule(ModuleClassLoaderAccess sourceLoader, ModuleClassLoaderAccess targetLoader, ResolvedModuleAccess module, boolean moveClasses) {
        if (Objects.nonNull(module)) {
            ForgeModuleAccess.moveModule(sourceLoader, targetLoader, module.name(), moveClasses);
        } else {
            sourceLoader.logger().error("Cannot move null module from {} to {}", (Object)sourceLoader, (Object)targetLoader);
        }
    }

    public static void moveModule(ModuleClassLoaderAccess sourceLoader, ModuleClassLoaderAccess targetLoader, String moduleName, boolean moveClasses) {
        ModuleLayerAccess sourceLayer = sourceLoader.getModuleLayer();
        ModuleAccess module = sourceLayer.removeModuleAndReturn(moduleName);
        if (Objects.isNull(module)) {
            sourceLoader.logOrPrintError("Unable to move module " + moduleName + "! Cannot find module in supplier layer " + sourceLayer.getLayerName());
            return;
        }
        ForgeModuleAccess.moveModuleToLayer(sourceLoader, targetLoader, module, moveClasses);
    }

    private static void moveModuleClassesTo(ModuleClassLoaderAccess sourceLoader, ModuleClassLoaderAccess targetLoader, ModuleAccess module) {
        if (sourceLoader.access() != targetLoader.access()) {
            sourceLoader.moveModuleClassesTo(module, targetLoader);
        } else {
            sourceLoader.logger().info("Skipping movement of already present module {}", (Object)module.getName());
        }
    }

    public static void moveModuleToLayer(ModuleClassLoaderAccess sourceLoader, ModuleClassLoaderAccess targetLoader, ModuleAccess module, boolean moveClasses) {
        ModuleLayerAccess targetLayer = targetLoader.getModuleLayer();
        ServicesCatalogAccess targetServices = targetLayer.getServicesCatalog();
        if (moveClasses) {
            sourceLoader.logger().info("Moving classes");
            ForgeModuleAccess.moveModuleClassesTo(sourceLoader, targetLoader, module);
        }
        sourceLoader.moveModuleTo(targetLoader, module.getName());
        targetServices.registerModule(module);
        module.setLayer(targetLayer);
        module.setLoader(targetLoader);
        targetLayer.addModule(module);
    }

    @IndirectCallers
    public static void printConfigurationGraph(ConfigurationAccess configuration) {
        ForgeModuleAccess.printConfigurationGraph(configuration, true);
    }

    public static void printConfigurationGraph(ConfigurationAccess configuration, boolean printParents) {
        configuration.printGraph(ForgeModuleAccess.findConfigurationLayerName(configuration));
        if (printParents) {
            for (Object parent : configuration.parents()) {
                ForgeModuleAccess.printConfigurationGraph(ModuleSystemAccessor.getConfiguration(parent, configuration), true);
            }
        }
    }

    @IndirectCallers
    public static void removeResolvedModules(Collection<String> layerNames, String ... moduleNames) {
        for (String layerName : layerNames) {
            ForgeModuleAccess.removeResolvedModules(layerName, moduleNames);
        }
    }

    public static void removeResolvedModules(String layerName, String ... moduleNames) {
        for (String moduleName : moduleNames) {
            ForgeModuleAccess.removeResolvedModule(layerName, moduleName);
        }
    }

    public static void removeResolvedModule(String layerName, String moduleName) {
        ForgeModuleAccess.getModuleClassLoader(layerName).removeModuleFully(moduleName);
    }

    public static void renameModule(String layerName, String name, String newName) {
        ModuleClassLoaderAccess loader = ForgeModuleAccess.getModuleClassLoader(layerName);
        Logger logger = loader.logger();
        if (Objects.isNull(name) || Objects.isNull(newName)) {
            logger.error("Tried to rename {} module {} to {}", (Object)layerName, (Object)name, (Object)newName);
            return;
        }
        if (name.equals(newName)) {
            logger.info("{} module name is already equal to {}", (Object)layerName, (Object)newName);
            return;
        }
        loader.renameModule(name, newName);
    }

    @IndirectCallers
    public static void setClassModule(ClassAccess c, String layerName, String moduleName) {
        c.setModule(ForgeModuleAccess.getModuleLayer(layerName), moduleName);
    }
}

