/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v16.m5.client.render;

import mods.thecomputerizer.theimpossiblelibrary.api.client.render.VertexWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;

public class VertexWrapper1_16_5
extends VertexWrapper {
    protected final VertexFormat format;
    protected final BufferBuilder buffer;

    public VertexWrapper1_16_5(int mode, VertexFormat format, int numVertices, int ... vertexSizes) {
        super(mode, numVertices, vertexSizes);
        this.format = format;
        this.buffer = Tessellator.func_178181_a().func_178180_c();
    }

    @Override
    protected void begin() {
        this.buffer.func_181668_a(this.mode, this.format);
    }

    @Override
    protected void draw() {
        Tessellator.func_178181_a().func_78381_a();
    }

    @Override
    protected void onVertexEnded(Number[][] numbers) {
        for (int i = 0; i < numbers.length; ++i) {
            this.pushBuffer((VertexFormatElement)this.format.func_227894_c_().get(i), numbers[i]);
        }
        this.buffer.func_181675_d();
    }

    protected void pushBuffer(VertexFormatElement element, Number[] numbers) {
        VertexFormatElement.Type type = element.func_177367_b();
        int count = element.func_177368_f() / type.func_177395_a();
        VertexFormatElement.Usage usage = element.func_177375_c();
        if (numbers.length != count) {
            TILRef.logError("Incorrect buffer size {} for VertextFormatElement! (Count={}|Type={}|Usage={}!", numbers.length, count, type, usage);
            return;
        }
        switch (usage) {
            case COLOR: {
                Number r = numbers[0];
                Number g = numbers[1];
                Number b = numbers[2];
                Number a = numbers[3];
                if (r instanceof Integer || r instanceof Long || r instanceof Short) {
                    this.buffer.func_225586_a_(r.intValue(), g.intValue(), b.intValue(), a.intValue());
                } else {
                    this.buffer.func_227885_a_(r.floatValue(), g.floatValue(), b.floatValue(), a.floatValue());
                }
                return;
            }
            case NORMAL: {
                this.buffer.func_225584_a_(numbers[0].floatValue(), numbers[1].floatValue(), numbers[2].floatValue());
                return;
            }
            case POSITION: {
                this.buffer.func_225582_a_(numbers[0].doubleValue(), numbers[1].doubleValue(), numbers[2].doubleValue());
                return;
            }
            case UV: {
                Number u = numbers[0];
                Number v = numbers[1];
                if (type == VertexFormatElement.Type.FLOAT) {
                    this.buffer.func_225583_a_(u.floatValue(), v.floatValue());
                } else {
                    this.buffer.func_225587_b_(u.intValue(), v.intValue());
                }
                return;
            }
        }
        TILRef.logError("Unsupported VertextFormatElement (Count={}|Type={}|Usage={}!", count, type, usage);
    }
}

