/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v16.m5.network;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageDirectionInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageWrapperAPI;
import mods.thecomputerizer.theimpossiblelibrary.forge.v16.m5.network.Network1_16_5;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.jetbrains.annotations.Nullable;

public class NetworkForge1_16_5
extends Network1_16_5<SimpleChannel, NetworkDirection> {
    private SimpleChannel network;

    @Override
    public NetworkDirection getDirFromName(String name) {
        switch (name.toUpperCase()) {
            case "LOGIN_TO_CLIENT": {
                return NetworkDirection.LOGIN_TO_CLIENT;
            }
            case "PLAY_TO_SERVER": {
                return NetworkDirection.PLAY_TO_SERVER;
            }
            case "LOGIN_TO_SERVER": {
                return NetworkDirection.LOGIN_TO_SERVER;
            }
        }
        return NetworkDirection.PLAY_TO_CLIENT;
    }

    @Override
    public String getNameFromDir(NetworkDirection dir) {
        return dir.name();
    }

    @Override
    public NetworkDirection getDirToClient() {
        return NetworkDirection.PLAY_TO_CLIENT;
    }

    @Override
    public NetworkDirection getDirToClientLogin() {
        return NetworkDirection.LOGIN_TO_CLIENT;
    }

    @Override
    public NetworkDirection getDirToServer() {
        return NetworkDirection.PLAY_TO_SERVER;
    }

    @Override
    public NetworkDirection getDirToServerLogin() {
        return NetworkDirection.LOGIN_TO_SERVER;
    }

    @Override
    @Nullable
    public NetworkDirection getOppositeDir(NetworkDirection dir) {
        switch (dir) {
            case PLAY_TO_CLIENT: {
                return NetworkDirection.PLAY_TO_SERVER;
            }
            case PLAY_TO_SERVER: {
                return NetworkDirection.PLAY_TO_CLIENT;
            }
            case LOGIN_TO_CLIENT: {
                return NetworkDirection.LOGIN_TO_SERVER;
            }
            case LOGIN_TO_SERVER: {
                return NetworkDirection.LOGIN_TO_CLIENT;
            }
        }
        return null;
    }

    @Override
    public SimpleChannel getNetwork() {
        if (Objects.isNull(this.network)) {
            this.network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)((ResourceLocation)TILRef.res("main_network").unwrap())).clientAcceptedVersions(version -> true).serverAcceptedVersions(version -> true).networkProtocolVersion(TILRef::getNetworkVersion).simpleChannel();
        }
        return this.network;
    }

    @Override
    public boolean isDirToClient(NetworkDirection dir) {
        return dir == NetworkDirection.PLAY_TO_CLIENT || dir == NetworkDirection.LOGIN_TO_CLIENT;
    }

    @Override
    public boolean isDirLogin(NetworkDirection dir) {
        return dir == NetworkDirection.LOGIN_TO_CLIENT || dir == NetworkDirection.LOGIN_TO_SERVER;
    }

    @Override
    public void registerMessage(MessageDirectionInfo<NetworkDirection> dir, int id) {
        Class msgClass = MessageWrapperAPI.getClass(dir);
        this.getNetwork().messageBuilder(msgClass, id).encoder(MessageWrapperAPI.encoder()).decoder(MessageWrapperAPI.decoder(dir)).consumer(MessageWrapperAPI.handler(dir, Supplier::get, NetworkEvent.Context::getSender)).add();
    }

    @Override
    public <P, M extends MessageWrapperAPI<?, ?>> void sendToPlayer(M message, P player) {
        this.getNetwork().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), message);
    }

    @Override
    public <M extends MessageWrapperAPI<?, ?>> void sendToServer(M message) {
        this.getNetwork().sendToServer(message);
    }

    @Override
    public <CTX> MessageWrapperAPI<?, CTX> wrapMessage(NetworkDirection dir, MessageAPI<CTX> message) {
        MessageWrapperAPI wrapper = MessageWrapperAPI.getInstance(dir);
        if (Objects.nonNull(wrapper)) {
            wrapper.setMessage(dir, message);
        } else {
            TILRef.logError("Null message wrapper for dir {}", dir);
        }
        return wrapper;
    }

    @Override
    @SafeVarargs
    public final <CTX> MessageWrapperAPI<?, CTX> wrapMessages(NetworkDirection dir, MessageAPI<CTX> ... messages) {
        MessageWrapperAPI wrapper = MessageWrapperAPI.getInstance(dir);
        if (Objects.nonNull(wrapper)) {
            wrapper.setMessages(dir, messages);
        } else {
            TILRef.logError("Null message wrapper for dir {}", dir);
        }
        return wrapper;
    }

    @Override
    public <CTX> MessageWrapperAPI<?, CTX> wrapMessages(NetworkDirection dir, Collection<MessageAPI<CTX>> messages) {
        MessageWrapperAPI wrapper = MessageWrapperAPI.getInstance(dir);
        if (Objects.nonNull(wrapper)) {
            wrapper.setMessages(dir, messages);
        } else {
            TILRef.logError("Null message wrapper for dir {}", dir);
        }
        return wrapper;
    }
}

