/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v18.m2.client.font;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.Objects;
import java.util.function.BiConsumer;
import mods.thecomputerizer.theimpossiblelibrary.api.client.MinecraftAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.font.FontAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.forge.v18.m2.client.render.Render1_18_2;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class Font1_18_2
extends FontAPI<Font> {
    public Font1_18_2() {
        super((MinecraftAPI<?> mc) -> ((Minecraft)mc.unwrap()).f_91062_);
    }

    protected void draw(@Nullable RenderAPI renderer, @Nullable String text, BiConsumer<PoseStack, String> drawFunc) {
        if (Objects.isNull(renderer)) {
            return;
        }
        renderer.setFont(this.wrapped);
        PoseStack matrix = this.getMatrix(renderer);
        if (Objects.nonNull(matrix) && Objects.nonNull(text)) {
            drawFunc.accept(matrix, text);
        }
    }

    @Override
    public void draw(RenderAPI renderer, String text, float x, float y, int color) {
        this.draw(renderer, text, (matrix, t) -> ((Font)this.getWrapped()).m_92883_(matrix, t, x, y, color));
    }

    @Override
    public void drawInBatch(Object text, float x, float y, int color, boolean shadow, Object matrix, Object source, boolean transparent, int bgColor, int light) {
        if (text instanceof FormattedCharSequence) {
            FormattedCharSequence chars = (FormattedCharSequence)text;
            if (matrix instanceof Matrix4f) {
                Matrix4f mat4f = (Matrix4f)matrix;
                if (source instanceof MultiBufferSource) {
                    MultiBufferSource buffer = (MultiBufferSource)source;
                    ((Font)this.getWrapped()).m_92733_(chars, x, y, color, shadow, mat4f, buffer, transparent, bgColor, light);
                }
            }
        }
    }

    @Override
    public void drawWithShadow(RenderAPI renderer, String text, float x, float y, int color) {
        this.draw(renderer, text, (matrix, t) -> ((Font)this.getWrapped()).m_92750_(matrix, t, x, y, color));
    }

    @Override
    public int getCharWidth(char c) {
        return this.getStringWidth("" + c);
    }

    @Override
    public int getFontHeight() {
        Objects.requireNonNull((Font)this.getWrapped());
        return 9;
    }

    protected PoseStack getMatrix(RenderAPI renderer) {
        PoseStack poseStack;
        if (renderer instanceof Render1_18_2) {
            Render1_18_2 render18 = (Render1_18_2)renderer;
            poseStack = render18.getMatrix();
        } else {
            poseStack = null;
        }
        return poseStack;
    }

    @Override
    public int getStringWidth(String str) {
        return this.getStringWidth(str, Font::m_92895_);
    }

    @Override
    public String trimStringTo(String str, int width, boolean withReset) {
        if (Objects.isNull(str)) {
            return "";
        }
        String trimmed = ((Font)this.getWrapped()).m_92834_(str, width);
        String reset = ChatFormatting.RESET.toString();
        return !withReset && trimmed.endsWith(reset) ? trimmed.substring(0, trimmed.length() - reset.length()) : trimmed;
    }
}

