/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v20.common.biome;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.common.biome.BiomeAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;

public class Biome1_20
extends BiomeAPI<Biome> {
    static final String CLIMATE_SETTINGS;
    private static final String DOWNFALL;
    private static final String GET_TEMPERATURE;
    protected RegistryAccess access;

    public Biome1_20(Object biome) {
        super(biome instanceof Holder ? ((Holder)biome).m_203334_() : biome);
    }

    @Override
    public boolean canRain(WorldAPI<?> world, BlockPosAPI<?> pos) {
        return ((Biome)this.wrapped).m_264600_((BlockPos)pos.unwrap()) == Biome.Precipitation.RAIN;
    }

    @Override
    public boolean canSnow(WorldAPI<?> world, BlockPosAPI<?> pos) {
        return ((Biome)this.wrapped).m_264600_((BlockPos)pos.unwrap()) == Biome.Precipitation.SNOW;
    }

    @Override
    public float getRainfall() {
        Object downfall = Hacks.getRecordField(Hacks.getField(this.wrapped, CLIMATE_SETTINGS), DOWNFALL);
        if (downfall instanceof Number) {
            return ((Number)downfall).floatValue();
        }
        TILRef.logError("Failed to get rainfall for biome", new Object[0]);
        return 0.0f;
    }

    @Override
    public ResourceLocationAPI<?> getRegistryName() {
        if (Objects.isNull(this.registryName)) {
            if (Objects.isNull(this.access)) {
                ClientLevel level;
                this.access = CoreAPI.isClient() ? (Objects.nonNull(level = Minecraft.m_91087_().f_91073_) ? level.m_9598_() : RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_)) : RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
            }
            this.registryName = this.getRegistryName(this.access);
        }
        return this.registryName;
    }

    @Override
    public ResourceLocationAPI<?> getRegistryName(WorldAPI<?> world) {
        if (Objects.isNull(this.registryName)) {
            this.registryName = this.getRegistryName(((LevelAccessor)world.unwrap()).m_9598_());
        }
        return this.registryName;
    }

    protected ResourceLocationAPI<?> getRegistryName(RegistryAccess access) {
        Registry registry = access.m_6632_(Registries.f_256952_).orElse(null);
        if (Objects.isNull(registry)) {
            return null;
        }
        ResourceKey key = registry.m_7854_((Object)((Biome)this.wrapped)).orElse(null);
        return Objects.nonNull(key) ? WrapperHelper.wrapResourceLocation(key.m_135782_()) : null;
    }

    @Override
    public Set<String> getTagNames(WorldAPI<?> world) {
        LevelAccessor access = (LevelAccessor)world.unwrap();
        Registry registry = access.m_9598_().m_6632_(Registries.f_256952_).orElse(null);
        if (Objects.isNull(registry)) {
            return Collections.emptySet();
        }
        ResourceKey key = registry.m_7854_((Object)((Biome)this.wrapped)).orElse(null);
        return Objects.nonNull(key) ? this.getTagNames((Holder<Biome>)((Holder)registry.m_203636_(key).orElse(null))) : Collections.emptySet();
    }

    @Override
    protected Set<String> getTagNames(Holder<Biome> holder) {
        if (Objects.isNull(holder)) {
            return Collections.emptySet();
        }
        return holder.m_203616_().map(tagKey -> tagKey.f_203868_().toString()).collect(Collectors.toSet());
    }

    @Override
    public float getTemperatureAt(BlockPosAPI<?> pos) {
        try {
            return ((Float)Hacks.invokeDirect(this.wrapped, GET_TEMPERATURE, pos.getWrapped())).floatValue();
        }
        catch (Throwable t) {
            TILRef.logError("Failed to get temperature for biome {} at {}", this.wrapped, pos.getWrapped(), t);
            return ((Biome)this.wrapped).m_47554_();
        }
    }

    @Override
    public void setRegistryName(ResourceLocationAPI<?> registryName) {
        this.setLocalRegistryName(registryName);
    }

    @Generated
    public void setAccess(RegistryAccess access) {
        this.access = access;
    }

    static {
        Hacks.checkBurningWaveInit();
        String string = NAMED_ENV ? "climateSettings" : (CLIMATE_SETTINGS = SRG_ENV ? "f_47437_" : "field_26393");
        String string2 = NAMED_ENV ? "downfall" : (DOWNFALL = SRG_ENV ? "f_47683_" : "comp_846");
        GET_TEMPERATURE = NAMED_ENV ? "getTemperature" : (SRG_ENV ? "m_47505_" : "method_21740");
    }
}

