/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v20.m4.network;

import java.util.Collection;
import java.util.Objects;
import java.util.function.BiConsumer;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageDirectionInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageWrapperAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.forge.v20.m4.network.Network1_20_4;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;
import org.jetbrains.annotations.Nullable;

public class NetworkForge1_20_4
extends Network1_20_4<SimpleChannel, NetworkDirection> {
    private SimpleChannel network;

    static void buildMessage(SimpleChannel channel, MessageDirectionInfo<NetworkDirection> dir) {
        NetworkForge1_20_4.buildMessageHandler(channel.messageBuilder(dir.getWrapperClass()).encoder(MessageWrapperAPI::encode).decoder(buf -> (MessageWrapperAPI)GenericUtils.cast(MessageWrapperAPI.decoder(dir).apply(buf)))).add();
    }

    static <M extends MessageWrapperAPI<?, ?>> SimpleChannel.MessageBuilder<M> buildMessageHandler(SimpleChannel.MessageBuilder<M> builder) {
        BiConsumer<MessageWrapperAPI, CustomPayloadEvent.Context> networkHandler = (msg, ctx) -> {
            MessageWrapperAPI reply = msg.handle(GenericUtils.cast(ctx));
            if (Objects.nonNull(reply)) {
                if (ctx.isServerSide()) {
                    reply.setPlayer(GenericUtils.cast(ctx.getSender()));
                }
                reply.send();
            }
            ctx.setPacketHandled(true);
        };
        return builder.consumerNetworkThread(networkHandler);
    }

    @Override
    public NetworkDirection getDirFromName(String name) {
        return switch (name.toUpperCase()) {
            case "LOGIN_TO_CLIENT" -> NetworkDirection.LOGIN_TO_CLIENT;
            case "PLAY_TO_SERVER" -> NetworkDirection.PLAY_TO_SERVER;
            case "LOGIN_TO_SERVER" -> NetworkDirection.LOGIN_TO_SERVER;
            default -> NetworkDirection.PLAY_TO_CLIENT;
        };
    }

    @Override
    public String getNameFromDir(NetworkDirection dir) {
        return dir.name();
    }

    @Override
    public NetworkDirection getDirToClient() {
        return NetworkDirection.PLAY_TO_CLIENT;
    }

    @Override
    public NetworkDirection getDirToClientLogin() {
        return NetworkDirection.LOGIN_TO_CLIENT;
    }

    @Override
    public NetworkDirection getDirToServer() {
        return NetworkDirection.PLAY_TO_SERVER;
    }

    @Override
    public NetworkDirection getDirToServerLogin() {
        return NetworkDirection.LOGIN_TO_SERVER;
    }

    @Override
    @Nullable
    public NetworkDirection getOppositeDir(NetworkDirection dir) {
        return Objects.nonNull(dir) ? dir.reply() : null;
    }

    @Override
    public SimpleChannel getNetwork() {
        if (Objects.isNull(this.network)) {
            ResourceLocation name = (ResourceLocation)TILRef.res("main_network").unwrap();
            this.network = ChannelBuilder.named((ResourceLocation)name).clientAcceptedVersions((status, version) -> true).serverAcceptedVersions((status, version) -> true).networkProtocolVersion(1).simpleChannel();
        }
        return this.network;
    }

    @Override
    public boolean isDirToClient(NetworkDirection dir) {
        return dir == NetworkDirection.PLAY_TO_CLIENT || dir == NetworkDirection.LOGIN_TO_CLIENT;
    }

    @Override
    public boolean isDirLogin(NetworkDirection dir) {
        return dir == NetworkDirection.LOGIN_TO_CLIENT || dir == NetworkDirection.LOGIN_TO_SERVER;
    }

    @Override
    public void registerMessage(MessageDirectionInfo<NetworkDirection> dir, int id) {
        NetworkForge1_20_4.buildMessage(this.getNetwork(), dir);
    }

    @Override
    public <P, M extends MessageWrapperAPI<?, ?>> void sendToPlayer(M message, P player) {
        this.getNetwork().send(message, PacketDistributor.PLAYER.with((Object)((ServerPlayer)player)));
    }

    @Override
    public <M extends MessageWrapperAPI<?, ?>> void sendToServer(M message) {
        this.getNetwork().send(message, PacketDistributor.SERVER.noArg());
    }

    @Override
    public <CTX> MessageWrapperAPI<?, CTX> wrapMessage(NetworkDirection dir, MessageAPI<CTX> message) {
        MessageWrapperAPI wrapper = MessageWrapperAPI.getInstance(dir);
        if (Objects.nonNull(wrapper)) {
            wrapper.setMessage(dir, message);
        } else {
            TILRef.logError("Null message wrapper for dir {}", dir);
        }
        return wrapper;
    }

    @Override
    @SafeVarargs
    public final <CTX> MessageWrapperAPI<?, CTX> wrapMessages(NetworkDirection dir, MessageAPI<CTX> ... messages) {
        MessageWrapperAPI wrapper = MessageWrapperAPI.getInstance(dir);
        if (Objects.nonNull(wrapper)) {
            wrapper.setMessages(dir, messages);
        } else {
            TILRef.logError("Null message wrapper for dir {}", dir);
        }
        return wrapper;
    }

    @Override
    public <CTX> MessageWrapperAPI<?, CTX> wrapMessages(NetworkDirection dir, Collection<MessageAPI<CTX>> messages) {
        MessageWrapperAPI wrapper = MessageWrapperAPI.getInstance(dir);
        if (Objects.nonNull(wrapper)) {
            wrapper.setMessages(dir, messages);
        } else {
            TILRef.logError("Null message wrapper for dir {}", dir);
        }
        return wrapper;
    }
}

