/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v20.m6.registry.tab;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.tab.FutureCreativeTab;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.Nullable;

public class FutureCreativeTabForge1_20_6
extends FutureCreativeTab<CreativeModeTab> {
    private final List<ItemStack> suppliedItems = new ArrayList<ItemStack>();
    final Supplier<ResourceKey<Registry<CreativeModeTab>>> registryKey = () -> Registries.CREATIVE_MODE_TAB;

    public FutureCreativeTabForge1_20_6(ResourceLocationAPI<?> registryName) {
        super(registryName);
    }

    @Override
    public void register(@Nullable Object arg) {
        if (Objects.isNull(arg) || Objects.isNull(this.registryName)) {
            TILRef.logError("Cannot register future creative tab with null arg or registryName!", new Object[0]);
            return;
        }
        RegisterEvent event = (RegisterEvent)arg;
        ResourceLocation name = (ResourceLocation)this.registryName.unwrap();
        event.register(this.registryKey.get(), name, () -> {
            CreativeModeTab.Builder builder = new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 0).title((Component)TextHelper.getTranslated("itemGroup." + name.getPath(), new Object[0]).getAsComponent());
            if (Objects.nonNull(this.iconSupplier)) {
                builder.icon(() -> (ItemStack)this.iconSupplier.get());
            }
            this.wrapped = builder.displayItems((args, output) -> {
                for (ItemStack stack : this.suppliedItems) {
                    output.accept(stack);
                }
            }).build();
            this.registered = true;
            return (CreativeModeTab)this.wrapped;
        });
    }

    @Override
    public void supply(@Nullable Object arg, List<Supplier<ItemStackAPI<?>>> stackSuppliers) {
        if (Objects.isNull(arg)) {
            TILRef.logError("Cannot supply future creative tab with null arg!", new Object[0]);
            return;
        }
        BuildCreativeModeTabContentsEvent event = (BuildCreativeModeTabContentsEvent)arg;
        if (event.getTab() != this.wrapped) {
            return;
        }
        for (Supplier<ItemStackAPI<?>> supplier : stackSuppliers) {
            ItemStack stack = (ItemStack)supplier.get().unwrap();
            if (!event.getEntries().contains((Object)stack)) {
                event.accept(stack);
            }
            if (this.suppliedItems.contains(stack)) continue;
            this.suppliedItems.add(stack);
        }
        stackSuppliers.clear();
    }
}

