/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.client.gui;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import mods.thecomputerizer.theimpossiblelibrary.api.client.event.ClientEventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.input.KeyStateCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.EventHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.types.CommonTickableEventType;
import mods.thecomputerizer.theimpossiblelibrary.api.util.MathHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.Wrapped;
import mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.client.Minecraft1_12_2;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ScreenWrapper1_12_2
extends GuiScreen
implements Wrapped<ScreenAPI> {
    private static final Set<ScreenWrapper1_12_2> TICKERS = new HashSet<ScreenWrapper1_12_2>();
    private static boolean initializedTicker;
    private final ScreenAPI wrapped;
    private boolean isOpen;

    private static void addTicker(ScreenWrapper1_12_2 wrapper) {
        if (Objects.nonNull(wrapper.wrapped)) {
            if (!initializedTicker) {
                ScreenWrapper1_12_2.initializeTicker();
            }
            TICKERS.add(wrapper);
        }
    }

    private static void initializeTicker() {
        EventHelper.addListener(ClientEventWrapper.ClientType.TICK_CLIENT, wrapper -> {
            if (wrapper.isPhase(CommonTickableEventType.TickPhase.END)) {
                for (ScreenWrapper1_12_2 screen : TICKERS) {
                    if (!screen.isActivelyTicking() || !screen.isOpen) continue;
                    screen.wrapped.onTick();
                }
            }
        });
        initializedTicker = true;
    }

    private static void removeTicker(ScreenWrapper1_12_2 wrapper) {
        TICKERS.remove(wrapper);
    }

    public ScreenWrapper1_12_2(@Nullable ScreenAPI wrapped) {
        this.wrapped = wrapped;
    }

    public boolean func_73868_f() {
        return Objects.isNull(this.wrapped) || this.wrapped.shouldPauseGame();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (Objects.nonNull(this.wrapped)) {
            RenderContext ctx = RenderContext.get(Minecraft1_12_2.getInstance());
            ctx.setPartialTicks(partialTicks);
            double x = -1.0 + (double)mouseX * ctx.getScale().getScreenScaleX();
            double y = 1.0 - (double)mouseY * ctx.getScale().getScreenScaleY();
            this.wrapped.draw(ctx, x, y, (double)this.field_73735_i);
        }
        this.func_73876_c();
    }

    private KeyStateCache getKeyState() {
        return new KeyStateCache(ScreenWrapper1_12_2.func_175283_s(), ScreenWrapper1_12_2.func_146271_m(), ScreenWrapper1_12_2.func_146272_n());
    }

    @Override
    public ScreenAPI getWrapped() {
        return this.wrapped;
    }

    public void func_146274_d() throws IOException {
        double scroll;
        if (Objects.nonNull(this.wrapped) && ((scroll = (double)Mouse.getEventDWheel()) > 0.0 ? this.wrapped.scrollUp(MathHelper.clamp(scroll, -1.0, 1.0)) : scroll < 0.0 && this.wrapped.scrollDown(MathHelper.clamp(scroll, -1.0, 1.0)))) {
            return;
        }
        super.func_146274_d();
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        if (Objects.nonNull(this.wrapped)) {
            this.wrapped.onScreenOpened();
        }
        ScreenWrapper1_12_2.addTicker(this);
        this.isOpen = true;
    }

    private boolean isActivelyTicking() {
        return Objects.nonNull(this.wrapped) && this.wrapped.isActivelyTicking();
    }

    protected void func_73869_a(char c, int keyCode) throws IOException {
        if (Objects.nonNull(this.wrapped)) {
            String pasted;
            String copied;
            if (keyCode == 1) {
                if (this.wrapped.onCloseRequested(true)) {
                    this.wrapped.close();
                }
                return;
            }
            if (keyCode == 14 && this.wrapped.onBackspace()) {
                return;
            }
            if (GuiScreen.func_175278_g((int)keyCode) && this.wrapped.onSelectAll()) {
                return;
            }
            if (GuiScreen.func_175280_f((int)keyCode) && Objects.nonNull(copied = this.wrapped.onCopy())) {
                GuiScreen.func_146275_d((String)copied);
                return;
            }
            if (GuiScreen.func_175279_e((int)keyCode) && this.wrapped.onPaste(pasted = GuiScreen.func_146277_j())) {
                return;
            }
            if (GuiScreen.func_175277_d((int)keyCode) && Objects.nonNull(copied = this.wrapped.onCut())) {
                GuiScreen.func_146275_d((String)copied);
                return;
            }
            if (this.wrapped.onKeyPressed(this.getKeyState(), keyCode)) {
                return;
            }
            if (ChatAllowedCharacters.func_71566_a((char)c) && this.wrapped.onCharTyped(c)) {
                return;
            }
        }
        super.func_73869_a(c, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (Objects.nonNull(this.wrapped)) {
            RenderContext ctx = RenderContext.get(Minecraft1_12_2.getInstance());
            double x = -1.0 + (double)mouseX * ctx.getScale().getScreenScaleX();
            double y = 1.0 - (double)mouseY * ctx.getScale().getScreenScaleY();
            if (mouseButton == 0) {
                this.wrapped.onLeftClick(x, y);
            } else if (mouseButton == 1) {
                this.wrapped.onRightClick(x, y);
            }
        }
    }

    public void func_146281_b() {
        this.isOpen = false;
        if (Objects.nonNull(this.wrapped)) {
            this.wrapped.onScreenClosed();
        }
        Keyboard.enableRepeatEvents((boolean)false);
        ScreenWrapper1_12_2.removeTicker(this);
    }

    public void func_175273_b(Minecraft mc, int w, int h) {
        super.func_175273_b(mc, w, h);
        if (Objects.nonNull(this.wrapped)) {
            this.wrapped.onResolutionUpdated(Minecraft1_12_2.getInstance().getWindow());
        }
    }
}

