/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.client.render;

import mods.thecomputerizer.theimpossiblelibrary.api.client.render.VertexWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;

public class VertexWrapper1_12_2
extends VertexWrapper {
    private final VertexFormat format;
    private final BufferBuilder buffer;

    public VertexWrapper1_12_2(int mode, VertexFormat format, int numVertices, int ... vertexSizes) {
        super(mode, numVertices, vertexSizes);
        this.format = format;
        this.buffer = Tessellator.func_178181_a().func_178180_c();
    }

    @Override
    protected void begin() {
        this.buffer.func_181668_a(this.mode, this.format);
    }

    @Override
    protected void draw() {
        Tessellator.func_178181_a().func_78381_a();
    }

    @Override
    protected void onVertexEnded(Number[][] numbers) {
        for (int i = 0; i < numbers.length; ++i) {
            this.pushBuffer(this.format.func_177348_c(i), numbers[i]);
        }
        this.buffer.func_181675_d();
    }

    private void pushBuffer(VertexFormatElement element, Number[] numbers) {
        int count = element.func_177370_d();
        VertexFormatElement.EnumType type = element.func_177367_b();
        VertexFormatElement.EnumUsage usage = element.func_177375_c();
        if (numbers.length != count) {
            TILRef.logError("Incorrect buffer size {} for VertextFormatElement! (Count={}|Type={}|Usage={}!", numbers.length, count, type, usage);
            return;
        }
        switch (usage) {
            case COLOR: {
                Number r = numbers[0];
                Number g = numbers[1];
                Number b = numbers[2];
                Number a = numbers[3];
                if (r instanceof Integer || r instanceof Long || r instanceof Short) {
                    this.buffer.func_181669_b(r.intValue(), g.intValue(), b.intValue(), a.intValue());
                } else {
                    this.buffer.func_181666_a(r.floatValue(), g.floatValue(), b.floatValue(), a.floatValue());
                }
                return;
            }
            case NORMAL: {
                this.buffer.func_181663_c(numbers[0].floatValue(), numbers[1].floatValue(), numbers[2].floatValue());
                return;
            }
            case POSITION: {
                this.buffer.func_181662_b(numbers[0].doubleValue(), numbers[1].doubleValue(), numbers[2].doubleValue());
                return;
            }
            case UV: {
                this.buffer.func_187315_a(numbers[0].doubleValue(), numbers[1].doubleValue());
                return;
            }
        }
        TILRef.logError("Unsupported VertextFormatElement (Count={}|Type={}|Usage={}!", count, type, usage);
    }
}

