/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.JVMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ClassPrinter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModData;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.core.asm.ModContainerWriter1_12_2;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModContainerFactory;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ContainerType;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.discovery.asm.ASMModParser;
import org.jetbrains.annotations.Nullable;

public class InjectedModCandidate1_12_2
extends ModCandidate {
    private static Map<String, MultiVersionModData> DATA_MAP;
    private static Map<File, InjectedModCandidate1_12_2> CANDIDATE_MAP;
    private final Map<String, ContainerData> containerMap = new HashMap<String, ContainerData>();

    public static ModContainer findModContainer(String modid) {
        InjectedModCandidate1_12_2 candidate = InjectedModCandidate1_12_2.getCandidate(modid);
        return Objects.nonNull((Object)candidate) ? candidate.containerMap.get((Object)modid).container : null;
    }

    public static File findSource(String modid) {
        MultiVersionModData data = InjectedModCandidate1_12_2.getModData(modid);
        return Objects.nonNull(data) ? data.getSource() : null;
    }

    @Nullable
    private static MultiVersionModData getModData(String modid) {
        Map<String, MultiVersionModData> map = InjectedModCandidate1_12_2.getModData();
        return Objects.nonNull(map) ? map.get(modid) : null;
    }

    private static Map<String, MultiVersionModData> getModData() {
        if (Objects.nonNull(DATA_MAP)) {
            return DATA_MAP;
        }
        File root = (File)Hacks.getFieldStaticDirect(Loader.class, "minecraftDir");
        DATA_MAP = CoreAPI.getInstance().getModData(root);
        return DATA_MAP;
    }

    private static Collection<MultiVersionModData> getModDataValues() {
        Map<String, MultiVersionModData> map = InjectedModCandidate1_12_2.getModData();
        return Objects.nonNull(map) ? map.values() : Collections.emptyList();
    }

    @Nullable
    private static InjectedModCandidate1_12_2 getCandidate(String modid) {
        Map<File, InjectedModCandidate1_12_2> map = InjectedModCandidate1_12_2.getCandidateMap();
        MultiVersionModData data = InjectedModCandidate1_12_2.getModData(modid);
        return Objects.nonNull(map) && Objects.nonNull(data) && Objects.nonNull(data.getSource()) ? map.get(data.getSource()) : null;
    }

    private static Map<File, InjectedModCandidate1_12_2> getCandidateMap() {
        if (Objects.nonNull(CANDIDATE_MAP)) {
            return CANDIDATE_MAP;
        }
        boolean java8 = JVMHelper.isJava8();
        CodeSource source = null;
        if (!java8) {
            ProtectionDomain pd = InjectedModCandidate1_12_2.class.getProtectionDomain();
            source = Objects.nonNull(pd) ? pd.getCodeSource() : null;
        }
        CANDIDATE_MAP = new HashMap<File, InjectedModCandidate1_12_2>();
        for (MultiVersionModData data : InjectedModCandidate1_12_2.getModDataValues()) {
            CANDIDATE_MAP.putIfAbsent(data.getSource(), new InjectedModCandidate1_12_2(data.getRoot(), data.getSource()));
            for (Map.Entry<String, byte[]> classBytes : data.writeModClass()) {
                String className = classBytes.getKey();
                byte[] bytes = classBytes.getValue();
                ASMHelper.writeDebugByteCode(className, bytes);
                Class clazz = java8 ? ClassHelper.defineClass((ClassLoader)Launch.classLoader, className, bytes) : (Class)Hacks.invoke(Launch.classLoader, "defineClass", className, bytes, source);
                ModContainerWriter1_12_2.cacheClass(Launch.classLoader, className, clazz);
                InjectedModCandidate1_12_2 candidate = CANDIDATE_MAP.get(data.getSource());
                candidate.injectMod(data.getInfo(), className, bytes);
                TILRef.logInfo("Successfully loaded mod class {}!", className);
            }
        }
        return CANDIDATE_MAP;
    }

    private static Collection<InjectedModCandidate1_12_2> getCandidateValues() {
        Map<File, InjectedModCandidate1_12_2> map = InjectedModCandidate1_12_2.getCandidateMap();
        return Objects.nonNull(map) ? map.values() : Collections.emptyList();
    }

    public static boolean injectIntoTable(ModContainer container, String pkgName, ASMDataTable table) {
        Collection<InjectedModCandidate1_12_2> candidates = InjectedModCandidate1_12_2.getCandidateValues();
        TILDev.logDebug("Checking injection for {} possible mod candidates", candidates.size());
        for (InjectedModCandidate1_12_2 candidate : candidates) {
            if (!candidate.appendToTable(container, pkgName, table)) continue;
            return true;
        }
        return false;
    }

    private InjectedModCandidate1_12_2(File root, File source) {
        super(root, source, ContainerType.JAR);
    }

    private void addContainer(ModContainer container) {
        List mods = (List)Hacks.getFieldDirect((Object)this, "mods");
        if (Objects.nonNull(mods)) {
            mods.add(container);
        } else {
            Hacks.setFieldDirect((Object)this, "mods", new ArrayList<ModContainer>(Collections.singletonList(container)));
        }
    }

    private boolean appendToTable(ModContainer container, String pkgName, ASMDataTable table) {
        TILDev.logDebug("Iterating over {} possible containers to check for type {}", this.containerMap.size(), container.getClass());
        for (ContainerData data : this.containerMap.values()) {
            TILDev.logDebug("Stored container is type {}", data.container.getClass());
            if (data.container != container) continue;
            TILDev.logDebug("Found container! Sending its data to the ASMDataTable.", new Object[0]);
            data.parser.sendToTable(table, (ModCandidate)this);
            table.addContainer(container);
            table.registerPackage((ModCandidate)this, pkgName);
            if (Objects.nonNull(Hacks.getFieldDirect(table, "containerAnnotationData"))) {
                Hacks.setFieldDirect(table, "containerAnnotationData", null);
            }
            return true;
        }
        return false;
    }

    public void injectMod(MultiVersionModInfo info, String classpath, byte[] bytes) {
        try {
            ASMModParser parser = new ASMModParser((InputStream)new ByteArrayInputStream(bytes));
            parser.validate();
            ModContainer container = ModContainerFactory.instance().build(parser, this.getModContainer(), (ModCandidate)this);
            if (Objects.nonNull(container)) {
                Map.Entry<String, String> pkgPair = ClassPrinter.splitPackage(classpath);
                this.getClassList().add(pkgPair.getKey());
                this.addContainer(container);
                this.getContainedPackages().add(pkgPair.getValue());
                container.bindMetadata((MetadataCollection)new InjectedMetaDataCollection(info));
                container.setClassVersion(parser.getClassVersion());
                this.containerMap.put(info.getModID(), new ContainerData(container, parser));
            }
        }
        catch (IOException ex) {
            TILRef.logError("Failed to parse candidate mod class `{}`", classpath, ex);
        }
    }

    private static final class ContainerData {
        final ModContainer container;
        final ASMModParser parser;

        ContainerData(ModContainer container, ASMModParser parser) {
            this.container = container;
            this.parser = parser;
        }
    }

    private static final class InjectedMetaDataCollection
    extends MetadataCollection {
        final MultiVersionModInfo info;

        InjectedMetaDataCollection(MultiVersionModInfo info) {
            this.info = info;
        }

        public ModMetadata getMetadataForId(String modId, Map<String, Object> extraData) {
            ModMetadata meta = new ModMetadata();
            meta.modId = this.info.getModID();
            meta.name = this.info.getName();
            meta.version = this.info.getVersion();
            meta.logoFile = "logo.png";
            return meta;
        }
    }
}

