/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.core.asm;

import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.JVMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.TypeHelper;
import mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.core.TILCore1_12_2;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ModDiscoverer;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ModContainerWriter1_12_2 {
    private static final Logger LOGGER = TILRef.createLogger("TIL ModContainer Writer (1.12.2)");
    private static final String INJECTED_MOD_CONTAINER = "net/minecraftforge/fml/common/InjectedModContainer";
    private static final String MOD_CONTAINER = "net/minecraftforge/fml/common/ModContainer";
    private static final Type TIL_CORE = Type.getType(TILCore1_12_2.class);

    public static void cacheClass(LaunchClassLoader launchLoader, String name, Class<?> clazz) {
        Hacks.addToMapField("cachedClasses", name, clazz, s -> (Map)Hacks.getFieldDirect(launchLoader, s));
    }

    public static ASMDataTable findASMTable(Loader loader) {
        ModDiscoverer discoverer = (ModDiscoverer)Hacks.getFieldDirect(loader, "discoverer");
        return Objects.nonNull(discoverer) ? discoverer.getASMTable() : null;
    }

    @Nullable
    public static Class<?> findCachedClass(LaunchClassLoader launchLoader, String className) {
        Map cachedClasses = (Map)Hacks.getFieldDirect(launchLoader, "cachedClasses");
        return Objects.nonNull(cachedClasses) ? (Class)cachedClasses.get(className) : null;
    }

    private static void writeClinit(ClassVisitor visitor, String modid) {
        ASMHelper.addField(visitor, 26, "MODID", ASMRef.STRING_TYPE, null, modid);
    }

    private static void writeConstructor(ClassVisitor visitor, String typeName) {
        Type container = TypeHelper.get(MOD_CONTAINER);
        MethodVisitor constructor = ASMHelper.getConstructor(visitor, 1, new Type[0]);
        constructor.visitCode();
        constructor.visitVarInsn(25, 0);
        constructor.visitFieldInsn(178, typeName, "MODID", ASMRef.STRING_TYPE.getDescriptor());
        constructor.visitMethodInsn(184, TIL_CORE.getInternalName(), "getFMLModContainer", TypeHelper.methodDesc(container, ASMRef.STRING_TYPE), false);
        constructor.visitFieldInsn(178, typeName, "MODID", ASMRef.STRING_TYPE.getDescriptor());
        constructor.visitMethodInsn(184, TIL_CORE.getInternalName(), "getModSource", TypeHelper.methodDesc(ASMRef.FILE_TYPE, ASMRef.STRING_TYPE), false);
        constructor.visitMethodInsn(183, INJECTED_MOD_CONTAINER, "<init>", TypeHelper.voidMethodDesc(container, ASMRef.FILE_TYPE), false);
        constructor.visitInsn(177);
        ASMHelper.finishMethod(constructor);
    }

    public static String writeModContainer(LaunchClassLoader launchLoader, String modid, String className) {
        Class clazz;
        try {
            if (Objects.nonNull(ModContainerWriter1_12_2.findCachedClass(launchLoader, className))) {
                LOGGER.info("Skipping write for already loaded class {}", (Object)className);
                return className;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String internalName = className.replace('.', '/');
        ClassWriter writer = ASMHelper.getWriter(JVMHelper.isJava8() ? 52 : 65, 1, internalName, INJECTED_MOD_CONTAINER);
        ModContainerWriter1_12_2.writeClinit((ClassVisitor)writer, modid);
        ModContainerWriter1_12_2.writeConstructor((ClassVisitor)writer, internalName);
        byte[] bytes = ASMHelper.finishWriting(writer, internalName, true);
        LOGGER.info("Successfully wrote bytecode for `{}`", (Object)className);
        LOGGER.info("Attempting to add class to loader {}", (Object)launchLoader.getClass().getName());
        if (JVMHelper.isJava8()) {
            clazz = ClassHelper.defineClass((ClassLoader)launchLoader, className, bytes);
        } else {
            ProtectionDomain pd = ModContainerWriter1_12_2.class.getProtectionDomain();
            CodeSource source = Objects.nonNull(pd) ? pd.getCodeSource() : null;
            clazz = (Class)Hacks.invokeDirect(launchLoader, "defineClass", className, bytes, source);
        }
        if (Objects.nonNull(clazz)) {
            ModContainerWriter1_12_2.cacheClass(launchLoader, clazz.getName(), clazz);
            return clazz.getName();
        }
        return className;
    }
}

