/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.core;

import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.NeoForgeCoreLoader;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.loader.TILLanguageLoader;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.v20.core.loader.TILLanguageLoader1_20;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforgespi.language.IModLanguageProvider;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class TILLanguageProvider
implements IModLanguageProvider {
    static final Logger LOGGER = TILRef.createLogger("TIL Language Provider (Neoforge)");
    final CoreAPI core;

    public TILLanguageProvider() {
        TILRef.logInfo("Initializing multiversion language provider (NeoForge edition)", new Object[0]);
        ClassLoader pluginLoader = NeoForgeCoreLoader.layerClassLoader(IModuleLayerManager.Layer.PLUGIN);
        this.core = NeoForgeCoreLoader.initCoreAPI(pluginLoader);
        LOGGER.info("Retrieved CoreAPI instance {} for multiversion language provider", (Object)this.core);
    }

    public Consumer<ModFileScanData> getFileVisitor() {
        Function<TILLanguageLoader1_20, String> keyMapper = TILLanguageLoader::getModid;
        Function valueMapper = Function.identity();
        BinaryOperator merger = (a, b) -> a;
        Function<ModFileScanData, Map> loaderMappper = scan -> scan.getAnnotations().stream().filter(ad -> ad.annotationType().equals((Object)Type.getType(Mod.class))).map(ad -> {
            String className = ad.clazz().getClassName();
            String value = String.valueOf(ad.annotationData().get("value"));
            TILRef.logInfo("Found @Mod class {} with id {}", className, value);
            return new TILLanguageLoader1_20(this.core, className, value, (ModFileScanData)scan);
        }).collect(Collectors.toMap(keyMapper, valueMapper, merger));
        return scan -> scan.addLanguageLoader((Map)loaderMappper.apply((ModFileScanData)scan));
    }

    public String name() {
        return "multiversionprovider";
    }
}

